/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import icons.RubyIcons;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.detector.RubyGemDetector;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyPolyVariantReferenceWithPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class GemReference
extends RubyPolyVariantReferenceWithPsiElement {
    private final RPsiElement myGemNameElement;
    @NotNull
    private final NotNullLazyValue<TextRange> myRangeProvider;

    public GemReference(@NotNull RPossibleCall rCall, RPsiElement gemName) {
        if (rCall == null) {
            GemReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)rCall);
        this.myRangeProvider = NotNullLazyValue.atomicLazy(this::computeTextRange);
        this.myGemNameElement = gemName;
    }

    private TextRange computeTextRange() {
        int relativeStartOffset;
        int start = relativeStartOffset = this.myGemNameElement.getTextOffset() - this.myElement.getTextOffset();
        if (this.myGemNameElement instanceof RBaseString) {
            PsiElement firstChild = this.myGemNameElement.getFirstChild();
            if (firstChild != null) {
                start += firstChild.getTextLength();
            }
            int end = relativeStartOffset + this.myGemNameElement.getTextLength();
            PsiElement lastChild = this.myGemNameElement.getLastChild();
            if (lastChild != null && lastChild.getNode().getElementType() == RubyTokenTypes.tSTRING_END) {
                end -= lastChild.getTextLength();
            }
            return new TextRange(start, end);
        }
        return new TextRange(relativeStartOffset, relativeStartOffset + this.myGemNameElement.getTextLength());
    }

    @NotNull
    public RPossibleCall getElement() {
        RPossibleCall rPossibleCall = (RPossibleCall)this.myElement;
        if (rPossibleCall == null) {
            GemReference.$$$reportNull$$$0(1);
        }
        return rPossibleCall;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = (TextRange)this.myRangeProvider.getValue();
        if (textRange == null) {
            GemReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public boolean hasDynamicSubstitutions() {
        if (RubyPsiUtil.isStringWithExpressionSubstitutions((PsiElement)this.myGemNameElement)) {
            return true;
        }
        for (RPsiElement element : this.getElement().getArguments()) {
            if (!RubyPsiUtil.isStringWithExpressionSubstitutions((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
        PsiFile result;
        VirtualFile file;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myGemNameElement);
        if (module == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GemDependency req = this.getDependency(false);
        if (req == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GemInfo gem = RubyProjectGemSearchService.Companion.findGem(module, req);
        VirtualFile virtualFile = file = gem != null ? gem.getLibFolder() : null;
        if (file == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                GemReference.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String lib = req.getLibScript();
        String fileName = lib != null ? lib : this.getGemName();
        VirtualFile mainFile = RFileUtil.findFileRelativeTo(file, fileName);
        PsiFile psiFile = result = mainFile != null ? this.myGemNameElement.getManager().findFile(mainFile) : null;
        if (result == null) {
            result = this.myGemNameElement.getManager().findDirectory(file);
        }
        ResolveResult[] resolveResultArray = result == null ? ResolveResult.EMPTY_ARRAY : PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{result});
        if (resolveResultArray == null) {
            GemReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public String getGemName() {
        return TextUtil.removeQuoting((String)this.myGemNameElement.getText());
    }

    @Nullable
    public GemDependency getDependency(boolean ignoreLocker) {
        if (this.getElement().getCommand() == null) {
            return null;
        }
        return RubyGemDetector.buildRequirement(this.getElement(), ignoreLocker, null);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        if (string == null) {
            GemReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            GemReference.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException("method handleElementRename is not supported in org.jetbrains.plugins.ruby.ruby.codeInsight.references.GemReference");
    }

    @Override
    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GemReference.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            GemReference.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            GemReference.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GemReference.$$$reportNull$$$0(12);
        }
        if (result == null) {
            GemReference.$$$reportNull$$$0(13);
        }
        this.processCompletions((Consumer<? super LookupElement>)((Consumer)element -> result.addElement(element)), RubyCompletionProviderUtil.lookupStringPrefixFilter(result));
    }

    public void processCompletions(@NotNull Consumer<? super LookupElement> elementConsumer, @NotNull Predicate<String> lookupStringFilter) {
        if (elementConsumer == null) {
            GemReference.$$$reportNull$$$0(14);
        }
        if (lookupStringFilter == null) {
            GemReference.$$$reportNull$$$0(15);
        }
        if (this.myGemNameElement instanceof RBaseString) {
            this.addGemNamesVariants(elementConsumer, true, lookupStringFilter);
        } else if (this.myGemNameElement instanceof RConstant && RConstantImpl.isDummyIdentifier((PsiElement)this.myGemNameElement)) {
            this.addGemNamesVariants(elementConsumer, false, lookupStringFilter);
        }
    }

    private void addGemNamesVariants(@NotNull Consumer<? super LookupElement> elementsConsumer, boolean inStringContent, @NotNull Predicate<String> lookupStringFilter) {
        if (elementsConsumer == null) {
            GemReference.$$$reportNull$$$0(16);
        }
        if (lookupStringFilter == null) {
            GemReference.$$$reportNull$$$0(17);
        }
        RFile rFile = RubyPsiUtil.getRFile(this.myElement);
        assert (rFile != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rFile);
        if (module == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (RubySdkUtil.isRubySDK(sdk)) {
            Collection<GemInfo> gems = GemManager.getInstance().getAllGems(sdk, module);
            for (List<GemInfo> groupedGems : gems.stream().collect(Collectors.groupingBy(GemInfo::getName)).values()) {
                GemInfo gemInfo = Objects.requireNonNull((GemInfo)ContainerUtil.getFirstItem(groupedGems));
                String gemName = gemInfo.getName();
                Object lookupString = inStringContent ? gemName : "'" + gemName + "'";
                String versionText = groupedGems.stream().map(GemInfo::getVersion).max(VersionComparatorUtil.COMPARATOR).orElse(null);
                if (!lookupStringFilter.test((String)lookupString)) continue;
                elementsConsumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement((String)lookupString, null, versionText, true, RubyIcons.Ruby.Ruby, null), (double)RubyCompletionGrouping.GEM_REF.getValue()));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GemReference reference = (GemReference)o;
        return !(this.myGemNameElement != null ? !this.myGemNameElement.equals((Object)reference.myGemNameElement) : reference.myGemNameElement != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGemNameElement != null ? this.myGemNameElement.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementConsumer";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupStringFilter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processCompletions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addGemNamesVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

