/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.GemOrdering;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;

public final class GemOrderingService
implements Disposable {
    @NotNull
    private static final Comparator<VirtualFile> FALLBACK_COMPARATOR = (a, b) -> 0;
    @NotNull
    private final Module myModule;
    @NotNull
    private GemOrdering myGemOrdering;

    public GemOrderingService(@NotNull Module module) {
        if (module == null) {
            GemOrderingService.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        module.getProject().getMessageBus().connect((Disposable)this).subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, module1 -> {
            if (module1 != this.myModule) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.myGemOrdering = this.createGemGraph();
            });
        });
        this.myGemOrdering = this.createGemGraph();
    }

    public void dispose() {
    }

    @NotNull
    public static Comparator<VirtualFile> getComparator(@NotNull Module module) {
        GemOrderingService service;
        if (module == null) {
            GemOrderingService.$$$reportNull$$$0(1);
        }
        if ((service = (GemOrderingService)module.getService(GemOrderingService.class)) == null) {
            Comparator<VirtualFile> comparator = FALLBACK_COMPARATOR;
            if (comparator == null) {
                GemOrderingService.$$$reportNull$$$0(2);
            }
            return comparator;
        }
        Comparator<VirtualFile> comparator = service.myGemOrdering.getComparator();
        if (comparator == null) {
            GemOrderingService.$$$reportNull$$$0(3);
        }
        return comparator;
    }

    @NotNull
    private synchronized GemOrdering createGemGraph() {
        ArrayList<GemInfo> gemInfos = new ArrayList<GemInfo>(RubyProjectGemSearchService.Companion.getAllGems(this.myModule));
        ArrayList edges = new ArrayList();
        ArrayList<Library> libraries = new ArrayList<Library>();
        LibraryTable.ModifiableModel globalLibrariesModel = GemModificationUtil.getGlobalLibraryTableModifiableModel(this.myModule.getProject());
        for (GemInfo gemInfo : gemInfos) {
            ArrayList<GemInfo> currentEdges = new ArrayList<GemInfo>();
            edges.add(currentEdges);
            for (GemDependency gemDependency : gemInfo.getDependencies()) {
                currentEdges.add((GemInfo)ContainerUtil.find(gemInfos, gemDependency::isSatisfied));
            }
            Library library = gemInfo.getLibrary(globalLibrariesModel);
            if (library == null) continue;
            libraries.add(library);
        }
        GemOrdering gemOrdering = GemOrdering.create(gemInfos, edges, libraries);
        GemModificationUtil.disposeLibraryTableModifiableModel(globalLibrariesModel);
        GemOrdering gemOrdering2 = gemOrdering;
        if (gemOrdering2 == null) {
            GemOrderingService.$$$reportNull$$$0(4);
        }
        return gemOrdering2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemOrderingService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemOrderingService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGemGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getComparator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

