/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.OutboundSemiGraph;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;

public final class GemOrdering {
    @NotNull
    private final Map<VirtualFile, GemInfo> myFile2Gem;
    @NotNull
    private final Comparator<? super GemInfo> myGemInfoComparator;
    @NotNull
    private final Comparator<VirtualFile> myComparator;

    private GemOrdering(@NotNull Map<VirtualFile, GemInfo> file2Gem, @NotNull Comparator<? super GemInfo> gemInfoComparator) {
        if (file2Gem == null) {
            GemOrdering.$$$reportNull$$$0(0);
        }
        if (gemInfoComparator == null) {
            GemOrdering.$$$reportNull$$$0(1);
        }
        this.myFile2Gem = file2Gem;
        this.myGemInfoComparator = gemInfoComparator;
        this.myComparator = (first, second) -> {
            GemInfo firstGemInfo = this.myFile2Gem.get(first.getParent());
            GemInfo secondGemInfo = this.myFile2Gem.get(second.getParent());
            if (firstGemInfo == null && secondGemInfo == null) {
                return 0;
            }
            if (firstGemInfo != null && secondGemInfo == null) {
                return -1;
            }
            if (firstGemInfo == null) {
                return 1;
            }
            return this.myGemInfoComparator.compare(firstGemInfo, secondGemInfo);
        };
    }

    @NotNull
    public Comparator<VirtualFile> getComparator() {
        Comparator<VirtualFile> comparator = this.myComparator;
        if (comparator == null) {
            GemOrdering.$$$reportNull$$$0(2);
        }
        return comparator;
    }

    @NotNull
    public static GemOrdering create(@NotNull List<GemInfo> gems, @NotNull List<? extends List<GemInfo>> edges, @NotNull List<? extends Library> libraries) {
        if (gems == null) {
            GemOrdering.$$$reportNull$$$0(3);
        }
        if (edges == null) {
            GemOrdering.$$$reportNull$$$0(4);
        }
        if (libraries == null) {
            GemOrdering.$$$reportNull$$$0(5);
        }
        Object2IntOpenHashMap myGem2Id = new Object2IntOpenHashMap();
        for (int i = 0; i < gems.size(); ++i) {
            myGem2Id.put((Object)gems.get(i), i);
        }
        Comparator<GemInfo> ordering = GemOrdering.buildOrdering(gems, edges, (Object2IntMap<GemInfo>)myGem2Id);
        HashMap<VirtualFile, GemInfo> myFile2Gem = new HashMap<VirtualFile, GemInfo>();
        for (int i = 0; i < libraries.size(); ++i) {
            int idx = i;
            for (VirtualFile virtualFile : libraries.get(i).getFiles(OrderRootType.SOURCES)) {
                VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile, it -> {
                    if (it.isDirectory()) {
                        myFile2Gem.put((VirtualFile)it, (GemInfo)gems.get(idx));
                    }
                    return true;
                });
            }
        }
        return new GemOrdering(myFile2Gem, ordering);
    }

    @NotNull
    private static Comparator<GemInfo> buildOrdering(final @NotNull List<GemInfo> gems, final @NotNull List<? extends List<GemInfo>> edges, final @NotNull Object2IntMap<GemInfo> myGem2Id) {
        if (gems == null) {
            GemOrdering.$$$reportNull$$$0(6);
        }
        if (edges == null) {
            GemOrdering.$$$reportNull$$$0(7);
        }
        if (myGem2Id == null) {
            GemOrdering.$$$reportNull$$$0(8);
        }
        DFSTBuilder dfsBuilder = new DFSTBuilder((OutboundSemiGraph)new OutboundSemiGraph<GemInfo>(){

            @NotNull
            public Collection<GemInfo> getNodes() {
                List list = gems;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public Iterator<GemInfo> getOut(GemInfo n) {
                Iterator<GemInfo> iterator = ((List)edges.get(myGem2Id.getInt((Object)n))).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/gem/GemOrdering$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        Comparator<GemInfo> comparator = dfsBuilder.comparator().reversed();
        if (comparator == null) {
            GemOrdering.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2Gem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemInfoComparator";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemOrdering";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myGem2Id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemOrdering";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOrdering";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildOrdering";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9 -> new IllegalStateException(string);
        };
    }
}

