/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.ModuleRootComponentBridge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.gem.workspace.storage.RubyGemBoxEntity;
import org.jetbrains.plugins.ruby.library.RubyLibraryProperties;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb.RubyStubBuilderService;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

@Service
public final class GemManager {
    private static final Logger LOG = Logger.getInstance(GemManager.class);
    private static final Key<Set<GemInfo>> MODULE_GEMSET = new Key("moduleGemset");
    @Topic.AppLevel
    public static final Topic<GemSetListener> GEMSET_CHANGED_TOPIC = new Topic(GemSetListener.class, Topic.BroadcastDirection.NONE);
    @Topic.ProjectLevel
    public static final Topic<ModuleGemsListener> MODULE_GEMS_CHANGED_TOPIC = new Topic(ModuleGemsListener.class, Topic.BroadcastDirection.NONE);
    @NonNls
    public static final String NOTIFICATION_ID = "Gem Manager";
    @NonNls
    public static final String MISSING_GEMS_NOTIFICATION_GROUP = "Gem Manager: Missing Gems";
    private static final Predicate<GemInfo> IS_FILE_BASED_GEM = gem -> gem != null && gem.isFromPath();

    public GemManager() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<VFileEvent> removedAndCreatedFileEvents = new ArrayList<VFileEvent>();
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (vFileEvent instanceof VFileContentChangeEvent && eventFile != null) {
                        if (!BundlerUtil.isGemfile(eventFile)) continue;
                        GemManager.invalidateDirectoryGemsCaches(eventFile);
                        continue;
                    }
                    if (vFileEvent instanceof VFileCreateEvent && eventFile != null) {
                        removedAndCreatedFileEvents.add(vFileEvent);
                        continue;
                    }
                    if (vFileEvent instanceof VFileDeleteEvent && eventFile != null) {
                        removedAndCreatedFileEvents.add(vFileEvent);
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        GemManager.invalidateDirectoryGemsCaches(((VFileMoveEvent)vFileEvent).getNewParent());
                        GemManager.invalidateDirectoryGemsCaches(((VFileMoveEvent)vFileEvent).getOldParent());
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileCopyEvent)) continue;
                    GemManager.invalidateDirectoryGemsCaches(((VFileCopyEvent)vFileEvent).getNewParent());
                }
                GemManager.invalidateDirectoryGemsCaches(removedAndCreatedFileEvents);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/gem/GemManager$1", "after"));
            }
        });
    }

    @NotNull
    public static GemManager getInstance() {
        GemManager gemManager = (GemManager)ApplicationManager.getApplication().getService(GemManager.class);
        if (gemManager == null) {
            GemManager.$$$reportNull$$$0(0);
        }
        return gemManager;
    }

    /*
     * WARNING - void declaration
     */
    private static void addRemovePathBasedGems(@NotNull ModifiableRootModel moduleModifiableModel, @NotNull Set<? extends GemInfo> actualGems, @NotNull Set<String> oldModuleLibraries) {
        void var7_9;
        if (moduleModifiableModel == null) {
            GemManager.$$$reportNull$$$0(1);
        }
        if (actualGems == null) {
            GemManager.$$$reportNull$$$0(2);
        }
        if (oldModuleLibraries == null) {
            GemManager.$$$reportNull$$$0(3);
        }
        if (actualGems.isEmpty()) {
            return;
        }
        Map<? extends VirtualFile, ? extends Module> root2ModuleMap = GemManager.getRoot2ModuleMap(moduleModifiableModel);
        LibraryTable table = moduleModifiableModel.getModuleLibraryTable();
        Library[] libraryArray = table.getLibraries();
        int n = libraryArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            Library library = libraryArray[var7_9];
            String name = library.getName();
            if (GemInfo.isPathGemLibrary(name) && oldModuleLibraries.contains(name) && GemManager.isModuleLibrary(library, root2ModuleMap)) {
                LOG.debug("Removing library: ", new Object[]{library});
                table.removeLibrary(library);
            }
            ++var7_9;
        }
        Module currentModule = moduleModifiableModel.getModule();
        for (GemInfo gemInfo : actualGems) {
            LOG.assertTrue(gemInfo.isFromPath(), (Object)("Non-path-based gem: " + String.valueOf(gemInfo)));
            Module gemModule = GemManager.findModuleForGem(gemInfo, root2ModuleMap);
            if (gemModule != null) {
                if (gemModule.equals((Object)currentModule)) continue;
                moduleModifiableModel.addModuleOrderEntry(gemModule);
                continue;
            }
            gemInfo.createLibrary(table.getModifiableModel());
        }
    }

    private static boolean isModuleLibrary(@NotNull Library library, @NotNull Map<? extends VirtualFile, ? extends Module> map) {
        if (library == null) {
            GemManager.$$$reportNull$$$0(4);
        }
        if (map == null) {
            GemManager.$$$reportNull$$$0(5);
        }
        for (String url : library.getUrls(OrderRootType.CLASSES)) {
            if (!map.containsKey(VirtualFileManager.getInstance().findFileByUrl(url))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<? extends VirtualFile, ? extends Module> getRoot2ModuleMap(@NotNull ModifiableRootModel moduleModifiableModel) {
        if (moduleModifiableModel == null) {
            GemManager.$$$reportNull$$$0(6);
        }
        HashMap result = Maps.newHashMap();
        Project project = moduleModifiableModel.getProject();
        for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)root, (Project)project);
            if (module == null) continue;
            result.put(root, module);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            GemManager.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Nullable
    private static Module findModuleForGem(@NotNull GemInfo gem, @NotNull Map<? extends VirtualFile, ? extends Module> root2ModuleMap) {
        VirtualFile gemFile;
        if (gem == null) {
            GemManager.$$$reportNull$$$0(8);
        }
        if (root2ModuleMap == null) {
            GemManager.$$$reportNull$$$0(9);
        }
        if ((gemFile = gem.getFile()) == null) {
            return null;
        }
        return root2ModuleMap.get(gemFile);
    }

    @NotNull
    public static SortedList<GemInfo> buildGemsFromPathRequirements(Set<@NotNull GemDependency> fromPath) {
        SortedList result = new SortedList(RubyGemSearchUtil.GEM_COMPARATOR);
        for (GemDependency requirement : fromPath) {
            if (!requirement.isFromPath()) continue;
            VirtualFile file = requirement.getGemRootDirectory();
            result.addAll(file != null ? GemInfo.create(null, file, true) : Collections.emptyList());
        }
        SortedList sortedList = result;
        if (sortedList == null) {
            GemManager.$$$reportNull$$$0(10);
        }
        return sortedList;
    }

    public Collection<String> getGemRootUrlsForSDK(@Nullable Sdk sdk) {
        if (sdk == null) {
            return Collections.emptySet();
        }
        ImmutableEntityStorage snapshot = GlobalWorkspaceModel.getInstance((EelMachine)LocalEelMachine.INSTANCE).getCurrentSnapshot();
        SdkId sdkId = new SdkId(sdk.getName(), sdk.getSdkType().getName());
        ArrayList<String> urls = new ArrayList<String>();
        for (RubyGemBoxEntity entity : snapshot.entities(RubyGemBoxEntity.class)) {
            if (!entity.getSdkId().equals((Object)sdkId)) continue;
            urls.add(entity.getRoot().getUrl());
        }
        return urls;
    }

    public boolean isRegistered(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        ImmutableEntityStorage snapshot = GlobalWorkspaceModel.getInstance((EelMachine)LocalEelMachine.INSTANCE).getCurrentSnapshot();
        SdkId sdkId = new SdkId(sdk.getName(), sdk.getSdkType().getName());
        for (RubyGemBoxEntity entity : snapshot.entities(RubyGemBoxEntity.class)) {
            if (entity.getSdkId().equals((Object)sdkId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<String> filterGemsetBoxUrls(@NotNull Collection<String> urls, @NotNull Collection<String> gemsets) {
        if (urls == null) {
            GemManager.$$$reportNull$$$0(11);
        }
        if (gemsets == null) {
            GemManager.$$$reportNull$$$0(12);
        }
        if (urls.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.filter(urls, url -> {
            int lastSlashIndex;
            String path = url;
            int lastGemsIndex = path.lastIndexOf("/gems");
            if (lastGemsIndex == -1) {
                return false;
            }
            int lastBundler = (path = path.substring(0, lastGemsIndex)).lastIndexOf("/bundler");
            if (lastBundler != -1) {
                path = path.substring(0, lastBundler);
            }
            if ((lastSlashIndex = path.lastIndexOf("/")) == -1) {
                return false;
            }
            return gemsets.contains(path.substring(lastSlashIndex + 1));
        });
        if (list == null) {
            GemManager.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<GemInfo> getRbenvSdkWithGemsetsGems(@NotNull Sdk sdk, @NotNull Collection<String> gemsets) {
        if (sdk == null) {
            GemManager.$$$reportNull$$$0(15);
        }
        if (gemsets == null) {
            GemManager.$$$reportNull$$$0(16);
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>(List.of(sdk));
        for (Sdk gemsetSdk : ContainerUtil.mapNotNull(gemsets, it -> RbenvGemsetManager.getGemsetSdk(sdk, it))) {
            if (!RbenvGemsetManager.isGemsetOfSdk(sdk, gemsetSdk)) continue;
            sdks.add(gemsetSdk);
        }
        List<GemInfo> list = RubyGemSearchService.getInstance().getAllGems(sdks);
        if (list == null) {
            GemManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public Collection<GemInfo> getRbenvGemsetGems(@Nullable Sdk gemsetSdk) {
        String gemset = RbenvGemsetManager.getRbenvGemset(gemsetSdk);
        if (gemset == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<GemInfo> list = RubyGemSearchService.getInstance().getAllGems(gemsetSdk);
        if (list == null) {
            GemManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public Collection<GemInfo> getAllGems(@Nullable Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<Sdk> sdks = module != null ? RbenvGemsetManager.getCurrentGemsetSdks(sdk, module) : List.of(sdk);
        List<GemInfo> list = RubyGemSearchService.getInstance().getAllGems(sdks);
        if (list == null) {
            GemManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Deprecated
    @NotNull
    public Collection<GemInfo> getAllGems(@Nullable Sdk sdk) {
        if (sdk == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (RbenvGemsetManager.isGemsetSdk(sdk)) {
            Sdk rootSdk = RbenvGemsetManager.findRootRbenvSdk(sdk);
            List<GemInfo> list = rootSdk != null ? RubyGemSearchService.getInstance().getAllGems(sdk) : Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<GemInfo> list = RubyGemSearchService.getInstance().getAllGems(sdk);
        if (list == null) {
            GemManager.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static void fireGemSetChanged(@NotNull Set<? extends VirtualFile> changedRoots, @Nullable Project project) {
        if (changedRoots == null) {
            GemManager.$$$reportNull$$$0(25);
        }
        if (changedRoots.isEmpty()) {
            return;
        }
        if (project == null) {
            GemManager.fireGemSetChanged();
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        ((GemSetListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GEMSET_CHANGED_TOPIC)).gemSetChanged(changedRoots.stream().map(file -> projectFileIndex.getModuleForFile(file, false)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    private static void fireGemSetChanged() {
        ((GemSetListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GEMSET_CHANGED_TOPIC)).gemSetChanged(null);
    }

    private static void fireModuleGemsChanged(@NotNull Module module) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(26);
        }
        ((ModuleGemsListener)module.getProject().getMessageBus().syncPublisher(MODULE_GEMS_CHANGED_TOPIC)).gemsChanged(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAllGems(@NotNull Module module, OrderEntry[] entries, Sdk sdk, Set<GemInfo> result) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(27);
        }
        Collection<GemInfo> allGems = GemManager.getInstance().getAllGems(sdk, module);
        BundlerGitLockReader locker = BundlerGitLockReader.getInstance(module);
        for (OrderEntry orderEntry : entries) {
            GemDependency dependency = GemManager.calculateDependency(locker, GemManager.getGemNameAndVersion(orderEntry));
            if (dependency == null) continue;
            Collection<GemInfo> gems = dependency.isFromPath() ? GemManager.buildGemsFromPathRequirements(Collections.singleton(dependency)) : allGems;
            GemInfo gem = (GemInfo)ContainerUtil.find(gems, dependency::isSatisfied);
            if (gem == null) continue;
            result.add(gem);
        }
        GemManager.addModuleGems(module, result);
        Module module2 = module;
        synchronized (module2) {
            if (MODULE_GEMSET.get((UserDataHolder)module) == null) {
                Disposer.register((Disposable)RubyPluginUtil.getUnloadAwareDisposable(module), () -> GemManager.cacheModuleGemset(module, null));
            }
        }
        GemManager.cacheModuleGemset(module, result);
    }

    @Nullable
    private static Pair<String, String> getGemNameAndVersion(@Nullable OrderEntry orderEntry) {
        if (orderEntry instanceof LibraryOrderEntry) {
            return GemInfo.getNameAndVersion(((LibraryOrderEntry)orderEntry).getLibraryName());
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            return GemManager.getGemNameAndVersionForModule(((ModuleOrderEntry)orderEntry).getModule());
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> getGemNameAndVersionForModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 0) {
            return null;
        }
        List<GemInfo> infos = GemInfo.create(null, roots[0], true);
        if (infos.isEmpty()) {
            return null;
        }
        GemInfo info = infos.getFirst();
        return info == null ? null : Pair.create((Object)info.getName(), (Object)info.getVersion());
    }

    @Nullable
    private static GemDependency calculateDependency(@NotNull BundlerGitLockReader locker, @Nullable Pair<String, String> gemNameAndVersion) {
        GemDependency dependency;
        if (locker == null) {
            GemManager.$$$reportNull$$$0(28);
        }
        if (gemNameAndVersion == null) {
            return null;
        }
        String gemName = (String)gemNameAndVersion.first;
        if (gemName == null) {
            return null;
        }
        if (locker.isLocked() && ((dependency = locker.getDependency(gemName)) != null || !"bundler".equals(gemName))) {
            return dependency;
        }
        return GemDependency.equal(gemName, (String)gemNameAndVersion.second);
    }

    @NotNull
    static Set<GemInfo> addModuleGems(@NotNull Module module, @NotNull Set<GemInfo> result) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(29);
        }
        if (result == null) {
            GemManager.$$$reportNull$$$0(30);
        }
        for (ModuleGemProvider provider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            ReadAction.run(() -> {
                if (!module.isDisposed()) {
                    result.addAll(provider.getGemsList(module));
                }
            });
        }
        Set<GemInfo> set = result;
        if (set == null) {
            GemManager.$$$reportNull$$$0(31);
        }
        return set;
    }

    private static void addLibrary(@NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable.ModifiableModel globalLibrariesModel, @NotNull GemInfo gemToAdd, @NotNull Set<? super String> libraries) {
        List<VirtualFile> roots;
        if (moduleRootModel == null) {
            GemManager.$$$reportNull$$$0(32);
        }
        if (globalLibrariesModel == null) {
            GemManager.$$$reportNull$$$0(33);
        }
        if (gemToAdd == null) {
            GemManager.$$$reportNull$$$0(34);
        }
        if (libraries == null) {
            GemManager.$$$reportNull$$$0(35);
        }
        if (gemToAdd.isFromPath() && (roots = Arrays.asList(moduleRootModel.getContentRoots())).contains(gemToAdd.getFile())) {
            return;
        }
        LibraryTable.ModifiableModel moduleLibrariesModel = moduleRootModel.getModuleLibraryTable().getModifiableModel();
        Library library = gemToAdd.getLibrary(moduleLibrariesModel);
        if (library != null) {
            libraries.add(gemToAdd.getLibraryName());
            return;
        }
        if (gemToAdd instanceof FrozenGemInfo) {
            gemToAdd.createLibrary(moduleLibrariesModel);
            libraries.add(gemToAdd.getLibraryName());
            return;
        }
        library = gemToAdd.getLibrary(globalLibrariesModel);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (library != null);
            VirtualFile[] roots2 = library.getFiles(OrderRootType.CLASSES);
            if (roots2.length < 1) {
                LOG.debug("No roots for the gem: " + String.valueOf(gemToAdd));
            }
            for (VirtualFile virtualFile : roots2) {
                assert (virtualFile.isValid());
            }
        }
        if (library != null) {
            LibraryEx libraryEx;
            LibraryProperties libraryProperties;
            LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(library);
            DependencyScope orderEntryScope = DependencyScope.PROVIDED;
            if (library instanceof LibraryEx && (libraryProperties = (libraryEx = (LibraryEx)library).getProperties()) instanceof RubyLibraryProperties) {
                RubyLibraryProperties rubyLibraryProperties = (RubyLibraryProperties)libraryProperties;
                String string = rubyLibraryProperties.getName();
                Set<GemDependency> dependencies = GemRequirementsHolder.getInstance(moduleRootModel.getModule()).getRequirements();
                if (ContainerUtil.exists(dependencies, dep -> dep.getName().equals(name) && dep.getGroups() != null && dep.getGroups().contains("test"))) {
                    orderEntryScope = DependencyScope.TEST;
                }
            }
            orderEntry.setScope(orderEntryScope);
        }
        libraries.add(gemToAdd.getLibraryName());
    }

    @NotNull
    public List<GemInfo> getAllGems(@Nullable Sdk sdk, @Nullable @NonNls String name) {
        if (sdk == null || name == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemManager.$$$reportNull$$$0(36);
            }
            return list;
        }
        ArrayList<GemInfo> gems = new ArrayList<GemInfo>(RubyGemSearchService.getInstance().findGems(sdk, name));
        for (Sdk gemsetSdk : RbenvGemsetManager.getGemsetsSdk(sdk)) {
            gems.addAll(RubyGemSearchService.getInstance().findGems(gemsetSdk, name));
        }
        List<GemInfo> list = Collections.unmodifiableList(gems);
        if (list == null) {
            GemManager.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static void invalidateDirectoryGemsCaches(VirtualFile file) {
        GemManager.invalidateDirectoryGemsCaches(file, null);
    }

    private static void invalidateDirectoryGemsCaches(VirtualFile file, @Nullable Project project) {
        HashSet<VirtualFile> invalidatedRoots = new HashSet<VirtualFile>();
        for (ModuleGemProvider provider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            if (!(provider instanceof DirectoryGemsProvider)) continue;
            DirectoryGemsProvider gemsProvider = (DirectoryGemsProvider)provider;
            invalidatedRoots.addAll(gemsProvider.invalidateCaches(file));
        }
        GemManager.fireGemSetChanged(invalidatedRoots, project);
    }

    private static void invalidateDirectoryGemsCaches(List<VFileEvent> removedAndCreatedFileEvents) {
        boolean hasInvalidatedRoots = false;
        for (ModuleGemProvider provider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            if (!(provider instanceof DirectoryGemsProvider)) continue;
            DirectoryGemsProvider gemsProvider = (DirectoryGemsProvider)provider;
            for (VFileEvent event : removedAndCreatedFileEvents) {
                VirtualFile virtualFile = event.getFile();
                assert (virtualFile != null);
                boolean isRemoved = event instanceof VFileDeleteEvent;
                if (isRemoved) {
                    hasInvalidatedRoots |= !gemsProvider.invalidateCaches(virtualFile.getParent()).isEmpty();
                    continue;
                }
                hasInvalidatedRoots |= !gemsProvider.invalidateCaches(virtualFile).isEmpty();
            }
        }
        if (hasInvalidatedRoots) {
            GemManager.fireGemSetChanged();
        }
    }

    @RequiresEdt
    public static void updateGemset(@NotNull Module module) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(38);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GemManager.updateGemset(module, RModuleUtil.getInstance().findRubySdkForModule(module));
    }

    public static void updateGemset(@NotNull Module module, @Nullable Sdk sdk) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(39);
        }
        ModuleRootComponentBridge moduleRootManager = (ModuleRootComponentBridge)ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel model = moduleRootManager.getModifiableModelWithoutCaching();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (GemManager.updateGemset(model, sdk)) {
                GemModificationUtil.commitModuleModifiableModel(model);
                GemManager.getAllGems(module, model.getOrderEntries(), sdk, new HashSet<GemInfo>());
                GemManager.fireModuleGemsChanged(module);
            } else {
                GemModificationUtil.disposeModuleModifiableModel(model);
            }
        });
    }

    public static boolean updateGemset(@NotNull ModifiableRootModel moduleRootModel, @Nullable Sdk sdk) {
        boolean hasChanges;
        if (moduleRootModel == null) {
            GemManager.$$$reportNull$$$0(40);
        }
        Set<String> oldDependencies = GemManager.cleanupOldDependencies(moduleRootModel);
        Module module = moduleRootModel.getModule();
        Set<GemInfo> toAdd = GemManager.getGemsToAdd(sdk, module);
        GemManager.addRemovePathBasedGems(moduleRootModel, Sets.filter(toAdd, IS_FILE_BASED_GEM), oldDependencies);
        HashSet<String> newDependencies = new HashSet<String>();
        GemManager.addLibraries(moduleRootModel, toAdd, newDependencies);
        GemManager.addModules(moduleRootModel, newDependencies);
        boolean bl = hasChanges = !Sets.symmetricDifference(oldDependencies, newDependencies).isEmpty();
        if (hasChanges) {
            RubyStubBuilderService.getInstance().requestStubsUpdate(module, toAdd);
        }
        GemManager.cacheModuleGemset(module, Collections.emptySet());
        return hasChanges;
    }

    private static void cacheModuleGemset(@NotNull Module module, @Nullable Set<GemInfo> value) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(41);
        }
        MODULE_GEMSET.set((UserDataHolder)module, value);
    }

    private static void addLibraries(@NotNull ModifiableRootModel moduleRootModel, @NotNull Set<? extends GemInfo> toAdd, @NotNull Set<String> newLibraries) {
        if (moduleRootModel == null) {
            GemManager.$$$reportNull$$$0(42);
        }
        if (toAdd == null) {
            GemManager.$$$reportNull$$$0(43);
        }
        if (newLibraries == null) {
            GemManager.$$$reportNull$$$0(44);
        }
        LibraryTable.ModifiableModel globalLibrariesModel = GemModificationUtil.getLibraryTableModifiableModel();
        for (GemInfo gemInfo : toAdd) {
            GemManager.addLibrary(moduleRootModel, globalLibrariesModel, gemInfo, newLibraries);
        }
        GemModificationUtil.disposeLibraryTableModifiableModel(globalLibrariesModel);
    }

    private static void addModules(@NotNull ModifiableRootModel rootModel, @NotNull Set<String> toAdd) {
        if (rootModel == null) {
            GemManager.$$$reportNull$$$0(45);
        }
        if (toAdd == null) {
            GemManager.$$$reportNull$$$0(46);
        }
        Project project = rootModel.getProject();
        List<Module> submodules = GemManager.findSubmodules(rootModel.getModule(), Arrays.asList(ProjectRootManager.getInstance((Project)project).getContentRoots()));
        for (Module submodule : submodules) {
            rootModel.addModuleOrderEntry(submodule);
            toAdd.add(submodule.getName());
        }
    }

    @NotNull
    private static List<Module> findSubmodules(@NotNull Module module, @NotNull List<VirtualFile> allContentRoots) {
        if (module == null) {
            GemManager.$$$reportNull$$$0(47);
        }
        if (allContentRoots == null) {
            GemManager.$$$reportNull$$$0(48);
        }
        List<VirtualFile> moduleContentRoots = Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
        HashSet<VirtualFile> childModuleRoots = new HashSet<VirtualFile>();
        Project project = module.getProject();
        List descendantRoots = ContainerUtil.filter(allContentRoots, root -> !moduleContentRoots.contains(root) && VfsUtilCore.isUnderFiles((VirtualFile)root, (Collection)moduleContentRoots));
        for (VirtualFile descendantRoot : descendantRoots) {
            if (ContainerUtil.exists(childModuleRoots, childRoot -> VfsUtilCore.isAncestor((VirtualFile)childRoot, (VirtualFile)descendantRoot, (boolean)true))) continue;
            VirtualFile gemspecFile = GemUtil.findGemspecFile(descendantRoot);
            VirtualFile gemfile = BundlerUtil.getGemfile(module.getProject(), descendantRoot);
            String gemName = (String)ObjectUtils.doIfNotNull((Object)GemSpecParser.getInstance().getGemSpec(gemfile, gemspecFile), specs -> (String)GemsSpecKeys.NAME.get((UserDataHolder)specs));
            if (gemName != null && RubyProjectGemSearchService.getInstance(module.getProject()).findGems(module, gemName).isEmpty()) continue;
            VirtualFile currentChildRoot = (VirtualFile)ContainerUtil.find(childModuleRoots, childRoot -> VfsUtilCore.isAncestor((VirtualFile)descendantRoot, (VirtualFile)childRoot, (boolean)true));
            if (currentChildRoot != null) {
                childModuleRoots.remove(currentChildRoot);
            }
            childModuleRoots.add(descendantRoot);
        }
        List<Module> list = childModuleRoots.stream().map(childRoot -> ModuleUtilCore.findModuleForFile((VirtualFile)childRoot, (Project)project)).filter(submodule -> RModuleUtil.getInstance().isRubyModule((Module)submodule)).toList();
        if (list == null) {
            GemManager.$$$reportNull$$$0(49);
        }
        return list;
    }

    private static boolean alreadyAdded(@NotNull Collection<? extends GemInfo> gems, @NotNull GemInfo gemToAdd) {
        if (gems == null) {
            GemManager.$$$reportNull$$$0(50);
        }
        if (gemToAdd == null) {
            GemManager.$$$reportNull$$$0(51);
        }
        for (GemInfo gemInfo : gems) {
            if (!gemInfo.getName().equals(gemToAdd.getName()) || !gemInfo.getVersion().equals(gemToAdd.getVersion())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<GemInfo> getGemsToAdd(@Nullable Sdk sdk, @NotNull Module module) {
        VirtualFile gemfile;
        if (module == null) {
            GemManager.$$$reportNull$$$0(52);
        }
        if ((gemfile = BundlerUtil.getGemfile(module)) != null) {
            GemManager.invalidateDirectoryGemsCaches(gemfile, module.getProject());
        }
        ModuleGemInfrastructure gemInfrastructure = ModuleGemInfrastructure.getInstance(module);
        Set<GemInfo> frozenGems = gemInfrastructure.getModuleRequiredGems(GemManager.addModuleGems(module, new HashSet<GemInfo>()));
        TreeSet toAdd = Sets.newTreeSet((Comparator)new GemComparator());
        for (GemInfo gem : gemInfrastructure.getModuleRequiredGems(GemManager.getInstance().getAllGems(sdk, module))) {
            if (GemManager.alreadyAdded(frozenGems, gem)) continue;
            toAdd.add(gem);
        }
        toAdd.addAll(frozenGems);
        TreeSet treeSet = toAdd;
        if (treeSet == null) {
            GemManager.$$$reportNull$$$0(53);
        }
        return treeSet;
    }

    @NotNull
    private static Set<String> cleanupOldDependencies(@NotNull ModifiableRootModel moduleRootModel) {
        if (moduleRootModel == null) {
            GemManager.$$$reportNull$$$0(54);
        }
        LOG.debug("cleanup old dependencies for " + moduleRootModel.getModule().getName());
        HashSet<String> oldDependencies = new HashSet<String>();
        for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
            if (orderEntry instanceof LibraryOrderEntry) {
                String name = ((LibraryOrderEntry)orderEntry).getLibraryName();
                if (name == null || !name.startsWith("[gem]") && !name.endsWith("[gem]")) continue;
                oldDependencies.add(name);
                moduleRootModel.removeOrderEntry(orderEntry);
                continue;
            }
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
            if (!RModuleUtil.getInstance().isRubyModule(moduleOrderEntry.getModule())) continue;
            oldDependencies.add(moduleOrderEntry.getModuleName());
            moduleRootModel.removeOrderEntry(orderEntry);
        }
        HashSet<String> hashSet = oldDependencies;
        if (hashSet == null) {
            GemManager.$$$reportNull$$$0(55);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 15, 16, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 54 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemManager";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModifiableModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualGems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModuleLibraries";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2ModuleMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsets";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRoots";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 38: 
            case 39: 
            case 41: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locker";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 32: 
            case 40: 
            case 42: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalLibrariesModel";
                break;
            }
            case 34: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemToAdd";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibraries";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allContentRoots";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot2ModuleMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGemsFromPathRequirements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterGemsetBoxUrls";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvSdkWithGemsetsGems";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsetGems";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGems";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleGems";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubmodules";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsToAdd";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupOldDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRemovePathBasedGems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModuleLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRoot2ModuleMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForGem";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterGemsetBoxUrls";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvSdkWithGemsetsGems";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireGemSetChanged";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleGemsChanged";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllGems";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "calculateDependency";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addModuleGems";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateGemset";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "cacheModuleGemset";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addLibraries";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addModules";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findSubmodules";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "alreadyAdded";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getGemsToAdd";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "cleanupOldDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 15, 16, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 54 -> new IllegalArgumentException(string);
        };
    }

    public static interface GemSetListener {
        public void gemSetChanged(@Nullable Set<Module> var1);
    }

    public static interface ModuleGemsListener {
        public void gemsChanged(@NotNull Module var1);
    }
}

