/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;

public final class GemInstallUtil {
    private static final Logger LOG = Logger.getInstance(GemInstallUtil.class);

    private GemInstallUtil() {
    }

    public static void installGemsInBackground(@NotNull Sdk sdk, @Nullable Module module, @NotNull Collection<GemDependency> gemsToInstall, @NotNull GemInstallCommandOptions commandOptions, @NotNull GemInstallProcessOptions processOptions) {
        if (sdk == null) {
            GemInstallUtil.$$$reportNull$$$0(0);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.$$$reportNull$$$0(1);
        }
        if (commandOptions == null) {
            GemInstallUtil.$$$reportNull$$$0(2);
        }
        if (processOptions == null) {
            GemInstallUtil.$$$reportNull$$$0(3);
        }
        List gemsToSkip = processOptions.shouldUpdateInstalledGems() ? Collections.emptyList() : GemManager.getInstance().getAllGems(sdk, module);
        LinkedHashSet<GemDependency> dependencies = new LinkedHashSet<GemDependency>();
        for (GemDependency gemRequirement : gemsToInstall) {
            if (gemRequirement.isFromPath()) continue;
            if (ContainerUtil.exists(gemsToSkip, gemRequirement::isSatisfied)) continue;
            dependencies.add(gemRequirement);
        }
        if (dependencies.isEmpty()) {
            return;
        }
        Project project = RModuleUtil.getInstance().getProject(module);
        Map<GemDependency, String> errorHolder = processOptions.getErrorHolder();
        boolean showErrors = processOptions.shouldShowErrors();
        final Runnable installRunnable = () -> {
            if (dependencies.isEmpty()) {
                GemInstallUtil.showErrors(showErrors, project, errorHolder);
                return;
            }
            GemInstallUtil.installGemsImpl(module, sdk, dependencies, commandOptions, errorHolder, processOptions.shouldPerformAsynchronousGemsSync());
            GemInstallUtil.showErrors(showErrors, project, errorHolder);
            Runnable callback = processOptions.getCallback();
            if (callback != null) {
                ApplicationManager.getApplication().invokeLater(callback);
            }
        };
        String title = RBundle.message((String)"gems.gem.installing");
        Object task = processOptions.isBackgroundable() ? new Task.Backgroundable(project, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                installRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/GemInstallUtil$1", "run"));
            }
        } : new Task.Modal(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                installRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/GemInstallUtil$2", "run"));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProgressManager.getInstance().executeProcessUnderProgress(installRunnable, (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private static void showErrors(boolean showErrors, Project project, Map<GemDependency, String> errorHolder) {
        if (showErrors) {
            ApplicationManager.getApplication().invokeLater(() -> GemUiUtil.showInstallErrors(project, errorHolder));
        }
    }

    public static List<GemDependency> findBundledGemsToInstall(@NlsContexts.DialogMessage String message, Pattern ... patterns) throws ExecutionException {
        String gemsPath = RubyUtil.getScriptFullPath("rb/gems");
        if (gemsPath == null) {
            LOG.warn("No gems path found at rb/gems");
            throw new ExecutionException(RBundle.message((String)"gems.gem.installing.failed.with.reason", (Object[])new Object[]{message}));
        }
        File gemsDir = new File(gemsPath);
        List paths = ContainerUtil.map((Object[])patterns, (Function)((NullableFunction)pattern -> GemInstallUtil.findBundledDebugGem(gemsDir, pattern)));
        ArrayList<GemDependency> result = new ArrayList<GemDependency>();
        for (String path : paths) {
            if (path == null) {
                LOG.warn("Failed to install gems by " + String.valueOf(List.of(patterns)));
                throw new ExecutionException(RBundle.message((String)"gems.gem.installing.failed.with.reason", (Object[])new Object[]{message}));
            }
            result.add(GemDependency.any(path));
        }
        return result;
    }

    @Nullable
    public static String findBundledDebugGem(File gemsDir, Pattern pattern) {
        File[] files = gemsDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            Matcher m = pattern.matcher(file.getName());
            if (!m.matches()) continue;
            return file.getPath();
        }
        return null;
    }

    private static void installGemsImpl(@Nullable Module module, @NotNull Sdk sdk, @NotNull Collection<GemDependency> gemsToInstall, @NotNull GemInstallCommandOptions options, @NotNull Map<GemDependency, String> errorHolder, boolean asynchronousGemsSync) {
        if (sdk == null) {
            GemInstallUtil.$$$reportNull$$$0(4);
        }
        if (gemsToInstall == null) {
            GemInstallUtil.$$$reportNull$$$0(5);
        }
        if (options == null) {
            GemInstallUtil.$$$reportNull$$$0(6);
        }
        if (errorHolder == null) {
            GemInstallUtil.$$$reportNull$$$0(7);
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        boolean cancelled = false;
        LOG.debug("We need to install: ", new Object[]{gemsToInstall, " to the ", sdk});
        for (GemDependency dep : gemsToInstall) {
            LOG.debug("Installing: ", new Object[]{dep});
            if (cancelled) {
                LOG.debug("Cancelled");
                errorHolder.put(dep, "Cancelled");
                continue;
            }
            GemInfo gem = RubyGemSearchUtil.findGem(module, sdk, dep);
            if (gem == null) {
                Pair<Boolean, String> pair = GemRunner.install(module, sdk, dep, options);
                if (!((Boolean)pair.first).booleanValue()) {
                    LOG.warn("Error installing gem: " + dep.getDescription() + "; " + (String)pair.second);
                    errorHolder.put(dep, (String)pair.second);
                    cancelled = "Cancelled".equals(pair.second);
                } else {
                    LOG.info("Installed gem: " + dep.getDescription());
                }
            } else {
                LOG.debug("Gem already found: ", new Object[]{gem});
            }
            cancelled |= progressIndicator.isCanceled();
        }
        RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, asynchronousGemsSync);
        boolean async = asynchronousGemsSync && !ApplicationManager.getApplication().isUnitTestMode();
        RubySdkGemLibraryManager.getInstance().refreshRoots(sdk, async);
        RubySdkGemLibraryManager.getInstance().refresh(async);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsToInstall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandOptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHolder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemInstallUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installGemsInBackground";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "installGemsImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

