/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class GemDependency
implements Comparable<GemDependency> {
    private static final String MAX_VERSION = Integer.valueOf(Integer.MAX_VALUE).toString();
    public static final Pair<Bound, String> BOUND_ANY = Pair.create((Object)((Object)Bound.GREATER_OR_EQUAL), (Object)"0");
    public static final String VERSION_PATTERN = "([0-9]+(\\.[0-9A-z]+)*)";
    @NonNls
    private static final Pattern FULL = Pattern.compile("^\\s*([^0-9\\s]*)\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
    @NonNls
    private static final Pattern EQUAL_SHORT = Pattern.compile("^\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
    @NonNls
    private static final Pattern SHORT = Pattern.compile("^\\s*([^0-9\\s]*)\\s*$");
    private static final List<String> JRUBY_PLATFORMS = Arrays.asList("jruby", "java");
    private static final List<String> RUBY_PLATFORMS = Collections.singletonList("ruby");
    private static final List<String> WINDOWS_PLATFORMS = Arrays.asList("mswin", "mingw");
    private final String myName;
    private final List<Pair<Bound, String>> myBounds;
    private final String myUrl;
    @Nullable
    private final String myLib;
    private final boolean myIsGit;
    private final boolean myFromPath;
    private final String @Nullable [] myPlatforms;
    @Nullable
    private final List<String> myGroups;
    private final boolean myDoRequire;
    private final String myRef;

    @NotNull
    public String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append(this.getName());
        if (!this.isAny()) {
            description.append(" (");
            if (!this.isExact()) {
                for (Pair<Bound, String> bound : this.myBounds) {
                    if (bound != this.myBounds.get(0)) {
                        description.append(", ");
                    }
                    description.append(((Bound)((Object)bound.first)).getOperator()).append(" ").append((String)bound.second);
                }
            } else {
                description.append((String)this.getBounds().get((int)0).second);
            }
            description.append(")");
        }
        String string = description.toString();
        if (string == null) {
            GemDependency.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isExact() {
        return this.myBounds.size() == 1 && this.myBounds.get((int)0).first == Bound.EQUAL;
    }

    @Override
    public int compareTo(@NotNull GemDependency other) {
        if (other == null) {
            GemDependency.$$$reportNull$$$0(1);
        }
        return this.getVersionString().compareTo(other.getVersionString());
    }

    public GemDependency(@NotNull String name, @Unmodifiable @NotNull List<Pair<Bound, String>> bounds, @Nullable String url, @Nullable String lib, boolean git, String ref, boolean doRequire, boolean fromPath, String @Nullable [] platforms, @Nullable List<String> groups) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(2);
        }
        if (bounds == null) {
            GemDependency.$$$reportNull$$$0(3);
        }
        this.myName = name;
        if (bounds.size() > 1) {
            bounds = ContainerUtil.sorted(bounds, Pair.comparingBySecond().thenComparing(Pair.comparingByFirst()));
        }
        this.myBounds = Collections.unmodifiableList(bounds);
        this.myUrl = url;
        this.myLib = lib;
        this.myIsGit = git;
        this.myRef = ref;
        this.myDoRequire = doRequire;
        this.myFromPath = fromPath;
        this.myPlatforms = platforms;
        this.myGroups = groups;
    }

    @NotNull
    public static GemDependency exact(@NotNull GemInfo gem) {
        if (gem == null) {
            GemDependency.$$$reportNull$$$0(4);
        }
        return GemDependency.any(gem.getName(), gem.isRemote() ? gem.getUrl() : null, null, gem.isGit(), gem.getRef(), true, false, null, (Pair<Bound, String>)Pair.create((Object)((Object)Bound.EQUAL), (Object)gem.getVersion()), null);
    }

    public static GemDependency any(@NonNls @NotNull String name) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(5);
        }
        return GemDependency.any(name, null, null, false, null, true, false, null, null);
    }

    @NotNull
    public static List<GemDependency> anyAsList(@NotNull String gemName) {
        if (gemName == null) {
            GemDependency.$$$reportNull$$$0(6);
        }
        List<GemDependency> list = Collections.singletonList(GemDependency.any(gemName));
        if (list == null) {
            GemDependency.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static GemDependency any(@NonNls @NotNull String name, @NotNull Pair<Bound, String> bound) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(8);
        }
        if (bound == null) {
            GemDependency.$$$reportNull$$$0(9);
        }
        return GemDependency.any(name, null, null, false, null, true, false, null, bound, null);
    }

    public static GemDependency any(@NonNls @NotNull String name, String @Nullable [] platforms) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(10);
        }
        return GemDependency.any(name, null, null, false, null, true, false, platforms, null);
    }

    public static GemDependency any(@NonNls @NotNull String name, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, String @Nullable [] platforms, @Nullable List<String> groups) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(11);
        }
        return GemDependency.any(name, url, lib, isGit, ref, doRequire, fromPath, platforms, BOUND_ANY, groups);
    }

    @NotNull
    private static GemDependency any(@NonNls @NotNull String name, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, String @Nullable [] platforms, @NotNull Pair<Bound, String> bound, @Nullable List<String> groups) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(12);
        }
        if (bound == null) {
            GemDependency.$$$reportNull$$$0(13);
        }
        return new GemDependency(name, Collections.singletonList(bound), url, lib, isGit, ref, doRequire, fromPath, platforms, groups);
    }

    public boolean isAny() {
        return this.myBounds.isEmpty() || this.myBounds.size() == 1 && GemDependency.isAny(this.myBounds.get(0));
    }

    private static boolean isAny(Pair<Bound, String> dep) {
        return dep.first == Bound.GREATER_OR_EQUAL && "0".equals(dep.second);
    }

    public static GemDependency equal(@NotNull String name, @Nullable String version) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(14);
        }
        Pair bound = Pair.create((Object)((Object)Bound.EQUAL), (Object)(version == null ? "0" : version));
        return GemDependency.any(name, null, null, false, null, true, false, null, (Pair<Bound, String>)bound, null);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, String ... deps) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(15);
        }
        if (deps == null) {
            GemDependency.$$$reportNull$$$0(16);
        }
        return GemDependency.create(name, deps, null, null, false, null, true, false, null, null);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, @Nullable List<String> groups, String ... deps) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(17);
        }
        if (deps == null) {
            GemDependency.$$$reportNull$$$0(18);
        }
        return GemDependency.create(name, deps, null, null, false, null, true, false, null, groups);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, String @NotNull [] deps, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, String @Nullable [] platforms, @Nullable List<String> groups) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(19);
        }
        if (deps == null) {
            GemDependency.$$$reportNull$$$0(20);
        }
        ArrayList<Pair<Bound, String>> depList = new ArrayList<Pair<Bound, String>>();
        for (String dep : deps) {
            Bound bound;
            String op;
            Matcher matcher = FULL.matcher(dep);
            if (matcher.matches()) {
                op = matcher.group(1);
                bound = Bound.getBound(op);
                String version = matcher.group(2);
                if (bound != null) {
                    depList.add((Pair<Bound, String>)Pair.create((Object)((Object)bound), (Object)version));
                }
            }
            if ((matcher = EQUAL_SHORT.matcher(dep)).matches()) {
                Bound bound2 = Bound.EQUAL;
                String version = matcher.group(1);
                depList.add((Pair<Bound, String>)Pair.create((Object)((Object)bound2), (Object)version));
            }
            if (!(matcher = SHORT.matcher(dep)).matches() || (bound = Bound.getBound(op = matcher.group(1))) == null) continue;
            depList.add((Pair<Bound, String>)Pair.create((Object)((Object)bound), (Object)"0"));
        }
        return GemDependency.create(name, depList.size() == deps.length ? depList : null, url, lib, isGit, ref, doRequire, fromPath, platforms, groups);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, @Nullable List<Pair<Bound, String>> bounds, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, String @Nullable [] platforms, @Nullable List<String> groups) {
        if (name == null) {
            GemDependency.$$$reportNull$$$0(21);
        }
        return bounds != null ? new GemDependency(name, bounds, url, lib, isGit, ref, doRequire, fromPath, platforms, groups) : null;
    }

    public boolean isRawGem() {
        return this.myName.endsWith(".gem");
    }

    public String getName() {
        return this.myName;
    }

    public String getCanonicalName() {
        return this.isRawGem() ? PathUtilRt.getFileName((String)this.myName) : this.myName;
    }

    public String getRawGemDir() {
        return this.isRawGem() ? PathUtilRt.getParentPath((String)this.myName) : null;
    }

    public List<Pair<Bound, String>> getBounds() {
        return this.myBounds;
    }

    public String getVersionString() {
        StringBuilder versionString = new StringBuilder();
        for (Pair<Bound, String> bound : this.myBounds) {
            if (!versionString.isEmpty()) {
                versionString.append(", ");
            }
            versionString.append(((Bound)((Object)bound.first)).getOperator()).append(" ").append((String)bound.second);
        }
        return versionString.toString();
    }

    public String @Nullable [] getPlatforms() {
        return this.myPlatforms;
    }

    @Nullable
    public List<String> getGroups() {
        return this.myGroups;
    }

    public String getRef() {
        return this.myRef;
    }

    public boolean isSatisfied(GemInfo gem) {
        if (!Comparing.strEqual((String)this.myName, (String)gem.getName())) {
            return false;
        }
        if (this.myIsGit && this.myRef != null) {
            return gem.isLocalGitRepo() || this.myRef.equals(gem.getRef());
        }
        if (!this.myIsGit && gem.isGit()) {
            return false;
        }
        if (this.myFromPath && this.myUrl != null) {
            return SystemInfo.isMac || SystemInfo.isWindows ? StringUtil.startsWithIgnoreCase((String)gem.getUrl(), (String)this.myUrl) : StringUtil.startsWith((CharSequence)gem.getUrl(), (CharSequence)this.myUrl);
        }
        boolean isFrozen = gem instanceof FrozenGemInfo;
        if (!this.myFromPath && gem.isFromPath() && !isFrozen) {
            return false;
        }
        return !this.isVersionUnsatisfied(gem.getVersion());
    }

    private boolean isVersionUnsatisfied(String version) {
        for (Pair<Bound, String> bound : this.myBounds) {
            if (GemDependency.compareVersions(version, (String)bound.second, (Bound)((Object)bound.first))) continue;
            return true;
        }
        return false;
    }

    public boolean isGit() {
        return this.myIsGit;
    }

    public boolean isFromPath() {
        return this.myFromPath;
    }

    public boolean doRequire() {
        return this.myDoRequire;
    }

    public String getUrl() {
        return this.myUrl;
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Module module) {
        return module != null && this.isLocalProjectDependency(module.getProject());
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile gemRootDirectory = this.getGemRootDirectory();
            return gemRootDirectory != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(gemRootDirectory);
        });
    }

    @Nullable
    public VirtualFile getGemRootDirectory() {
        String url = this.getUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    public String getLibScript() {
        return this.myLib;
    }

    public static boolean compareVersions(String versionToCheck, String version, Bound bound) {
        return switch (bound.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) == 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) > 0) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                String bumpedVersion = GemDependency.bump(version);
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0 && VersionComparatorUtil.compare((String)versionToCheck, (String)bumpedVersion) < 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) < 0) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (VersionComparatorUtil.compare((String)versionToCheck, (String)version) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> VersionComparatorUtil.compare((String)versionToCheck, (String)version) != 0;
        };
    }

    @ApiStatus.Internal
    public static String bump(String version) {
        int i;
        String[] numbers = version.split("\\.");
        StringBuilder builder2 = new StringBuilder();
        for (i = numbers.length - 1; i >= 0 && GemDependency.isAlpha(numbers[i]); --i) {
        }
        String numberToBump = i > 1 ? numbers[i - 1] : numbers[0];
        String bumpNumber = GemDependency.succ(numberToBump);
        for (int j = 0; j < i - 1; ++j) {
            builder2.append(numbers[j]).append(".");
        }
        builder2.append(bumpNumber).append(".snap");
        return builder2.toString();
    }

    @ApiStatus.Internal
    public static String succ(String number) {
        StringBuilder bumper = new StringBuilder(number.length());
        int carry = 1;
        int c = 49;
        for (int i = number.length() - 1; i >= 0; --i) {
            c = number.charAt(i);
            if (Character.isLetter(c)) {
                carry = (c += carry - 97) / 26;
                c = c % 26 + 97;
            } else if (Character.isDigit(c)) {
                carry = (c += carry - 48) / 10;
                c = c % 10 + 48;
            }
            bumper.append((char)c);
        }
        if (carry != 0) {
            bumper.append((char)(Character.isLetter(c) ? 97 : carry + 48));
        }
        return bumper.reverse().toString();
    }

    private static boolean isAlpha(String number) {
        for (int i = 0; i < number.length(); ++i) {
            if (!Character.isLetter(number.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GemDependency that = (GemDependency)o;
        if (this.myDoRequire != that.myDoRequire) {
            return false;
        }
        if (this.myFromPath != that.myFromPath) {
            return false;
        }
        if (this.myIsGit != that.myIsGit) {
            return false;
        }
        if (this.myBounds != null ? !this.myBounds.equals(that.myBounds) : that.myBounds != null) {
            return false;
        }
        if (this.myLib != null ? !this.myLib.equals(that.myLib) : that.myLib != null) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (this.myRef != null ? !this.myRef.equals(that.myRef) : that.myRef != null) {
            return false;
        }
        return !(this.myUrl != null ? !this.myUrl.equals(that.myUrl) : that.myUrl != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myBounds != null ? this.myBounds.hashCode() : 0);
        result = 31 * result + (this.myUrl != null ? this.myUrl.hashCode() : 0);
        result = 31 * result + (this.myLib != null ? this.myLib.hashCode() : 0);
        result = 31 * result + (this.myIsGit ? 1 : 0);
        result = 31 * result + (this.myFromPath ? 1 : 0);
        result = 31 * result + (this.myDoRequire ? 1 : 0);
        result = 31 * result + (this.myRef != null ? this.myRef.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GemDependency{myName='" + this.myName + "', myBounds=" + String.valueOf(this.myBounds) + ", myUrl='" + this.myUrl + "', myLib='" + this.myLib + "', myIsGit=" + this.myIsGit + ", myFromPath=" + this.myFromPath + ", myPlatforms=" + (this.myPlatforms == null ? "null" : Arrays.asList(this.myPlatforms).toString()) + ", myDoRequire=" + this.myDoRequire + ", myRef='" + this.myRef + "', myGroups=" + (this.myGroups == null ? "null" : String.join((CharSequence)", ", this.myGroups)) + "}";
    }

    public boolean canBeSatisfied() {
        return this.canBeSatisfied(Interval.UNIVERSUM, 0);
    }

    private boolean canBeSatisfied(Interval interval, int start) {
        for (int i = start; i < this.myBounds.size(); ++i) {
            Pair<Bound, String> dependency = this.myBounds.get(i);
            Interval[] intervals = GemDependency.createIntervals(dependency);
            if (intervals.length != 1) {
                return this.canBeSatisfied(interval.intersect(intervals[0]), i + 1) || this.canBeSatisfied(interval.intersect(intervals[1]), i + 1);
            }
            interval = interval.intersect(intervals[0]);
        }
        return !interval.isEmpty();
    }

    public boolean canEat(@NotNull GemDependency dependency) {
        if (dependency == null) {
            GemDependency.$$$reportNull$$$0(22);
        }
        if (!this.getName().equals(dependency.getName())) {
            return false;
        }
        if (dependency.isAny()) {
            return true;
        }
        if (this.isAny()) {
            return false;
        }
        if (this.getBounds().size() > 1 || dependency.getBounds().size() > 1) {
            return false;
        }
        Pair<Bound, String> my = this.getBounds().get(0);
        Pair<Bound, String> other = dependency.getBounds().get(0);
        Interval[] myIntervals = GemDependency.createIntervals(my);
        Interval[] otherIntervals = GemDependency.createIntervals(other);
        if (myIntervals.length != 1 || otherIntervals.length != 1) {
            return false;
        }
        return myIntervals[0].isContained(otherIntervals[0]);
    }

    public int size() {
        return this.myBounds.size();
    }

    public boolean isSupportedBySdk(@Nullable Sdk sdk) {
        if (this.myPlatforms != null && this.myPlatforms.length > 0) {
            if (sdk == null || Arrays.asList(this.myPlatforms).containsAll(Arrays.asList("java", "ruby"))) {
                return false;
            }
            for (String argument : this.myPlatforms) {
                boolean rubyVersionmatches;
                String[] platformAndRubyVersion = argument.split("_(?=\\d+)");
                String platform = StringUtil.notNullize((String)platformAndRubyVersion[0]);
                LanguageLevel languageLevel = platformAndRubyVersion.length > 1 ? LanguageLevel.fromString((String)("ruby" + platformAndRubyVersion[1])) : null;
                boolean platformMatches = JRubySdkUtil.isJRubySDK(sdk) && JRUBY_PLATFORMS.contains(platform) || RubySdkUtil.isRubySDK(sdk) && RUBY_PLATFORMS.contains(platform) || RubySdkSystemAccessor.notNullFrom(sdk).isWindows() && WINDOWS_PLATFORMS.contains(platform);
                boolean bl = rubyVersionmatches = languageLevel == null || RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk) == languageLevel;
                if (!platformMatches || !rubyVersionmatches) continue;
                return true;
            }
            return false;
        }
        return !this.myName.endsWith("19") || RubySdkUtil.isRuby19(sdk);
    }

    private static Interval[] createIntervals(Pair<Bound, String> dependency) {
        Interval[] intervalArray;
        String version = (String)dependency.second;
        Bound bound = (Bound)((Object)dependency.first);
        switch (bound.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Interval[] intervalArray2 = new Interval[1];
                intervalArray = intervalArray2;
                intervalArray2[0] = new Interval(version, true, version, true);
                break;
            }
            case 3: {
                Interval[] intervalArray3 = new Interval[1];
                intervalArray = intervalArray3;
                intervalArray3[0] = new Interval(version, false, MAX_VERSION, false);
                break;
            }
            case 5: {
                Interval[] intervalArray4 = new Interval[1];
                intervalArray = intervalArray4;
                intervalArray4[0] = new Interval(version, true, MAX_VERSION, false);
                break;
            }
            case 6: {
                Interval[] intervalArray5 = new Interval[1];
                intervalArray = intervalArray5;
                intervalArray5[0] = new Interval(version, true, GemDependency.bump(version), false);
                break;
            }
            case 2: {
                Interval[] intervalArray6 = new Interval[1];
                intervalArray = intervalArray6;
                intervalArray6[0] = new Interval("0", true, version, false);
                break;
            }
            case 4: {
                Interval[] intervalArray7 = new Interval[1];
                intervalArray = intervalArray7;
                intervalArray7[0] = new Interval("0", true, version, true);
                break;
            }
            case 1: {
                Interval[] intervalArray8 = new Interval[2];
                intervalArray8[0] = new Interval("0", true, version, false);
                intervalArray = intervalArray8;
                intervalArray8[1] = new Interval(version, false, MAX_VERSION, false);
            }
        }
        return intervalArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "anyAsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exact";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "any";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "anyAsList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canEat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }

    public static enum Bound {
        EQUAL("="),
        NOT_EQUAL("!="),
        LESS("<"),
        GREATER(">"),
        LESS_OR_EQUAL("<="),
        GREATER_OR_EQUAL(">="),
        LATEST_IN_BRANCH("~>");

        private final String myOperator;

        private Bound(String op) {
            this.myOperator = op;
        }

        @Nullable
        public static Bound getBound(String op) {
            for (Bound bound : Bound.values()) {
                if (!bound.myOperator.equals(op)) continue;
                return bound;
            }
            return null;
        }

        public String getOperator() {
            return this.myOperator;
        }
    }

    private static class Interval {
        public static final Interval UNIVERSUM = new Interval("0", true, MAX_VERSION, false);
        private final String myLow;
        private final boolean myLowIncluded;
        private final String myHigh;
        private final boolean myHighIncluded;

        Interval(String low, boolean lowIncluded, String high, boolean highIncluded) {
            this.myLow = low;
            this.myLowIncluded = lowIncluded;
            this.myHigh = high;
            this.myHighIncluded = highIncluded;
        }

        boolean isEmpty() {
            int i = VersionComparatorUtil.compare((String)this.myLow, (String)this.myHigh);
            return i > 0 || i == 0 && (!this.myLowIncluded || !this.myHighIncluded);
        }

        Interval intersect(Interval other) {
            String lowMax = VersionComparatorUtil.max((String)this.myLow, (String)other.myLow);
            String highMin = VersionComparatorUtil.min((String)this.myHigh, (String)other.myHigh);
            return new Interval(lowMax, this.shouldLowBeIncluded(other, lowMax), highMin, this.shouldHighBeIncluded(other, highMin));
        }

        private boolean shouldHighBeIncluded(Interval other, String newHigh) {
            if (!this.myHigh.equals(other.myHigh)) {
                return this.myHigh.equals(newHigh) ? this.myHighIncluded : other.myHighIncluded;
            }
            return this.myHighIncluded && other.myHighIncluded;
        }

        private boolean shouldLowBeIncluded(Interval other, String newLow) {
            if (!this.myLow.equals(other.myLow)) {
                return this.myLow.equals(newLow) ? this.myLowIncluded : other.myLowIncluded;
            }
            return this.myLowIncluded && other.myLowIncluded;
        }

        private boolean isContained(Interval other) {
            return (other.myLowIncluded || !this.myLowIncluded ? VersionComparatorUtil.compare((String)this.myLow, (String)other.myLow) >= 0 : VersionComparatorUtil.compare((String)this.myLow, (String)other.myLow) > 0) && (other.myHighIncluded || !this.myHighIncluded ? VersionComparatorUtil.compare((String)this.myHigh, (String)other.myHigh) <= 0 : VersionComparatorUtil.compare((String)this.myHigh, (String)other.myHigh) < 0);
        }
    }
}

