/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemSpecContext;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;

public final class GemBox {
    static final String DEFAULT_GEM_SUMMARY_SUFFIX = " is bundled with Ruby";
    private static final Logger LOG = Logger.getInstance(GemBox.class);
    private static boolean ourForceRefreshInTests = false;
    @NotNull
    private final Sdk mySdk;
    @NotNull
    private final String myGemUrl;

    public GemBox(@NotNull Sdk sdk, @NotNull String gemUrl) {
        if (sdk == null) {
            GemBox.$$$reportNull$$$0(0);
        }
        if (gemUrl == null) {
            GemBox.$$$reportNull$$$0(1);
        }
        this.mySdk = sdk;
        this.myGemUrl = gemUrl;
    }

    @NotNull
    public static String getDefaultGemName(@NotNull VirtualFile gemFile) {
        String name;
        int index;
        if (gemFile == null) {
            GemBox.$$$reportNull$$$0(2);
        }
        String string = GemBox.hasVersion(index = (name = gemFile.getNameWithoutExtension()).lastIndexOf("-"), name) ? name.substring(0, index) : name;
        if (string == null) {
            GemBox.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getDefaultGemVersion(@NotNull VirtualFile gemFile) {
        String name;
        int index;
        if (gemFile == null) {
            GemBox.$$$reportNull$$$0(4);
        }
        return GemBox.hasVersion(index = (name = gemFile.getNameWithoutExtension()).lastIndexOf("-"), name) ? name.substring(index + 1) : null;
    }

    private static boolean hasVersion(int index, String name) {
        return index >= 0 && StringUtil.containsAnyChar((String)name.substring(index + 1), (String)"0123456789");
    }

    public String getUrl() {
        return this.myGemUrl;
    }

    @NotNull
    public List<GemInfo> getDefaultGems() {
        VirtualFile root = this.getRoot();
        if (root == null) {
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemBox.$$$reportNull$$$0(5);
            }
            return list;
        }
        HashMap<String, GemInfo> map = new HashMap<String, GemInfo>();
        this.addDefaultGems(root, map);
        List<GemInfo> list = List.copyOf(map.values());
        if (list == null) {
            GemBox.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void addDefaultGems(@NotNull VirtualFile gemBoxRoot, @NotNull Map<String, GemInfo> gemsMap) {
        if (gemBoxRoot == null) {
            GemBox.$$$reportNull$$$0(7);
        }
        if (gemsMap == null) {
            GemBox.$$$reportNull$$$0(8);
        }
        GemBox.debug("Looking for default gems in ", this.myGemUrl, " for ", this.mySdk);
        LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)this.mySdk);
        if (languageLevel.isLessThan(LanguageLevel.RUBY20)) {
            GemBox.debug("Too low language level: ", languageLevel);
            return;
        }
        VirtualFile specFolder = GemUtil.getSpecFolder(gemBoxRoot);
        if (specFolder == null) {
            GemBox.debug("No spec folder for ", gemBoxRoot);
            return;
        }
        VirtualFile defaultSpecsFolder = specFolder.findChild("default");
        if (defaultSpecsFolder == null || !defaultSpecsFolder.isDirectory()) {
            GemBox.debug("No default subfolder in specs root: ", specFolder);
            return;
        }
        RbConfig rbConfig = RbConfig.from(this.mySdk);
        if (rbConfig == null) {
            LOG.warn("Sdk without RbConfig " + String.valueOf(this.mySdk));
            return;
        }
        PathMappingSettings mappings = RubyRunner.notNullFrom(this.mySdk).addDefaultMappings(null);
        List<VirtualFile> loadPaths = RubyImplementationHandler.notNullFrom(this.mySdk).getLoadPath().stream().map(it -> VfsUtil.findFileByIoFile((File)new File(mappings.convertToLocal(it)), (boolean)false)).filter(Objects::nonNull).toList();
        if (loadPaths.isEmpty()) {
            LOG.warn("Empty loadpath in " + String.valueOf(this.mySdk));
            return;
        }
        GemBox.debug("Processing default specs folder: ", defaultSpecsFolder);
        GemBox.debug("Loadpaths for: ", this.mySdk, "; ", loadPaths);
        for (VirtualFile specFile : defaultSpecsFolder.getChildren()) {
            VirtualFile loadPath;
            String version;
            String name = GemBox.getDefaultGemName(specFile);
            if ("test-unit".equals(name) || (version = GemBox.getDefaultGemVersion(specFile)) == null) continue;
            GemSpecContext spec = new GemSpecContext();
            spec.putData(GemsSpecKeys.NAME, name);
            spec.putData(GemsSpecKeys.VERSION, version);
            spec.putData(GemsSpecKeys.SUMMARY, "This " + name + DEFAULT_GEM_SUMMARY_SUFFIX);
            spec.putData(GemsSpecKeys.SDK, this.mySdk);
            spec.putData(GemsSpecKeys.FROM_PATH, false);
            VirtualFile libFile = null;
            String libRelativePath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])name.split("-")));
            Iterator<VirtualFile> iterator = loadPaths.iterator();
            while (iterator.hasNext() && (libFile = (loadPath = iterator.next()).findFileByRelativePath(libRelativePath)) == null) {
            }
            if (libFile != null) {
                GemInfo gemInfo = GemInfo.create(spec, libFile.getUrl(), null);
                if (gemInfo != null) {
                    gemsMap.put(gemInfo.getUrl(), gemInfo);
                    GemBox.debug("Found gem ", gemInfo, " in ", libFile);
                    continue;
                }
                GemBox.debug("Could not create a geminfo for ", spec, " and ", libFile);
                continue;
            }
            GemBox.debug("Unable to find a library file for gem ", name, " relative path ", libRelativePath);
        }
    }

    @Nullable
    public VirtualFile getRoot() {
        boolean forceRefresh = ourForceRefreshInTests || !ApplicationManager.getApplication().isUnitTestMode();
        VirtualFile file = forceRefresh ? VirtualFileManager.getInstance().refreshAndFindFileByUrl(this.myGemUrl) : VirtualFileManager.getInstance().findFileByUrl(this.myGemUrl);
        return file != null && file.isValid() ? file : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GemBox box = (GemBox)o;
        if (!this.mySdk.equals((Object)box.mySdk)) {
            return false;
        }
        return this.myGemUrl.equals(box.myGemUrl);
    }

    public int hashCode() {
        int result = this.mySdk.hashCode();
        result = 31 * result + this.myGemUrl.hashCode();
        return result;
    }

    @TestOnly
    public static void enforceRefreshInTests(boolean value) {
        ourForceRefreshInTests = value;
    }

    @NotNull
    public String toString() {
        String string = "GemBox{mySdk=%s, myGemUrl='%s'}".formatted(this.mySdk, this.myGemUrl);
        if (string == null) {
            GemBox.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void debug(@NotNull String message, Object ... objects) {
        if (message == null) {
            GemBox.$$$reportNull$$$0(10);
        }
        if (objects == null) {
            GemBox.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message.formatted(objects));
            }
        } else {
            LOG.debug(message, objects);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemUrl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemBoxRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGemName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultGems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

