/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.lang.refactoring.safeDelete;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotFactoryCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotTraitCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.RubyFactoryBotModelFakePsiElement;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.methodCall.RubyFactoryBotCallNavigator;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.search.RubySymbolReferenceSearch;

public final class RubyFactoryBotSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @NotNull
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> usages) {
        if (element == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        if (allElementsToDelete == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).forEach(reference -> {
            PsiElement refElement = reference.getElement();
            if (!ContainerUtil.or((Object[])allElementsToDelete, ancestor -> SafeDeleteProcessor.isInside((PsiElement)refElement, (PsiElement)ancestor))) {
                boolean isNonCodeUsage = reference instanceof RubySymbolReferenceSearch.Reference;
                usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo(refElement, element, -1, -1, isNonCodeUsage, false));
            }
            return true;
        });
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @NotNull
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (allElementsToDelete == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (element instanceof RubyFactoryBotModelFakePsiElement && !((RubyFactoryBotModelFakePsiElement)element).isAlias()) {
            return RubyFactoryBotSafeDeleteProcessor.getNestedModels((RubyFactoryBotModelFakePsiElement)element);
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (allElementsToDelete == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        RCall call = RubyFactoryBotCallNavigator.getModelCallByNameOrAliasArgument(element);
        String name = RubyInterpretUtil.evaluateStringOrSymbolElement(element);
        if (call == null || name == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<RubyFactoryBotModelFakePsiElement> set = Collections.singleton(new RubyFactoryBotModelFakePsiElement(call, name));
        if (set == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
        return set;
    }

    public boolean handlesElement(PsiElement element) {
        return element instanceof RubyFactoryBotModelFakePsiElement || RubyFactoryBotCallNavigator.getModelCallByNameOrAliasArgument(element) != null;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public void prepareForDeletion(@NotNull PsiElement element) {
        if (element == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(13);
        }
    }

    public UsageInfo @NotNull [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(14);
        }
        if (usages == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(15);
        }
        if (usages == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(16);
        }
        return usages;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    @NotNull
    private static List<PsiElement> getNestedModels(final @NotNull RubyFactoryBotModelFakePsiElement model) {
        RBlockCall blockCall;
        if (model == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(17);
        }
        if ((blockCall = RBlockCallNavigator.getByCall((RPsiElement)model.getCall())) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(18);
            }
            return list;
        }
        final ArrayList<PsiElement> additionalElements = new ArrayList<PsiElement>();
        blockCall.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRCall(@NotNull RCall call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (call.equals((Object)model.getCall())) {
                    return;
                }
                RubyCallType callType = call.getCallType();
                if (!(callType instanceof RubyFactoryBotFactoryCallType) && !(callType instanceof RubyFactoryBotTraitCallType)) {
                    return;
                }
                String name = RubyFactoryBotModelCallType.getName((RPossibleCall)call);
                if (StringUtil.isEmpty((String)name)) {
                    return;
                }
                additionalElements.add(new RubyFactoryBotModelFakePsiElement(call, name));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/safeDelete/RubyFactoryBotSafeDeleteProcessor$1", "visitRCall"));
            }
        });
        ArrayList<PsiElement> arrayList = additionalElements;
        if (arrayList == null) {
            RubyFactoryBotSafeDeleteProcessor.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 11, 12, 16, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/safeDelete/RubyFactoryBotSafeDeleteProcessor";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/safeDelete/RubyFactoryBotSafeDeleteProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findConflicts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalElementsToDelete";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSearch";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessUsages";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareForDeletion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNestedModels";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 11, 12, 16, 18, 19 -> new IllegalStateException(string);
        };
    }
}

