/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.factoryBot.lang.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotFactoryCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotModelCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotSequenceCallType;
import org.jetbrains.plugins.ruby.factoryBot.codeInsight.callTypes.RubyFactoryBotTraitCallType;
import org.jetbrains.plugins.ruby.factoryBot.lang.psi.impl.methodCall.RubyFactoryBotCallNavigator;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotFactory;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotSequence;
import org.jetbrains.plugins.ruby.factoryBot.model.RubyFactoryBotTrait;
import org.jetbrains.plugins.ruby.factoryBot.psi.RubyFactoryBotImplicitSequenceReference;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RubyRenameProcessor;

public final class RubyFactoryBotRenameProcessor
extends RubyRenameProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(0);
        }
        return RubyFactoryBotCallNavigator.getModelCallByNameOrAliasArgument(element) != null;
    }

    @Override
    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(1);
        }
        if (ref == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(2);
        }
        if (referenceElement == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(3);
        }
        if (ref instanceof RubyFactoryBotImplicitSequenceReference) {
            return new MySequenceImplicitReferenceCollision(referenceElement, element);
        }
        UsageInfo usageInfo = super.createUsageInfo(element, ref, referenceElement);
        if (usageInfo == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(4);
        }
        return usageInfo;
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(6);
        }
        if (allRenames == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            RubyFactoryBotRenameProcessor.$$$reportNull$$$0(8);
        }
        super.prepareRenaming(element, newName, allRenames, scope);
        if (RubyFactoryBotCallNavigator.getModelCallByNameArgument(element) == null) {
            return;
        }
        String oldName = RubyInterpretUtil.evaluateStringOrSymbolElement(element);
        if (oldName == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return;
        }
        if (oldName.equals(FileUtilRt.getNameWithoutExtension((String)file.getName()))) {
            String extension = FileUtilRt.getExtension((CharSequence)file.getName(), (String)"rb").toString();
            allRenames.put((PsiElement)file, String.format("%s.%s", newName, extension));
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        block10: {
            RubyCallType callType;
            Project project;
            block11: {
                block9: {
                    RCall call;
                    if (element == null) {
                        RubyFactoryBotRenameProcessor.$$$reportNull$$$0(9);
                    }
                    if (newName == null) {
                        RubyFactoryBotRenameProcessor.$$$reportNull$$$0(10);
                    }
                    if (conflicts == null) {
                        RubyFactoryBotRenameProcessor.$$$reportNull$$$0(11);
                    }
                    if ((call = RubyFactoryBotCallNavigator.getModelCallByNameOrAliasArgument(element)) == null) {
                        return;
                    }
                    project = element.getProject();
                    callType = call.getCallType();
                    if (!(callType instanceof RubyFactoryBotFactoryCallType)) break block9;
                    RubyFactoryBotFactory factory = RubyFactoryBotFactory.findByName(project, (SearchScope)element.getResolveScope(), newName);
                    for (PsiElement psiElement : factory.getDeclarations()) {
                        conflicts.putValue((Object)psiElement, (Object)RBundle.message((String)"ruby.factoryBot.rename.factory.conflict", (Object[])new Object[]{newName}));
                    }
                    break block10;
                }
                if (!(callType instanceof RubyFactoryBotSequenceCallType)) break block11;
                RubyFactoryBotSequence sequence = RubyFactoryBotSequence.findByName(project, (SearchScope)element.getResolveScope(), newName);
                for (PsiElement psiElement : sequence.getDeclarations()) {
                    conflicts.putValue((Object)psiElement, (Object)RBundle.message((String)"ruby.factoryBot.rename.sequence.conflict", (Object[])new Object[]{newName}));
                }
                break block10;
            }
            if (!(callType instanceof RubyFactoryBotTraitCallType)) break block10;
            List<RubyFactoryBotTrait> traits = RubyFactoryBotTrait.findAllByName(project, (SearchScope)element.getResolveScope(), newName);
            PsiManager manager = element.getManager();
            RBlockCall rBlockCall = RubyPsiUtil.getContainingRBlockCall(element);
            if (rBlockCall == null) {
                return;
            }
            for (RubyFactoryBotTrait trait : traits) {
                for (PsiElement psiElement : trait.getDeclarations()) {
                    if (!manager.areElementsEquivalent((PsiElement)rBlockCall, (PsiElement)RubyPsiUtil.getContainingRBlockCall(psiElement))) continue;
                    conflicts.putValue((Object)psiElement, (Object)RBundle.message((String)"ruby.factoryBot.rename.trait.conflict", (Object[])new Object[]{newName}));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/rename/RubyFactoryBotRenameProcessor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/rename/RubyFactoryBotRenameProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class MySequenceImplicitReferenceCollision
    extends UnresolvableCollisionUsageInfo {
        private final @NlsContexts.DialogMessage String myDescription;

        private MySequenceImplicitReferenceCollision(@NotNull PsiElement element, @NotNull PsiElement referencedElement) {
            if (element == null) {
                MySequenceImplicitReferenceCollision.$$$reportNull$$$0(0);
            }
            if (referencedElement == null) {
                MySequenceImplicitReferenceCollision.$$$reportNull$$$0(1);
            }
            super(element, referencedElement);
            this.myDescription = MySequenceImplicitReferenceCollision.createDescription(element);
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                MySequenceImplicitReferenceCollision.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NlsContexts.DialogMessage
        @NotNull
        private static String createDescription(@NotNull PsiElement element) {
            if (element == null) {
                MySequenceImplicitReferenceCollision.$$$reportNull$$$0(3);
            }
            RBlockCall blockCall = RubyPsiUtil.getContainingRBlockCall(element);
            String type = (String)ObjectUtils.doIfNotNull((Object)blockCall, RPossibleCall::getCommand);
            String name = (String)ObjectUtils.doIfNotNull((Object)blockCall, RubyFactoryBotModelCallType::getName);
            String string = RBundle.message((String)"ruby.factoryBot.rename.sequence.collision", (Object[])new Object[]{StringUtil.notNullize((String)type, (String)RBundle.message((String)"ruby.factoryBot.presentation.factoryOrTrait.type")), StringUtil.notNullize((String)name, (String)RBundle.message((String)"ruby.presentation.unknown"))});
            if (string == null) {
                MySequenceImplicitReferenceCollision.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedElement";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/rename/RubyFactoryBotRenameProcessor$MySequenceImplicitReferenceCollision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/factoryBot/lang/refactoring/rename/RubyFactoryBotRenameProcessor$MySequenceImplicitReferenceCollision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescription";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

