/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.surround;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.erb.codeInsight.ErbEditUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.surround.surrounders.RubySurrounderBase;

public class ErbSurrounderWrapper
implements Surrounder {
    private final RubySurrounderBase myBaseSurrounder;
    @NlsSafe
    private final String myDescription;

    public ErbSurrounderWrapper(RubySurrounderBase baseSurrounder, @NlsSafe String description) {
        this.myBaseSurrounder = baseSurrounder;
        this.myDescription = description;
    }

    public String getTemplateDescription() {
        return this.myDescription;
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ErbSurrounderWrapper.$$$reportNull$$$0(0);
        }
        if (ErbSurrounderWrapper.withinEmptyTag(elements)) {
            return false;
        }
        return elements.length > 0;
    }

    private static boolean withinEmptyTag(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ErbSurrounderWrapper.$$$reportNull$$$0(1);
        }
        if (elements.length == 2) {
            PsiElement start = elements[0];
            PsiElement end = elements[1];
            if (start instanceof XmlToken && end instanceof XmlToken) {
                String text;
                PsiElement tag;
                IElementType startType = ((XmlToken)start).getTokenType();
                IElementType endType = ((XmlToken)end).getTokenType();
                if (XmlTokenType.XML_END_TAG_START.equals(startType) && XmlTokenType.XML_TAG_END.equals(endType) && (tag = start.getParent()) instanceof XmlTag && (text = ((XmlTag)tag).getValue().getText()).matches("\\s+")) {
                    return true;
                }
            }
        }
        return false;
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) {
        PsiElement elementAt;
        RPsiElement insertedElement;
        String indent;
        int startLine;
        int lineStartOffset;
        String selectedText;
        if (project == null) {
            ErbSurrounderWrapper.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ErbSurrounderWrapper.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            ErbSurrounderWrapper.$$$reportNull$$$0(4);
        }
        if ((selectedText = editor.getSelectionModel().getSelectedText()) == null) {
            selectedText = RubySurrounderBase.gatherText(elements);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        StringBuilder textBuilder = new StringBuilder();
        int startOffset = editor.getSelectionModel().getSelectionStart();
        if (startOffset - (lineStartOffset = document.getLineStartOffset(startLine = document.getLineNumber(startOffset))) < (indent = ErbEditUtil.getIndentAt((PsiFile)file, (int)elements[0].getTextRange().getStartOffset())).length()) {
            textBuilder.append(indent, 0, indent.length() - startOffset + lineStartOffset);
        }
        textBuilder.append("<% ");
        int injectionPrefixLength = textBuilder.length();
        textBuilder.append(this.myBaseSurrounder.getSurroundPrefix().trim()).append(" %>\n");
        textBuilder.append(indent).append(ErbSurrounderWrapper.indentLines(selectedText.trim(), document, project)).append("\n");
        this.appendSurroundSuffix(textBuilder, indent);
        if (selectedText.endsWith("\n")) {
            textBuilder.append("\n");
        }
        document.replaceString(startOffset, elements[elements.length - 1].getTextRange().getEndOffset(), (CharSequence)textBuilder.toString());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        if (file != null && (insertedElement = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = file.getViewProvider().findElementAt(startOffset + injectionPrefixLength + 1, (Language)RubyLanguage.INSTANCE)), RPsiElement.class)) != null) {
            return this.myBaseSurrounder.getTextRange(insertedElement);
        }
        return null;
    }

    protected void appendSurroundSuffix(StringBuilder textBuilder, String indent) {
        textBuilder.append(indent).append("<% ").append(this.myBaseSurrounder.getSurroundSuffix().trim()).append(" %>");
    }

    private static String indentLines(String s, Document document, Project project) {
        List lines = StringUtil.split((String)s, (String)"\n");
        VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
        FileType fileType = vFile == null ? null : vFile.getFileType();
        int blockIndent = CodeStyleFacade.getInstance((Project)project).getIndentSize(fileType);
        String indentPrefix = StringUtil.repeatSymbol((char)' ', (int)blockIndent);
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(indentPrefix);
            result.append(line);
            result.append("\n");
        }
        return !result.isEmpty() ? result.substring(0, result.length() - 1) : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErbSurrounderWrapper wrapper = (ErbSurrounderWrapper)o;
        return !(this.myDescription != null ? !this.myDescription.equals(wrapper.myDescription) : wrapper.myDescription != null);
    }

    public int hashCode() {
        return this.myDescription != null ? this.myDescription.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/erb/surround/ErbSurrounderWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withinEmptyTag";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

