/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbLanguage;
import org.jetbrains.plugins.ruby.erb.structureView.ErbStructureViewTagElement;
import org.jetbrains.plugins.ruby.erb.structureView.ErbXmlTagTreeElement;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

class ErbStructureViewPsiVisitor
extends PsiRecursiveElementVisitor {
    @NotNull
    private final List<PsiElement> myPsiElements;
    @NotNull
    private final PsiFile myErbFile;

    ErbStructureViewPsiVisitor(@NotNull PsiFile erbFile) {
        if (erbFile == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(0);
        }
        this.myPsiElements = new ArrayList<PsiElement>();
        this.myErbFile = erbFile;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        if (element instanceof XmlTag || element instanceof OuterLanguageElement && element.getLanguage().is((Language)ErbLanguage.INSTANCE)) {
            this.myPsiElements.add(element);
        } else {
            element.acceptChildren((PsiElementVisitor)this);
        }
    }

    @NotNull
    public List<StructureViewTreeElement> getElements() {
        ArrayList<StructureViewTreeElement> elements = new ArrayList<StructureViewTreeElement>();
        int i = 0;
        while (i < this.myPsiElements.size()) {
            Pair<StructureViewTreeElement, Integer> current = this.getStructureViewElementWithChildren(this.myPsiElements, i);
            if (current.getFirst() != null) {
                elements.add((StructureViewTreeElement)current.getFirst());
            }
            i = (Integer)current.getSecond();
        }
        ArrayList<StructureViewTreeElement> arrayList = elements;
        if (arrayList == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private Pair<StructureViewTreeElement, Integer> getStructureViewElementWithChildren(@NotNull List<PsiElement> elements, int start) {
        PsiElement current;
        if (elements == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(3);
        }
        ArrayList<StructureViewTreeElement> nested = new ArrayList<StructureViewTreeElement>();
        PsiElement original = current = elements.get(start++);
        if (current instanceof OuterLanguageElement) {
            current = ErbStructureViewPsiVisitor.getRPsiElementForErbInjection(current);
        }
        if (!(current instanceof RBlockCall) || start >= elements.size()) {
            Pair pair = Pair.pair((Object)this.getStructureViewElement(original), (Object)start);
            if (pair == null) {
                ErbStructureViewPsiVisitor.$$$reportNull$$$0(4);
            }
            return pair;
        }
        PsiElement next = elements.get(start);
        while (current.getTextRange().contains(next.getTextRange())) {
            Pair<StructureViewTreeElement, Integer> elementAndIndex = this.getStructureViewElementWithChildren(elements, start);
            start = (Integer)elementAndIndex.getSecond();
            if (elementAndIndex.getFirst() != null) {
                nested.add((StructureViewTreeElement)elementAndIndex.getFirst());
            }
            if (start >= elements.size()) break;
            next = elements.get(start);
        }
        String openingTag = Objects.requireNonNull(ErbStructureViewPsiVisitor.getErbOpeningTagForInjection(original)).getText();
        Pair pair = Pair.pair((Object)((Object)new ErbStructureViewTagElement((RPsiElement)current, openingTag, this.myErbFile, nested)), (Object)start);
        if (pair == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Nullable
    private StructureViewTreeElement getStructureViewElement(@Nullable PsiElement element) {
        if (element instanceof XmlTag) {
            return new ErbXmlTagTreeElement((XmlTag)element, this.myErbFile);
        }
        if (element instanceof OuterLanguageElement) {
            PsiElement openingTag = ErbStructureViewPsiVisitor.getErbOpeningTagForInjection(element);
            RPsiElement rPsiElement = ErbStructureViewPsiVisitor.getRPsiElementForErbInjection(element);
            if (rPsiElement instanceof RPossibleCall || rPsiElement instanceof RIfModStatement || rPsiElement instanceof RUntilModStatement) {
                return new ErbStructureViewTagElement(rPsiElement, Objects.requireNonNull(openingTag).getText(), this.myErbFile);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getErbOpeningTagForInjection(@NotNull PsiElement injection) {
        if (injection == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(6);
        }
        FileViewProvider viewProvider = injection.getContainingFile().getViewProvider();
        PsiFile baseFile = viewProvider.getPsi((Language)ErbLanguage.INSTANCE);
        return (PsiElement)ObjectUtils.doIfNotNull((Object)baseFile, file -> file.findElementAt(injection.getTextOffset()));
    }

    @Nullable
    private static RPsiElement getRPsiElementForErbInjection(@NotNull PsiElement injection) {
        PsiElement openingTag;
        PsiElement erbElement;
        if (injection == null) {
            ErbStructureViewPsiVisitor.$$$reportNull$$$0(7);
        }
        if ((erbElement = (PsiElement)ObjectUtils.doIfNotNull((Object)(openingTag = ErbStructureViewPsiVisitor.getErbOpeningTagForInjection(injection)), PsiElement::getNextSibling)) == null) {
            return null;
        }
        FileViewProvider viewProvider = erbElement.getContainingFile().getViewProvider();
        PsiFile rubyFile = viewProvider.getPsi((Language)RubyLanguage.INSTANCE);
        PsiElement rubyFileElement = (PsiElement)ObjectUtils.doIfNotNull((Object)rubyFile, file -> file.findElementAt(erbElement.getTextOffset()));
        return (RPsiElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)rubyFileElement, RPsiElement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erbFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/structureView/ErbStructureViewPsiVisitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/structureView/ErbStructureViewPsiVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructureViewElementWithChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStructureViewElementWithChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErbOpeningTagForInjection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRPsiElementForErbInjection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

