/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.ErbElementTypes;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;

public final class ErbFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private static final Logger LOG = Logger.getInstance(ErbFoldingBuilder.class);
    @NonNls
    public static final String ERB_COMMENT_FOLD_TEXT = "<%#...%>";
    @NonNls
    private static final String ERB_SCRIPTLET_FOLD_TEXT = "<%...%>";
    @NonNls
    private static final String ERB_EXPRESSION_FOLD_TEXT = "<%=...%>";
    @NonNls
    private static final String ERB_RAW_EXPRESSION_FOLD_TEXT = "<%==...%>";
    @NonNls
    private static final String XML_COMMENT_OPEN_TAG = "...";
    private static final TokenSet COLLAPSED_BY_DEFAULT = TokenSet.create((IElementType[])new IElementType[]{ErbElementTypes.ERB_COMMENT_ELEMENT});
    private static final TokenSet FOLDED_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{ErbElementTypes.ERB_XML_TAG, ErbElementTypes.ERB_COMMENT_ELEMENT});

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        ErbFoldingBuilder.gatherDescriptors(astNode, descriptors, document);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private static void gatherDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, @NotNull Document document) {
        IElementType type;
        if (node == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (document == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (FOLDED_ELEMENTS.contains(type = node.getElementType())) {
            int endLine;
            int startLine;
            ASTNode first = node.getFirstChildNode();
            ASTNode last = node.getLastChildNode();
            if (first != null && last != null && first != last && (startLine = document.getLineNumber(first.getStartOffset())) != (endLine = document.getLineNumber(last.getStartOffset() + last.getTextLength()))) {
                descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            ErbFoldingBuilder.gatherDescriptors(child, descriptors, document);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((nodeType = node.getElementType()) == ErbElementTypes.ERB_XML_TAG) {
            ASTNode tagOpen = node.getFirstChildNode();
            if (tagOpen == null) {
                return null;
            }
            IElementType type = tagOpen.getElementType();
            if (type == ErbTokenTypes.ERB_SCRIPTLET_START) {
                return ERB_SCRIPTLET_FOLD_TEXT;
            }
            if (type == ErbTokenTypes.ERB_EXPRESSION_START) {
                return ERB_EXPRESSION_FOLD_TEXT;
            }
            if (type == ErbTokenTypes.ERB_RAW_EXPRESSION_START) {
                return ERB_RAW_EXPRESSION_FOLD_TEXT;
            }
            return null;
        }
        if (nodeType == ErbElementTypes.ERB_COMMENT_ELEMENT) {
            return ERB_COMMENT_FOLD_TEXT;
        }
        PsiElement psi = node.getPsi();
        if (psi instanceof XmlComment || psi instanceof XmlTag) {
            return XML_COMMENT_OPEN_TAG;
        }
        LOG.error("Unknown element:" + String.valueOf(psi));
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            ErbFoldingBuilder.$$$reportNull$$$0(7);
        }
        return COLLAPSED_BY_DEFAULT.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/ErbFoldingBuilder";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/ErbFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "gatherDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

