/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.duplocator;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.duplocator.RubyDuplocatorSettings;
import org.jetbrains.plugins.ruby.duplocator.RubyTreeHasher;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class RubySpecificHasher
extends NodeSpecificHasher {
    private final TreeHasher myTreeHasher;
    private final RubyDuplocatorSettings mySettings;

    public RubySpecificHasher(@NotNull RubyDuplocatorSettings settings, @NotNull FragmentsCollector callback, boolean forIndexing) {
        if (settings == null) {
            RubySpecificHasher.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            RubySpecificHasher.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
        this.myTreeHasher = new RubyTreeHasher(callback, settings, forIndexing);
    }

    public int getNodeCost(PsiElement node) {
        if (node instanceof RPseudoConstant || node instanceof RGroupedExpression || node instanceof RCompoundStatement || node instanceof RBodyStatement || node instanceof RCodeBlock || node instanceof RListOfExpressions || node instanceof RContainer) {
            return 0;
        }
        return 1;
    }

    public int getNodeHash(PsiElement node) {
        RIdentifier rIdentifier;
        if (node instanceof RBinaryExpression) {
            return ((RBinaryExpression)node).getOperationType().toString().hashCode();
        }
        if (node instanceof RUnaryExpression) {
            return ((RUnaryExpression)node).getOperationName().hashCode();
        }
        if (node instanceof RAssignmentExpression) {
            IElementType type = ((RAssignmentExpression)node).getOperationType();
            return type != null ? type.toString().hashCode() : 0;
        }
        if (node instanceof RSymbol) {
            return ((RSymbol)node).getValue().hashCode();
        }
        if (node instanceof RLiteral) {
            if (!this.mySettings.DISTINGUISH_LITERALS) {
                return 0;
            }
            return ((RLiteral)node).getContent().hashCode();
        }
        if (node instanceof RGlobalVariable || node instanceof RConstant) {
            if (!this.mySettings.DISTINGUISH_VARIABLES) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RField) {
            if (!this.mySettings.DISTINGUISH_FIELDS) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RIdentifier && ((rIdentifier = (RIdentifier)node).isParameterDeclaration() || rIdentifier.isLocalVariable())) {
            if (!this.mySettings.DISTINGUISH_VARIABLES) {
                return 0;
            }
            return node.getText().hashCode();
        }
        if (node instanceof RMethod) {
            int hash = ((RMethod)node).getPresentableName(false).hashCode();
            for (ArgumentInfo info : ((RMethod)node).getArgumentInfos()) {
                hash = hash * 31 + info.getType().ordinal();
                if (!this.mySettings.DISTINGUISH_VARIABLES) continue;
                hash = hash * 31 + info.getName().hashCode();
            }
            return hash;
        }
        if (node instanceof RContainer) {
            return ((RContainer)node).getFQN().hashCode();
        }
        return 0;
    }

    public List<PsiElement> getNodeChildren(final PsiElement node) {
        if (node == null) {
            return Collections.emptyList();
        }
        final ArrayList result = new ArrayList();
        node.accept((PsiElementVisitor)new RubyElementVisitor(this){

            public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.add(ifStatement.getCondition());
                result.addAll(ifStatement.getThenBlock().getStatements());
                result.addAll(ifStatement.getElsifBlocks());
                result.add(ifStatement.getElseBlock());
            }

            public void visitRIfModStatement(@NotNull RIfModStatement ifModStatement) {
                if (ifModStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitRModifierStatement((RModifierStatement)ifModStatement);
            }

            public void visitRUnlessStatement(@NotNull RUnlessStatement unlessStatement) {
                if (unlessStatement == null) {
                    1.$$$reportNull$$$0(2);
                }
                result.add(unlessStatement.getCondition());
                result.addAll(unlessStatement.getThenBlock().getStatements());
                result.add(unlessStatement.getElseBlock());
            }

            public void visitRUnlessModStatement(@NotNull RUnlessModStatement unlessModStatement) {
                if (unlessModStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visitRModifierStatement((RModifierStatement)unlessModStatement);
            }

            public void visitRWhileStatement(@NotNull RWhileStatement whileStatement) {
                if (whileStatement == null) {
                    1.$$$reportNull$$$0(4);
                }
                result.add(whileStatement.getCondition());
                result.addAll(whileStatement.getLoopBody().getStatements());
            }

            public void visitRWhileModStatement(@NotNull RWhileModStatement whileModStatement) {
                if (whileModStatement == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.visitRModifierStatement((RModifierStatement)whileModStatement);
            }

            public void visitRUntilStatement(@NotNull RUntilStatement untilStatement) {
                if (untilStatement == null) {
                    1.$$$reportNull$$$0(6);
                }
                result.add(untilStatement.getCondition());
                result.addAll(untilStatement.getLoopBody().getStatements());
            }

            public void visitRUntilModStatement(@NotNull RUntilModStatement untilModStatement) {
                if (untilModStatement == null) {
                    1.$$$reportNull$$$0(7);
                }
                this.visitRModifierStatement((RModifierStatement)untilModStatement);
            }

            private void visitRModifierStatement(RModifierStatement modifierStatement) {
                result.add(modifierStatement.getCondition());
                result.add(modifierStatement.getCommand());
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(8);
                }
                result.addAll(RubyPsiUtilCore.getChildrenByFilter((PsiElement)node, RPsiElement.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifModStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unlessStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unlessModStatement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "whileStatement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "whileModStatement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "untilStatement";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "untilModStatement";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/duplocator/RubySpecificHasher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIfStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIfModStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUnlessStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUnlessModStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRWhileStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRWhileModStatement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUntilStatement";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRUntilModStatement";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return RubyPsiUtil.collectNotNull(result);
    }

    private static boolean checkModifierStatements(PsiElement node1, PsiElement node2) {
        if ((node1 instanceof RIfStatement || node1 instanceof RIfModStatement) && (node2 instanceof RIfStatement || node2 instanceof RIfModStatement)) {
            return true;
        }
        if ((node1 instanceof RUnlessStatement || node1 instanceof RUnlessModStatement) && (node2 instanceof RUnlessStatement || node2 instanceof RUnlessModStatement)) {
            return true;
        }
        if ((node1 instanceof RWhileStatement || node1 instanceof RWhileModStatement) && (node2 instanceof RWhileStatement || node2 instanceof RWhileModStatement)) {
            return true;
        }
        return !(!(node1 instanceof RUntilStatement) && !(node1 instanceof RUntilModStatement) || !(node2 instanceof RUntilStatement) && !(node2 instanceof RUntilModStatement));
    }

    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            RubySpecificHasher.$$$reportNull$$$0(2);
        }
        if (node2 == null) {
            RubySpecificHasher.$$$reportNull$$$0(3);
        }
        if (RubySpecificHasher.checkModifierStatements(node1, node2)) {
            return true;
        }
        if (node1.getClass().equals(node2.getClass())) {
            RIdentifier rIdentifier;
            if (node1 instanceof RBinaryExpression && ((RBinaryExpression)node1).getOperationType() != ((RBinaryExpression)node2).getOperationType()) {
                return false;
            }
            if (node1 instanceof RUnaryExpression && ((RUnaryExpression)node1).getOperationName().equals(((RUnaryExpression)node2).getOperationName())) {
                return false;
            }
            if (node1 instanceof RAssignmentExpression && ((RAssignmentExpression)node1).getOperationType() != ((RAssignmentExpression)node2).getOperationType()) {
                return false;
            }
            if (node1 instanceof RSymbol && !Objects.equals(((RSymbol)node1).getValue(), ((RSymbol)node2).getValue())) {
                return false;
            }
            if (node1 instanceof RLiteral && this.mySettings.DISTINGUISH_LITERALS && !((RLiteral)node1).getContent().equals(((RLiteral)node2).getContent())) {
                return false;
            }
            if ((node1 instanceof RGlobalVariable || node1 instanceof RConstant) && this.mySettings.DISTINGUISH_VARIABLES && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RField && this.mySettings.DISTINGUISH_FIELDS && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RIdentifier && ((rIdentifier = (RIdentifier)node1).isParameterDeclaration() || rIdentifier.isLocalVariable()) && this.mySettings.DISTINGUISH_VARIABLES && !node1.getText().equals(node2.getText())) {
                return false;
            }
            if (node1 instanceof RMethod) {
                if (!((RMethod)node1).getPresentableName(false).equals(((RMethod)node2).getPresentableName(false))) {
                    return false;
                }
                List list1 = ((RMethod)node1).getArgumentInfos();
                List list2 = ((RMethod)node2).getArgumentInfos();
                if (list1.size() != list2.size()) {
                    return false;
                }
                Iterator iterator1 = list1.iterator();
                Iterator iterator2 = list2.iterator();
                while (iterator1.hasNext()) {
                    ArgumentInfo info1 = (ArgumentInfo)iterator1.next();
                    ArgumentInfo info2 = (ArgumentInfo)iterator2.next();
                    if (info1.getType() != info2.getType()) {
                        return false;
                    }
                    if (!this.mySettings.DISTINGUISH_VARIABLES || info1.getName().equals(info2.getName())) continue;
                    return false;
                }
            }
            return !(node1 instanceof RContainer) || ((RContainer)node1).getFQN().equals((Object)((RContainer)node2).getFQN());
        }
        return false;
    }

    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    public void visitNode(@NotNull PsiElement node) {
        PsiFile psiFile;
        if (node == null) {
            RubySpecificHasher.$$$reportNull$$$0(4);
        }
        if ((psiFile = node.getContainingFile().getViewProvider().getPsi((Language)RubyLanguage.INSTANCE)) instanceof RFile) {
            for (RPsiElement element : ((RFile)psiFile).getStatements()) {
                this.myTreeHasher.hash((PsiElement)element, (NodeSpecificHasher)this);
            }
        }
    }

    public void hashingFinished() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/duplocator/RubySpecificHasher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesEqual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

