/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.duplocator;

import com.intellij.DynamicBundle;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.plugins.ruby.duplocator.RubyDuplocatorSettings;

public class RubyDuplocatorSettingsEditor
implements DuplocatorSettingsEditor {
    private JPanel mySensitivityPanel;
    private JCheckBox myDistinguishLocalVariables;
    private JCheckBox myDistinguishMethods;
    private JCheckBox myDistinguishFields;
    private JCheckBox myDistinguishLiterals;
    private JSpinner myDiscardCostSpinner;
    private JSpinner myLowBoundSpinner;

    public RubyDuplocatorSettingsEditor() {
        this.$$$setupUI$$$();
        RubyDuplocatorSettings comp = RubyDuplocatorSettings.getInstance();
        this.myLowBoundSpinner.setModel(new SpinnerNumberModel(comp.LOWER_BOUND, 10, 100, 1));
        this.myDistinguishLocalVariables.setSelected(!comp.DISTINGUISH_VARIABLES);
        this.myDistinguishMethods.setSelected(!comp.DISTINGUISH_METHODS);
        this.myDistinguishFields.setSelected(!comp.DISTINGUISH_FIELDS);
        this.myDistinguishLiterals.setSelected(!comp.DISTINGUISH_LITERALS);
        this.myDiscardCostSpinner.setModel(new SpinnerNumberModel(comp.DISCARD_COST, 0, 15, 1));
        this.myDiscardCostSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                RubyDuplocatorSettingsEditor.this.validateComponent();
            }
        });
    }

    public void apply() {
        RubyDuplocatorSettings comp = RubyDuplocatorSettings.getInstance();
        comp.DISTINGUISH_VARIABLES = !this.myDistinguishLocalVariables.isSelected();
        comp.DISTINGUISH_METHODS = !this.myDistinguishMethods.isSelected();
        comp.DISTINGUISH_FIELDS = !this.myDistinguishFields.isSelected();
        comp.DISTINGUISH_LITERALS = !this.myDistinguishLiterals.isSelected();
        comp.DISCARD_COST = RubyDuplocatorSettingsEditor.getSpinnerValue(this.myDiscardCostSpinner);
        comp.LOWER_BOUND = RubyDuplocatorSettingsEditor.getSpinnerValue(this.myLowBoundSpinner);
    }

    private static int getSpinnerValue(JSpinner spinner) {
        return ((SpinnerNumberModel)spinner.getModel()).getNumber().intValue();
    }

    public JComponent getComponent() {
        return this.mySensitivityPanel;
    }

    public void validateComponent() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JPanel jPanel;
        this.mySensitivityPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 15, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDiscardCostSpinner = jSpinner2 = new JSpinner();
        jPanel2.add((Component)jSpinner2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.anonymize.uncommon.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLowBoundSpinner = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(50, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.minimum.cost.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 3, 0, 0, null, null, null));
        this.myDistinguishLocalVariables = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.anonymize.local.variables.checkbox"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishFields = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.anonymize.fields.checkbox"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishMethods = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.anonymize.methods.checkbox"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDistinguishLiterals = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DupLocatorBundle", RubyDuplocatorSettingsEditor.class).getString("duplication.anonymize.literals.checkbox"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mySensitivityPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

