/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationFactoryBase;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

public final class IrbRunConfigurationFactory
extends RubyRunConfigurationFactoryBase {
    private static final Map<String, String> DEFAULT_ENVIRONMENT_VARIABLES = Map.of("TERM", "dumb");

    public IrbRunConfigurationFactory(@NotNull ConfigurationType type) {
        if (type == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(0);
        }
        super(type, IrbRunConfiguration::new, "IRB console");
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfigurationSettings(@NotNull Module module, @NotNull String configurationName, @Nullable String scriptPath, @NotNull List<String> scriptArgs, @NotNull IrbConsoleType consoleType) {
        if (module == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(1);
        }
        if (configurationName == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(2);
        }
        if (scriptArgs == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(3);
        }
        if (consoleType == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(4);
        }
        RunnerAndConfigurationSettings settings = RunConfigurationUtil.createSettings(module.getProject(), this, "");
        IrbRunConfiguration configuration = (IrbRunConfiguration)settings.getConfiguration();
        configuration.setName(configurationName);
        configuration.setScriptPath(scriptPath);
        configuration.setScriptArgs(ParametersList.join(scriptArgs));
        configuration.setConsoleType(consoleType);
        this.initWithDefaultModule(configuration, module);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            IrbRunConfigurationFactory.$$$reportNull$$$0(5);
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    protected void initTemplateDefaultParams(AbstractRubyRunConfiguration conf) {
        super.initTemplateDefaultParams(conf);
        conf.setEnvs(DEFAULT_ENVIRONMENT_VARIABLES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArgs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfigurationFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationSettings";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

