/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

final class IrbRunConfigurationExternalizer
extends SettingsExternalizer {
    @NonNls
    public static final String IRB_RUN_CONFIG_SETTINGS_ARGS = "IRB_RUN_CONFIG";
    @NonNls
    private static final String SCRIPT_PATH = "SCRIPT_PATH";
    @NonNls
    private static final String SCRIPT_ARGS = "SCRIPT_ARGS";
    @NonNls
    private static final String CONSOLE_TYPE = "CONSOLE_TYPE";
    @NonNls
    private static final String IS_RAILS_CONSOLE = "IS_RAILS_CONSOLE";
    private static final IrbRunConfigurationExternalizer ourInstance = new IrbRunConfigurationExternalizer();

    private IrbRunConfigurationExternalizer() {
    }

    public void writeExternal(@NotNull IrbRunConfiguration config, @NotNull Element elem) {
        if (config == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(0);
        }
        if (elem == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(1);
        }
        this.writeOption(SCRIPT_PATH, config.getScriptPath(), elem);
        this.writeOption(SCRIPT_ARGS, config.getScriptArgs(), elem);
        this.writeOption(CONSOLE_TYPE, config.getConsoleType().toString(), elem);
    }

    public void readExternal(@NotNull IrbRunConfiguration config, @NotNull Element elem) {
        if (config == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(2);
        }
        if (elem == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(3);
        }
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setScriptPath(optionsByName.get(SCRIPT_PATH));
        config.setScriptArgs(optionsByName.get(SCRIPT_ARGS));
        config.setConsoleType(IrbRunConfigurationExternalizer.getConsoleType(optionsByName));
    }

    @NotNull
    private static IrbConsoleType getConsoleType(@NotNull Map<String, String> optionsByName) {
        IrbConsoleType consoleType;
        if (optionsByName == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(4);
        }
        if ((consoleType = IrbRunConfigurationExternalizer.getConsoleTypeFromLegacyOption(optionsByName.get(IS_RAILS_CONSOLE))) != null) {
            IrbConsoleType irbConsoleType = consoleType;
            if (irbConsoleType == null) {
                IrbRunConfigurationExternalizer.$$$reportNull$$$0(5);
            }
            return irbConsoleType;
        }
        consoleType = (IrbConsoleType)((Object)ObjectUtils.doIfNotNull((Object)optionsByName.get(CONSOLE_TYPE), IrbConsoleType::valueOf));
        IrbConsoleType irbConsoleType = consoleType == null || consoleType == IrbConsoleType.NOT_SET ? IrbConsoleType.fromScriptPath(optionsByName.get(SCRIPT_PATH)) : consoleType;
        if (irbConsoleType == null) {
            IrbRunConfigurationExternalizer.$$$reportNull$$$0(6);
        }
        return irbConsoleType;
    }

    @Nullable
    private static IrbConsoleType getConsoleTypeFromLegacyOption(@Nullable String isRailsOption) {
        if (isRailsOption == null) {
            return null;
        }
        return Boolean.parseBoolean(isRailsOption) ? IrbConsoleType.RAILS : IrbConsoleType.IRB;
    }

    @Override
    @NotNull
    public String getID() {
        return IRB_RUN_CONFIG_SETTINGS_ARGS;
    }

    public static IrbRunConfigurationExternalizer getInstance() {
        return ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsByName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfigurationExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbRunConfigurationExternalizer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleType";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

