/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console.config;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IrbConsoleType {
    IRB("IRB", "rb/consoles/irb_config.rb", "rb/consoles/exec/irb"),
    RAILS("Rails", "rb/consoles/rails_config.rb", null),
    PRY("Pry", "rb/consoles/pry_config.rb", "rb/consoles/exec/pry"),
    NOT_SET("Not set", null, null);

    @NotNull
    @NlsSafe
    private final String myName;
    @Nullable
    @NonNls
    private final String myConfigPath;
    @Nullable
    @NonNls
    private final String myExecPath;

    private IrbConsoleType(@Nullable String name, String configPath, String execPath) {
        if (name == null) {
            IrbConsoleType.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myConfigPath = configPath;
        this.myExecPath = execPath;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            IrbConsoleType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getConfigPath() {
        return this.myConfigPath;
    }

    @Nullable
    public String getDefaultExecutable() {
        return this.myExecPath;
    }

    @NotNull
    static IrbConsoleType fromScriptPath(@NotNull String scriptPath) {
        String executable;
        if (scriptPath == null) {
            IrbConsoleType.$$$reportNull$$$0(2);
        }
        IrbConsoleType irbConsoleType = switch (executable = PathUtil.getFileName((String)scriptPath)) {
            case "irb", "irb.rb" -> IRB;
            case "rails", "zeus", "spring" -> RAILS;
            case "pry" -> PRY;
            default -> NOT_SET;
        };
        if (irbConsoleType == null) {
            IrbConsoleType.$$$reportNull$$$0(3);
        }
        return irbConsoleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/config/IrbConsoleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/config/IrbConsoleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromScriptPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromScriptPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

