/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PlatformUtils;
import icons.RubyIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfigurationType;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.actions.RubyScriptAction;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RunIRBConsoleAction
extends RubyScriptAction
implements DumbAware {
    public RunIRBConsoleAction() {
        super(RubyIcons.Ruby.RubyTerminal);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(0);
        }
        Module module = RModuleUtil.getInstance().getModule(e.getDataContext());
        boolean isEnabled = this.isEnabled(RModuleUtil.getInstance().findRubySdkForModule(module));
        Presentation presentation = e.getPresentation();
        presentation.setVisible(PlatformUtils.isRubyMine() ? module != null : isEnabled);
        presentation.setEnabled(isEnabled);
    }

    @Override
    protected void doActionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(1);
        }
        Module module = RModuleUtil.getInstance().getModule(e.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null) : "sdk is null";
        ReadAction.run(() -> {
            RunnerAndConfigurationSettings settings = IrbRunConfigurationType.getInstance().getFactory().createConfigurationSettings(module, this.getRunConfigurationName(module), this.getConsoleExecutablePath(sdk, module), Collections.emptyList(), this.getConsoleType());
            IrbUtil.setWorkingDirectory(module, (IrbRunConfiguration)settings.getConfiguration());
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            runManager.setTemporaryConfiguration(settings);
            RunConfigurationUtil.executeConfiguration(runManager, settings, null);
        });
    }

    protected boolean isEnabled(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk);
        List<GemInfo> gems = RubyGemSearchService.getInstance().findGems(sdk, "irb");
        return languageLevel.isLessThan(LanguageLevel.RUBY26) || !gems.isEmpty();
    }

    @Nullable
    protected String getConsoleExecutablePath(@NotNull Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(2);
        }
        return IrbUtil.findIrbExecutable(sdk, module);
    }

    @NotNull
    @NlsSafe
    protected String getRunConfigurationName(@NotNull Module module) {
        if (module == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(3);
        }
        String string = RBundle.message((String)"irb.console", (Object[])new Object[]{module.getName()});
        if (string == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected IrbConsoleType getConsoleType() {
        IrbConsoleType irbConsoleType = IrbConsoleType.IRB;
        if (irbConsoleType == null) {
            RunIRBConsoleAction.$$$reportNull$$$0(5);
        }
        return irbConsoleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/RunIRBConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/RunIRBConsoleAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleExecutablePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

