/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyConsoleSessionHelper;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelServiceBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyLanguageConsole
extends LanguageConsoleImpl {
    protected final RubyConsoleSessionHelper mySessionHelper;

    public RubyLanguageConsole(@NotNull Project project, @NotNull String title, final @NotNull RubyConsoleSessionHelper sessionHelper) {
        if (project == null) {
            RubyLanguageConsole.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RubyLanguageConsole.$$$reportNull$$$0(1);
        }
        if (sessionHelper == null) {
            RubyLanguageConsole.$$$reportNull$$$0(2);
        }
        super(new LanguageConsoleImpl.Helper(project, (VirtualFile)new LightVirtualFile("Ruby Console", (Language)RubyLanguage.INSTANCE, (CharSequence)"")){

            @NotNull
            public PsiFile getFile() {
                RubyExpressionCodeFragmentImpl fragment = new RubyExpressionCodeFragmentImpl(this.project, this.virtualFile, true);
                fragment.setContext((PsiElement)sessionHelper.getFile());
                RubyLanguageConsole.setupLanguageLevelForFile(this.project, this.virtualFile, (PsiFile)fragment);
                RubyExpressionCodeFragmentImpl rubyExpressionCodeFragmentImpl = fragment;
                if (rubyExpressionCodeFragmentImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return rubyExpressionCodeFragmentImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/console/RubyLanguageConsole$1", "getFile"));
            }
        }.setTitle(title));
        this.mySessionHelper = sessionHelper;
    }

    public void setContext(@Nullable PsiElement context) {
        this.mySessionHelper.setContext(context);
    }

    @NotNull
    protected RubyConsoleSessionHelper getSessionHelper() {
        RubyConsoleSessionHelper rubyConsoleSessionHelper = this.mySessionHelper;
        if (rubyConsoleSessionHelper == null) {
            RubyLanguageConsole.$$$reportNull$$$0(3);
        }
        return rubyConsoleSessionHelper;
    }

    @NotNull
    @NlsSafe
    protected String suppressEcho(@NotNull String text) {
        if (text == null) {
            RubyLanguageConsole.$$$reportNull$$$0(4);
        }
        String string = text;
        if (string == null) {
            RubyLanguageConsole.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void receiveInputPrompt(@NotNull String prompt) {
        if (prompt == null) {
            RubyLanguageConsole.$$$reportNull$$$0(6);
        }
        this.setPrompt(prompt);
        if (prompt.equals(">>")) {
            this.mySessionHelper.commitSessionChunk();
        }
    }

    private static void setupLanguageLevelForFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull PsiFile psiFile) {
        if (project == null) {
            RubyLanguageConsole.$$$reportNull$$$0(7);
        }
        if (file == null) {
            RubyLanguageConsole.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            RubyLanguageConsole.$$$reportNull$$$0(9);
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        LanguageLevel languageLevel = null;
        Module rubyModule = null;
        for (Module module : modules) {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) continue;
            languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk);
            rubyModule = module;
        }
        if (languageLevel != null) {
            RubyLanguageLevelServiceBase.registerFileLanguageLevel((VirtualFile)file, languageLevel);
            psiFile.putUserData(ModuleUtilCore.KEY_MODULE, rubyModule);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionHelper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/RubyLanguageConsole";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/RubyLanguageConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressEcho";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suppressEcho";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "receiveInputPrompt";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupLanguageLevelForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

