/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleProcessHandlerEx;

public final class RubyConsoleTextProcessor {
    private static final Logger LOG = Logger.getInstance(RubyConsoleTextProcessor.class);
    @NonNls
    private static final String NUMBERS = "(?<![\\w_#$=])(\\d+(?:_\\d+)*(?:\\.\\d+)?)";
    @NonNls
    private static final String STRINGS = "((?:\"[^\"\n]*\")|(?:(?<!\\w)'[^'\n]*'))";
    @NonNls
    private static final String SYMBOLS = "((?<![:\\w]):[a-z_]+)";
    private static final Pattern CODE_TOKEN_PATTERN = Pattern.compile("(?<![\\w_#$=])(\\d+(?:_\\d+)*(?:\\.\\d+)?)|((?:\"[^\"\n]*\")|(?:(?<!\\w)'[^'\n]*'))|((?<![:\\w]):[a-z_]+)");
    private static final Key<?> STRING_KEY = new Key("RUBY_STRING");
    private static final Key<?> NUMBER_KEY = new Key("RUBY_NUMBER");
    private static final Key<?> SYMBOL_KEY = new Key("RUBY_SYMBOL");
    @NonNls
    private static final String RESET_COLORS_ANSI_CODE = "\u001b[0;0m";
    @NonNls
    public static final String INPUT_PROMPT = ">>";
    @NonNls
    public static final String INPUT_CONTINUATION_PROMPT = "?>";
    @NotNull
    private final RubyConsoleProcessHandlerEx myProcessHandler;

    public RubyConsoleTextProcessor(@NotNull RubyConsoleProcessHandlerEx processHandler) {
        if (processHandler == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(0);
        }
        this.myProcessHandler = processHandler;
    }

    public void textAvailable(@NotNull String text, @NotNull Key<?> outputType) {
        if (text == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(1);
        }
        if (outputType == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(2);
        }
        RubyLanguageConsole consoleView = this.getConsole();
        this.myProcessHandler.notifyDebugSession(text, outputType);
        for (Pair<String, ConsoleViewContentType> consoleContentChunk : this.getContentToPrint(text, outputType)) {
            consoleView.print((String)consoleContentChunk.first, (ConsoleViewContentType)consoleContentChunk.second);
        }
    }

    @NotNull
    private List<Pair<String, ConsoleViewContentType>> getContentToPrint(@NotNull String text, @NotNull Key<?> outputType) {
        if (text == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Text available: ", new Object[]{IrbUtil.toLog(text), "\t[", outputType.toString(), "]"});
        }
        MyConsoleContentBuilder contentToPrint = new MyConsoleContentBuilder();
        RubyLanguageConsole console = this.getConsole();
        for (String line : StringUtil.splitByLinesKeepSeparators((String)text)) {
            Matcher codeTokenMatcher;
            if (line.equals(INPUT_PROMPT) || line.equals(INPUT_CONTINUATION_PROMPT)) {
                console.receiveInputPrompt(line);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("     Prompt set: ", new Object[]{IrbUtil.toLog(line)});
                continue;
            }
            if (ProcessOutputType.isStdout(outputType)) {
                line = console.suppressEcho(line);
            } else if (!outputType.toString().equals(RESET_COLORS_ANSI_CODE)) {
                contentToPrint.append(line, outputType);
                continue;
            }
            while ((codeTokenMatcher = CODE_TOKEN_PATTERN.matcher(line)).find()) {
                contentToPrint.append(line.substring(0, codeTokenMatcher.start()), ProcessOutputTypes.STDOUT).append(codeTokenMatcher.group(1), NUMBER_KEY).append(codeTokenMatcher.group(2), STRING_KEY).append(codeTokenMatcher.group(3), SYMBOL_KEY);
                line = line.substring(codeTokenMatcher.end());
            }
            contentToPrint.append(line, ProcessOutputTypes.STDOUT);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Will be printed: ", new Object[]{contentToPrint});
        }
        MyConsoleContentBuilder myConsoleContentBuilder = contentToPrint;
        if (myConsoleContentBuilder == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(5);
        }
        return myConsoleContentBuilder;
    }

    @NotNull
    private RubyLanguageConsole getConsole() {
        RubyLanguageConsole rubyLanguageConsole = Objects.requireNonNull(this.myProcessHandler.getConsole());
        if (rubyLanguageConsole == null) {
            RubyConsoleTextProcessor.$$$reportNull$$$0(6);
        }
        return rubyLanguageConsole;
    }

    static {
        ConsoleViewContentType.registerNewConsoleViewType(STRING_KEY, (TextAttributesKey)RubyHighlighter.SIMPLE_STRING);
        ConsoleViewContentType.registerNewConsoleViewType(NUMBER_KEY, (TextAttributesKey)RubyHighlighter.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType(SYMBOL_KEY, (TextAttributesKey)RubyHighlighter.SYMBOL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/RubyConsoleTextProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/RubyConsoleTextProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentToPrint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "textAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContentToPrint";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class MyConsoleContentBuilder
    extends ArrayList<Pair<String, ConsoleViewContentType>> {
        private MyConsoleContentBuilder() {
        }

        @Override
        public String toString() {
            return IrbUtil.toLog(String.join((CharSequence)"", ContainerUtil.map((Collection)this, contentChunk -> (String)contentChunk.first)));
        }

        @NotNull
        private MyConsoleContentBuilder append(@Nullable String text, @NotNull Key<?> outputType) {
            if (outputType == null) {
                MyConsoleContentBuilder.$$$reportNull$$$0(0);
            }
            if (StringUtil.isNotEmpty((String)text)) {
                this.add(Pair.pair((Object)text, (Object)ConsoleViewContentType.getConsoleViewType(outputType)));
            }
            MyConsoleContentBuilder myConsoleContentBuilder = this;
            if (myConsoleContentBuilder == null) {
                MyConsoleContentBuilder.$$$reportNull$$$0(1);
            }
            return myConsoleContentBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/console/RubyConsoleTextProcessor$MyConsoleContentBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/console/RubyConsoleTextProcessor$MyConsoleContentBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

