/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyDataKeys;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/ruby/console/RubyConsoleSessionHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentSession", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentSessionChunk", "sessions", "", "Lcom/intellij/psi/PsiElement;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "appendSessionChunk", "", "text", "clearSession", "clearSessions", "commitSessionChunk", "getFile", "setContext", "context", "intellij.ruby.backend"})
public final class RubyConsoleSessionHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final StringBuilder currentSession;
    @NotNull
    private final StringBuilder currentSessionChunk;
    @NotNull
    private final Map<PsiElement, String> sessions;
    @Nullable
    private PsiFile psiFile;

    public RubyConsoleSessionHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.virtualFile = (VirtualFile)new LightVirtualFile("Ruby Console Context", (Language)RubyLanguage.INSTANCE, (CharSequence)"");
        this.currentSession = new StringBuilder();
        this.currentSessionChunk = new StringBuilder();
        this.sessions = new HashMap();
    }

    public final void appendSessionChunk(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        this.currentSessionChunk.append(text);
        Document document = (Document)ReadAction.compute(() -> RubyConsoleSessionHelper.appendSessionChunk$lambda$0(this));
        if (document == null) {
            return;
        }
        Document document2 = document;
        ApplicationManager.getApplication().invokeLater(() -> RubyConsoleSessionHelper.appendSessionChunk$lambda$1(document2, this));
    }

    public final void clearSession() {
        Document document = (Document)ReadAction.compute(() -> RubyConsoleSessionHelper.clearSession$lambda$0(this));
        if (document != null) {
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.isBlank((CharSequence)string)) {
                ApplicationManager.getApplication().invokeLater(() -> RubyConsoleSessionHelper.clearSession$lambda$1(document));
            }
        }
        this.currentSession.delete(0, this.currentSession.length());
        this.currentSessionChunk.delete(0, this.currentSessionChunk.length());
    }

    public final void clearSessions() {
        this.clearSession();
        this.sessions.clear();
    }

    public final void commitSessionChunk() {
        if (((CharSequence)this.currentSessionChunk).length() == 0) {
            return;
        }
        ReadAction.run(() -> RubyConsoleSessionHelper.commitSessionChunk$lambda$0(this));
        this.currentSessionChunk.delete(0, this.currentSessionChunk.length());
        Document document = (Document)ReadAction.compute(() -> RubyConsoleSessionHelper.commitSessionChunk$lambda$1(this));
        if (document == null) {
            return;
        }
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        if (!string2.contentEquals(this.currentSession)) {
            ApplicationManager.getApplication().invokeLater(() -> RubyConsoleSessionHelper.commitSessionChunk$lambda$2(document2, this));
        }
    }

    @NotNull
    public final PsiFile getFile() {
        block3: {
            block2: {
                if (this.psiFile == null) break block2;
                PsiFile psiFile = this.psiFile;
                Intrinsics.checkNotNull((Object)psiFile);
                if (psiFile.isValid()) break block3;
            }
            this.psiFile = (PsiFile)new RubyExpressionCodeFragmentImpl(this.project, this.virtualFile, true);
        }
        PsiFile psiFile = this.psiFile;
        Intrinsics.checkNotNull((Object)psiFile);
        return psiFile;
    }

    public final void setContext(@Nullable PsiElement context) {
        if (context == null) {
            this.clearSession();
            return;
        }
        PsiElement currentContext = (PsiElement)ReadAction.compute(() -> RubyConsoleSessionHelper.setContext$lambda$0(this));
        if (!Intrinsics.areEqual((Object)context, (Object)currentContext)) {
            this.sessions.put(currentContext, this.currentSession.toString());
            this.currentSession.replace(0, this.currentSession.length(), this.sessions.getOrDefault(context, ""));
            this.currentSessionChunk.delete(0, this.currentSessionChunk.length());
            Document document = (Document)ReadAction.compute(() -> RubyConsoleSessionHelper.setContext$lambda$1(this));
            if (document != null) {
                ApplicationManager.getApplication().invokeLater(() -> RubyConsoleSessionHelper.setContext$lambda$2(document, this));
            }
        }
        ReadAction.run(() -> RubyConsoleSessionHelper.setContext$lambda$3(this, context));
    }

    private static final Document appendSessionChunk$lambda$0(RubyConsoleSessionHelper this$0) {
        return FileDocumentManager.getInstance().getDocument(this$0.virtualFile, this$0.project);
    }

    private static final void appendSessionChunk$lambda$1(Document $document, RubyConsoleSessionHelper this$0) {
        WriteAction.run(() -> RubyConsoleSessionHelper.appendSessionChunk$lambda$1$0($document, this$0));
    }

    private static final void appendSessionChunk$lambda$1$0(Document $document, RubyConsoleSessionHelper this$0) {
        $document.setText((CharSequence)(this$0.currentSession.toString() + this$0.currentSessionChunk));
    }

    private static final Document clearSession$lambda$0(RubyConsoleSessionHelper this$0) {
        return FileDocumentManager.getInstance().getDocument(this$0.virtualFile, this$0.project);
    }

    private static final void clearSession$lambda$1(Document $document) {
        WriteAction.run(() -> RubyConsoleSessionHelper.clearSession$lambda$1$0($document));
    }

    private static final void clearSession$lambda$1$0(Document $document) {
        $document.setText((CharSequence)"");
    }

    private static final void commitSessionChunk$lambda$0(RubyConsoleSessionHelper this$0) {
        RFile file = RubyElementFactoryCore.createRubyFile((Project)this$0.project, (String)this$0.currentSessionChunk.toString());
        if (file != null && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)file))) {
            this$0.currentSession.append((CharSequence)this$0.currentSessionChunk).append("# ---\n");
        }
    }

    private static final Document commitSessionChunk$lambda$1(RubyConsoleSessionHelper this$0) {
        return FileDocumentManager.getInstance().getDocument(this$0.virtualFile, this$0.project);
    }

    private static final void commitSessionChunk$lambda$2(Document $document, RubyConsoleSessionHelper this$0) {
        WriteAction.run(() -> RubyConsoleSessionHelper.commitSessionChunk$lambda$2$0($document, this$0));
    }

    private static final void commitSessionChunk$lambda$2$0(Document $document, RubyConsoleSessionHelper this$0) {
        $document.setText((CharSequence)this$0.currentSession);
    }

    private static final PsiElement setContext$lambda$0(RubyConsoleSessionHelper this$0) {
        return RubyLanguageConsoleUtil.getLanguageConsoleContext((PsiElement)((PsiElement)this$0.getFile()));
    }

    private static final Document setContext$lambda$1(RubyConsoleSessionHelper this$0) {
        return FileDocumentManager.getInstance().getDocument(this$0.virtualFile, this$0.project);
    }

    private static final void setContext$lambda$2(Document $document, RubyConsoleSessionHelper this$0) {
        WriteAction.run(() -> RubyConsoleSessionHelper.setContext$lambda$2$0($document, this$0));
    }

    private static final void setContext$lambda$2$0(Document $document, RubyConsoleSessionHelper this$0) {
        $document.setText((CharSequence)this$0.currentSession);
    }

    private static final void setContext$lambda$3(RubyConsoleSessionHelper this$0, PsiElement $context) {
        this$0.getFile().putCopyableUserData(RubyDataKeys.RUBY_CONSOLE_CONTEXT_KEY, (Object)SmartPointerManager.createPointer((PsiElement)$context));
    }
}

