/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.console.IrbUtil;
import org.jetbrains.plugins.ruby.console.RubyConsoleRootType;
import org.jetbrains.plugins.ruby.console.RubyConsoleSessionHelper;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsole;
import org.jetbrains.plugins.ruby.console.config.IrbConsoleType;
import org.jetbrains.plugins.ruby.console.config.IrbRunConfiguration;
import org.jetbrains.plugins.ruby.console.config.ReloadAction;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyConsoleProcessHandlerEx;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocation;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocationDescriptor;

public final class IrbRubyLanguageConsoleView
extends RubyLanguageConsole {
    private static final Logger LOG = Logger.getInstance(IrbRubyLanguageConsoleView.class);
    @NotNull
    private final ProcessBackedConsoleExecuteActionHandler myExecuteActionHandler;
    @Nullable
    private final Module myModule;
    @NotNull
    private final Sdk mySdk;
    @NotNull
    private final IrbConsoleType myConsoleType;
    @NotNull
    private final StringBuilder myInputBuffer;
    @Nullable
    private ProcessHandler myProcessHandler;
    private boolean myInputPromptReceived;

    public IrbRubyLanguageConsoleView(@NotNull Project project, @NotNull IrbRunConfiguration config) {
        if (project == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(0);
        }
        if (config == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(1);
        }
        super(project, config.getName(), new RubyConsoleSessionHelper(project));
        this.myInputBuffer = new StringBuilder();
        this.myInputPromptReceived = false;
        this.mySdk = Objects.requireNonNull(config.getSdk());
        this.myModule = config.getModule();
        this.myConsoleType = config.getConsoleType();
        this.myExecuteActionHandler = this.createConsoleExecuteActionHandler();
        this.addExecuteAction();
        if (this.myConsoleType == IrbConsoleType.RAILS) {
            this.addReloadAction();
        }
        RubyLookupUsageLocationDescriptor.markFile(this.getFile(), RubyLookupUsageLocation.fromIrbConsoleType(this.myConsoleType));
        UiNotifyConnector.Once.installOn((Component)((Object)this), (Activatable)new Activatable(){

            public void showNotify() {
                new ConsoleHistoryController((ConsoleRootType)RubyConsoleRootType.getInstance(), "", (LanguageConsoleView)IrbRubyLanguageConsoleView.this).install();
                IdeFocusManager.getInstance((Project)IrbRubyLanguageConsoleView.this.getProject()).requestFocus((Component)IrbRubyLanguageConsoleView.this.getCurrentEditor().getContentComponent(), true);
            }
        });
    }

    @NotNull
    public IrbConsoleType getConsoleType() {
        IrbConsoleType irbConsoleType = this.myConsoleType;
        if (irbConsoleType == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(2);
        }
        return irbConsoleType;
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(3);
        }
        super.attachToProcess(processHandler);
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (IrbRubyLanguageConsoleView.this.getProject().isDisposed()) {
                        return;
                    }
                    IrbRubyLanguageConsoleView.this.setConsoleEditorEnabled(false);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/console/IrbRubyLanguageConsoleView$2", "processTerminated"));
            }
        });
        if (processHandler instanceof RubyConsoleProcessHandlerEx) {
            RubyConsoleProcessHandlerEx handlerEx = (RubyConsoleProcessHandlerEx)processHandler;
            handlerEx.setConsole(this);
        }
        this.myExecuteActionHandler.setProcessHandler(processHandler);
        this.myProcessHandler = processHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(5);
        }
        if (contentType == ConsoleViewContentType.USER_INPUT && text.equals(">>")) {
            StringBuilder stringBuilder = this.myInputBuffer;
            synchronized (stringBuilder) {
                this.myInputBuffer.setLength(0);
            }
        }
        super.print(text, contentType);
    }

    public boolean canPause() {
        return false;
    }

    public boolean isLaunchedFrom(@NotNull Module module) {
        if (module == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(6);
        }
        return module.equals((Object)this.myModule) && this.mySdk.equals((Object)RModuleUtil.getInstance().findRubySdkForModule(module));
    }

    public void loadFileOrExecuteSelection(@NotNull VirtualFile file, @Nullable Editor editor) {
        String input;
        if (file == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmptyOrSpaces((String)(input = (String)ObjectUtils.doIfNotNull((Object)editor, it -> it.getSelectionModel().getSelectedText())))) {
            if (editor != null) {
                FileDocumentManager.getInstance().saveDocument(editor.getDocument());
            }
            input = String.format("load '%s'", RubySdkUtil.convertToRemote(this.mySdk, this.myModule, file.getPath()));
        }
        this.execute(input);
    }

    @TestOnly
    public boolean isInitialized() {
        return this.myInputPromptReceived;
    }

    @TestOnly
    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @TestOnly
    public void executeInConsole(@NotNull String input) {
        if (input == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(8);
        }
        this.execute(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    @NlsSafe
    protected String suppressEcho(@NotNull String text) {
        if (text == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(9);
        }
        StringBuilder stringBuilder = this.myInputBuffer;
        // MONITORENTER : stringBuilder
        String textTrimmed = RubyTextUtil.removeEOL((String)text);
        if (!textTrimmed.isEmpty() && StringUtil.startsWith((CharSequence)this.myInputBuffer, (CharSequence)textTrimmed)) {
            this.myInputBuffer.delete(0, textTrimmed.length());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Input echo suppressed");
                LOG.debug("   Input buffer: " + IrbUtil.toLog(this.myInputBuffer.toString()));
            }
            // MONITOREXIT : stringBuilder
            return "";
        }
        this.myInputBuffer.setLength(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No echo detected, input buffer cleared");
        }
        String string = text;
        // MONITOREXIT : stringBuilder
        if (string != null) return string;
        IrbRubyLanguageConsoleView.$$$reportNull$$$0(11);
        return string;
    }

    @Override
    protected void receiveInputPrompt(@NotNull String prompt) {
        if (prompt == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(12);
        }
        if (!this.myInputPromptReceived) {
            LOG.debug("Console initialization finished");
        }
        this.myInputPromptReceived = true;
        super.receiveInputPrompt(prompt);
    }

    @NotNull
    private ProcessBackedConsoleExecuteActionHandler createConsoleExecuteActionHandler() {
        return new ProcessBackedConsoleExecuteActionHandler(null, false){

            public void processLine(@NotNull String line) {
                if (line == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (IrbRubyLanguageConsoleView.this.myConsoleType == IrbConsoleType.RAILS && "reload!\n".startsWith(line)) {
                    IrbRubyLanguageConsoleView.this.mySessionHelper.clearSessions();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                IrbRubyLanguageConsoleView.this.inputSent(line + "\n");
                super.processLine(line);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/ruby/console/IrbRubyLanguageConsoleView$3", "processLine"));
            }
        };
    }

    private void addExecuteAction() {
        ConsoleExecuteAction executeAction = new ConsoleExecuteAction((LanguageConsoleView)this, (BaseConsoleExecuteActionHandler)this.myExecuteActionHandler);
        this.addCustomConsoleAction((AnAction)executeAction);
        executeAction.registerCustomShortcutSet(executeAction.getShortcutSet(), this.getConsoleEditor().getComponent());
    }

    private void addReloadAction() {
        ReloadAction action = new ReloadAction(this.myExecuteActionHandler);
        this.addCustomConsoleAction(action);
        action.registerAt(this.getConsoleEditor().getComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputSent(@NotNull String text) {
        if (text == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(13);
        }
        StringBuilder stringBuilder = this.myInputBuffer;
        synchronized (stringBuilder) {
            this.myInputBuffer.append(RubyTextUtil.removeEOL((String)text));
            if (LOG.isDebugEnabled()) {
                LOG.debug("     Input sent: ", new Object[]{IrbUtil.toLog(text)});
                LOG.debug("   Input buffer: ", new Object[]{IrbUtil.toLog(this.myInputBuffer.toString())});
            }
        }
        this.setLanguage((Language)RubyLanguage.INSTANCE);
        this.mySessionHelper.appendSessionChunk(text);
    }

    private void execute(@NotNull String input) {
        if (input == null) {
            IrbRubyLanguageConsoleView.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.setInputText(input);
            this.myExecuteActionHandler.runExecuteAction((LanguageConsoleView)this);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/console/IrbRubyLanguageConsoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/console/IrbRubyLanguageConsoleView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressEcho";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLaunchedFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFileOrExecuteSelection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeInConsole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suppressEcho";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "receiveInputPrompt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inputSent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 11 -> new IllegalStateException(string);
        };
    }
}

