/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.command.run;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public class CommandRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final CommandRunConfigurationExternalizer myInstance = new CommandRunConfigurationExternalizer();
    @NonNls
    public static final String COMMAND_CONFIG_SETTINGS_ID = "COMMAND_CONFIG_SETTINGS_ID";
    @NonNls
    public static final String GEM_NAME = "GEM_NAME";
    @NonNls
    public static final String EXECUTABLE_NAME = "EXECUTABLE_NAME";
    @NonNls
    public static final String EXECUTABLE_ARGS = "EXECUTABLE_ARGS";
    @NonNls
    public static final String WORKING_DIR = "WORKING_DIR";

    public static CommandRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return COMMAND_CONFIG_SETTINGS_ID;
    }

    public void readExternal(CommandRunConfiguration config, Element element) {
        Map<String, String> optionsByName = this.buildOptionsByElement(element);
        config.setGemName(optionsByName.get(GEM_NAME));
        config.setExecutableName(optionsByName.get(EXECUTABLE_NAME));
        config.setExecutableArguments(optionsByName.get(EXECUTABLE_ARGS));
        config.setWorkingDirectory(optionsByName.get(WORKING_DIR));
    }

    public void writeExternal(CommandRunConfiguration config, Element element) {
        this.writeOption(GEM_NAME, config.getGemName(), element);
        this.writeOption(EXECUTABLE_NAME, config.getExecutableName(), element);
        this.writeOption(EXECUTABLE_ARGS, config.getExecutableArguments(), element);
        this.writeOption(WORKING_DIR, config.getWorkingDirectory(), element);
    }
}

