/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.command.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.command.run.CommandRunCommandLineState;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfigurationEditor;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfigurationParams;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;

public class CommandRunConfiguration
extends AbstractRubyRunConfiguration<CommandRunConfiguration>
implements CommandRunConfigurationParams {
    public static final String COMMAND_RUN_CONFIGURATION = "COMMAND_RUN_CONFIGURATION";
    private String myGemName = "";
    private String myExecutableName = "";
    private String myExecutableArguments = "";

    protected CommandRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected String getSerializationId() {
        return COMMAND_RUN_CONFIGURATION;
    }

    @Override
    protected SettingsEditor<CommandRunConfiguration> createConfigurationEditor() {
        return new CommandRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    protected void validateConfiguration() throws RuntimeConfigurationException {
        String gemName = this.getGemName();
        String executableName = this.getExecutableName();
        if (gemName == null || gemName.isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"dialog.message.specify.gem.name"));
        }
        if (executableName == null || executableName.isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"dialog.message.specify.gem.executable"));
        }
        String gemExecutable = RubyGemExecutionContext.getScriptPath(this.getSdk(), this.getModule(), gemName, executableName);
        if (gemExecutable == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"dialog.message.gem.executable.can.t.be.found"));
        }
    }

    @Override
    protected RubyAbstractCommandLineState createCommandLineState(@NotNull ExecutionEnvironment env) throws ExecutionException {
        if (env == null) {
            CommandRunConfiguration.$$$reportNull$$$0(0);
        }
        return new CommandRunCommandLineState(this, env);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommandRunConfiguration.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        CommandRunConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommandRunConfiguration.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        CommandRunConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    @Override
    public String getGemName() {
        return this.myGemName;
    }

    @Override
    public void setGemName(String name) {
        this.myGemName = StringUtil.notNullize((String)name);
    }

    @Override
    public String getExecutableName() {
        return this.myExecutableName;
    }

    @Override
    public String getExecutableArguments() {
        return this.myExecutableArguments;
    }

    @Override
    public void setExecutableName(@Nullable String name) {
        this.myExecutableName = StringUtil.notNullize((String)name);
    }

    @Override
    public void setExecutableArguments(@Nullable String args) {
        this.myExecutableArguments = StringUtil.notNullize((String)args);
    }

    public static void copyParams(CommandRunConfigurationParams fromParams, CommandRunConfigurationParams toParams) {
        toParams.setGemName(fromParams.getGemName());
        toParams.setExecutableName(fromParams.getExecutableName());
        toParams.setExecutableArguments(fromParams.getExecutableArguments());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/command/run/CommandRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

