/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.command.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.command.run.CommandRunConfiguration;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class CommandRunCommandLineState
extends RubyAbstractCommandLineState {
    @NonNls
    private static final String GEM_COMMAND_RUNNER_ID = "ruby.gem.command.runner";

    public CommandRunCommandLineState(CommandRunConfiguration config, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            CommandRunCommandLineState.$$$reportNull$$$0(0);
        }
        super(config, environment, false);
    }

    public CommandRunConfiguration getConfig() {
        return (CommandRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        CommandRunConfiguration config = this.getConfig();
        return CommandRunCommandLineState.createCommandLine(config, this.getRunnerId());
    }

    public static RubyCommandLineData createCommandLine(@NotNull CommandRunConfiguration config, String runnerId) throws ExecutionException {
        if (config == null) {
            CommandRunCommandLineState.$$$reportNull$$$0(1);
        }
        RubyCommandLineData data = CommandRunCommandLineState.createDefaultCommandLine(config, runnerId);
        Sdk sdk = config.getSdk();
        assert (sdk != null);
        String gemName = config.getGemName();
        String executableName = config.getExecutableName();
        String execPath = RubyGemExecutionContext.getScriptPath(sdk, config.getModule(), gemName, executableName);
        if (execPath != null) {
            RubyCommandLine commandLine = data.getCommandLine();
            ParamsGroup runnerParamsGroup = CommandRunCommandLineState.addExecutionScriptGroup(GEM_COMMAND_RUNNER_ID, data, commandLine, execPath, sdk, config.getModule());
            String arguments = config.getExecutableArguments();
            if (!arguments.isEmpty()) {
                runnerParamsGroup.addParameters(MergingCommandLineArgumentsProvider.stringToArguments(arguments));
            }
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/command/run/CommandRunCommandLineState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

