/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman.fixes;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.brakeman.BrakemanNotification;
import org.jetbrains.plugins.ruby.brakeman.BrakemanProblemDescriptor;
import org.jetbrains.plugins.ruby.brakeman.Warning;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J=\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH \u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/ruby/brakeman/fixes/BrakemanConfigSaveQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInspection/BatchQuickFix;", "fileDir", "", "fileName", "failedNotificationText", "succeededNotificationText", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "descriptors", "", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "psiElementsToIgnore", "", "Lcom/intellij/psi/PsiElement;", "refreshViews", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/codeInspection/CommonProblemDescriptor;Ljava/util/List;Ljava/lang/Runnable;)V", "saveToFile", "", "updateFile", "fileText", "warning", "Lorg/jetbrains/plugins/ruby/brakeman/Warning;", "updateFile$intellij_ruby_backend", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nBrakemanConfigSaveQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrakemanConfigSaveQuickFix.kt\norg/jetbrains/plugins/ruby/brakeman/fixes/BrakemanConfigSaveQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n12970#2,2:72\n*S KotlinDebug\n*F\n+ 1 BrakemanConfigSaveQuickFix.kt\norg/jetbrains/plugins/ruby/brakeman/fixes/BrakemanConfigSaveQuickFix\n*L\n39#1:72,2\n*E\n"})
public abstract class BrakemanConfigSaveQuickFix
implements LocalQuickFix,
BatchQuickFix {
    @NotNull
    private final String fileDir;
    @NotNull
    private final String fileName;
    @NotNull
    private final String failedNotificationText;
    @NotNull
    private final String succeededNotificationText;

    public BrakemanConfigSaveQuickFix(@NotNull String fileDir, @NotNull String fileName, @NlsContexts.NotificationContent @NotNull String failedNotificationText, @NlsContexts.NotificationContent @NotNull String succeededNotificationText) {
        Intrinsics.checkNotNullParameter((Object)fileDir, (String)"fileDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)failedNotificationText, (String)"failedNotificationText");
        Intrinsics.checkNotNullParameter((Object)succeededNotificationText, (String)"succeededNotificationText");
        this.fileDir = fileDir;
        this.fileName = fileName;
        this.failedNotificationText = failedNotificationText;
        this.succeededNotificationText = succeededNotificationText;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        boolean succeeded = this.saveToFile(project, descriptor);
        if (succeeded) {
            new BrakemanNotification(this.succeededNotificationText, NotificationType.INFORMATION, null, 4, null).show();
        } else {
            new BrakemanNotification(this.failedNotificationText, null, null, 6, null).show();
        }
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        block3: {
            boolean someBuildFailed;
            block2: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
                Intrinsics.checkNotNullParameter(psiElementsToIgnore, (String)"psiElementsToIgnore");
                CommonProblemDescriptor[] $this$any$iv = descriptors;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    CommonProblemDescriptor element$iv;
                    CommonProblemDescriptor it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.codeInspection.ProblemDescriptor");
                    if (!(!this.saveToFile(project, (ProblemDescriptor)it))) continue;
                    bl = true;
                    break block2;
                }
                bl = someBuildFailed = false;
            }
            if (someBuildFailed) {
                new BrakemanNotification(this.failedNotificationText, null, null, 6, null).show();
                return;
            }
            new BrakemanNotification(this.succeededNotificationText, NotificationType.INFORMATION, null, 4, null).show();
            Runnable runnable = refreshViews;
            if (runnable == null) break block3;
            runnable.run();
        }
    }

    private final boolean saveToFile(Project project, ProblemDescriptor descriptor) {
        if (!(descriptor instanceof BrakemanProblemDescriptor)) {
            return false;
        }
        VirtualFile virtualFile = ((BrakemanProblemDescriptor)descriptor).getContainingFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile descriptorFile = virtualFile;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)descriptorFile, (Project)project);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        VirtualFile virtualFile2 = RailsFacetUtil.getRailsAppHomeDir(module2);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile root = virtualFile2;
        VirtualFile virtualFile3 = root.findChild(this.fileDir);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile configDir = virtualFile3;
        VirtualFile virtualFile4 = configDir.findOrCreateChildData((Object)configDir, this.fileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"findOrCreateChildData(...)");
        VirtualFile vFile = virtualFile4;
        String fileText = VirtualFileUtil.readText((VirtualFile)vFile);
        String string = this.updateFile$intellij_ruby_backend(fileText, ((BrakemanProblemDescriptor)descriptor).getWarning());
        if (string == null) {
            return false;
        }
        String newText = string;
        WriteAction.run(() -> BrakemanConfigSaveQuickFix.saveToFile$lambda$0(vFile, newText));
        return true;
    }

    @Nullable
    public abstract String updateFile$intellij_ruby_backend(@NotNull String var1, @NotNull Warning var2);

    private static final void saveToFile$lambda$0(VirtualFile $vFile, String $newText) {
        VirtualFileUtil.writeText((VirtualFile)$vFile, (String)$newText);
    }
}

