/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.brakeman;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.brakeman.ActionInfo;
import org.jetbrains.plugins.ruby.brakeman.BrakemanNotification;
import org.jetbrains.plugins.ruby.brakeman.BrakemanSingleActionNotification;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.bundler.actions.AbstractBundlerAction;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getExecutionContext", "Lorg/jetbrains/plugins/ruby/ruby/run/context/RubyScriptExecutionContext;", "module", "Lcom/intellij/openapi/module/Module;", "executionContextNotFoundNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "modulesWithoutContext", "", "collectProblems", "", "Lorg/jetbrains/plugins/ruby/brakeman/ActionInfo;", "createBundleInstallAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nBrakemanExecutionContextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrakemanExecutionContextUtil.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanExecutionContextUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,106:1\n1869#2,2:107\n1617#2,9:109\n1869#2:118\n1870#2:120\n1626#2:121\n1869#2,2:122\n1#3:119\n13#4:124\n*S KotlinDebug\n*F\n+ 1 BrakemanExecutionContextUtil.kt\norg/jetbrains/plugins/ruby/brakeman/BrakemanExecutionContextUtilKt\n*L\n53#1:107,2\n69#1:109,9\n69#1:118\n69#1:120\n69#1:121\n80#1:122,2\n69#1:119\n22#1:124\n*E\n"})
public final class BrakemanExecutionContextUtilKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final RubyScriptExecutionContext getExecutionContext(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GemInfo brakemanGem = RubyProjectGemSearchService.Companion.findGem(module, "brakeman");
        if (brakemanGem == null || VersionComparatorUtil.compare((String)brakemanGem.getVersion(), (String)"5.0.0") < 0) {
            return null;
        }
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile == null || BundlerGemInfrastructure.hasMissingGems(gemFile)) {
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        String string = RubyUtil.getScriptFullPath("rb/scripts/brakeman_rm_proxy.rb");
        if (string == null) {
            return null;
        }
        String brakemanProxy = string;
        return (RubyScriptExecutionContext)((RubyScriptExecutionContext)RubyScriptExecutionContext.create(brakemanProxy, sdk2).withProject(module.getProject())).withModule(module);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean executionContextNotFoundNotifications(@NotNull Project project, @NotNull Set<? extends Module> modulesWithoutContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modulesWithoutContext, (String)"modulesWithoutContext");
        List<ActionInfo> problems = BrakemanExecutionContextUtilKt.collectProblems(modulesWithoutContext);
        if (RModuleUtil.getInstance().getAllModulesWithRubySupport(project).length == 1) {
            Iterable $this$forEach$iv = problems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ActionInfo actionInfo = (ActionInfo)element$iv;
                boolean bl = false;
                String text = actionInfo.component1();
                AnAction action = actionInfo.component3();
                if (action == null) {
                    new BrakemanNotification(text, null, null, 6, null).show();
                    continue;
                }
                new BrakemanSingleActionNotification(text, action, null, 4, null).show();
            }
            return false;
        }
        if (!((Collection)problems).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            String moduleProblemNotificationText = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)problems), BrakemanExecutionContextUtilKt::executionContextNotFoundNotifications$lambda$1), null, null, null, (int)0, null, BrakemanExecutionContextUtilKt::executionContextNotFoundNotifications$lambda$2, (int)31, null);
            Object[] objectArray = new Object[]{project.getName()};
            String notificationText = RBundle.message((String)"inspection.brakeman.notification.multiModule", (Object[])objectArray) + moduleProblemNotificationText;
            Iterable $this$mapNotNull$iv = problems;
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AnAction it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                ActionInfo actionInfo = (ActionInfo)element$iv$iv;
                boolean bl3 = false;
                AnAction action = actionInfo.component3();
                if (action == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List actions = (List)destination$iv$iv;
            new BrakemanNotification(notificationText, null, actions, 2, null).show();
            return true;
        }
        return false;
    }

    private static final List<ActionInfo> collectProblems(Set<? extends Module> modulesWithoutContext) {
        List problems = new ArrayList();
        Iterable $this$forEach$iv = modulesWithoutContext;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module module = (Module)element$iv;
            boolean bl = false;
            LOG.info("Execution context notification for module " + module);
            VirtualFile gemFile = BundlerUtil.getGemfile(module);
            if (gemFile == null) {
                LOG.debug("Could not find Gemfile");
                continue;
            }
            if (BundlerGemInfrastructure.hasMissingGems(gemFile)) {
                LOG.info("Gemfile has some gems missing / not installed");
                Object[] objectArray = new Object[]{module.getName()};
                String string = RBundle.message((String)"inspection.brakeman.notification.missingGems", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                problems.add(new ActionInfo(string, module, (AnAction)BrakemanExecutionContextUtilKt.createBundleInstallAction(module)));
                continue;
            }
            LOG.debug("Brakeman is not in the Gemfile");
        }
        return problems;
    }

    @NotNull
    public static final DumbAwareAction createBundleInstallAction(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object[] objectArray = new Object[]{module.getName()};
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)RBundle.message((String)"inspection.brakeman.notification.action.runBundleInstall", (Object[])objectArray), arg_0 -> BrakemanExecutionContextUtilKt.createBundleInstallAction$lambda$1(arg_0 -> BrakemanExecutionContextUtilKt.createBundleInstallAction$lambda$0(module, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return dumbAwareAction;
    }

    private static final boolean executionContextNotFoundNotifications$lambda$1(ActionInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAction() == null;
    }

    private static final CharSequence executionContextNotFoundNotifications$lambda$2(ActionInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModule() + ": " + it.getText() + " ";
    }

    private static final Unit createBundleInstallAction$lambda$0(Module $module, AnActionEvent anActionEvent) {
        block0: {
            AbstractBundlerAction action;
            Intrinsics.checkNotNullParameter((Object)anActionEvent, (String)"<unused var>");
            AnAction anAction = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction");
            AbstractBundlerAction abstractBundlerAction = action = anAction instanceof AbstractBundlerAction ? (AbstractBundlerAction)anAction : null;
            if (abstractBundlerAction == null) break block0;
            abstractBundlerAction.runBundlerAction($module);
        }
        return Unit.INSTANCE;
    }

    private static final void createBundleInstallAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BrakemanNotification.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

