/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.associations;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public abstract class Association {
    public abstract AssociationFactory getFactory();

    public abstract String getName();

    public abstract AssociatedItem getItem();

    @NotNull
    public abstract List<AssociatedItem> getResolvedItems();

    @NotNull
    public abstract List<AssociatedItem> getThroughModels();

    @NotNull
    public abstract RCall getRCall();

    @Nullable
    public abstract String getAs();

    public abstract boolean isPolymorphic();

    public boolean isSingular() {
        return this.getFactory().getSingularCallTypes().contains((Object)this.getType());
    }

    public String getClassName() {
        return this.getItem().getRClass().getName();
    }

    public AssociationType getType() {
        return AssociationsUtil.getAssociationType(this.getRCall());
    }

    @NotNull
    protected Set<AssociatedItem> resolveToModels() {
        AssociationFactory factory = this.getFactory();
        Set<AssociatedItem> set = AssociationsUtil.resolveToModels(this.getRCall()).stream().map(factory::createAssociatedItem).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            Association.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/associations/Association", "resolveToModels"));
    }
}

