/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RubyResourcesUtil {
    @Nullable
    public static VirtualFile getResourceFile(@NotNull String relativePath) {
        if (relativePath == null) {
            RubyResourcesUtil.$$$reportNull$$$0(0);
        }
        try {
            InputStream stream = RubyResourcesUtil.class.getResourceAsStream(relativePath);
            if (stream == null) {
                throw new IOException("Resource " + relativePath + " not found");
            }
            String fileText = FileUtil.loadTextAndClose((InputStream)stream);
            String fileName = StringUtil.substringAfterLast((String)relativePath, (String)"/");
            return new LightVirtualFile(StringUtil.notNullize((String)fileName, (String)relativePath), (CharSequence)fileText);
        }
        catch (IOException e) {
            Logger.getInstance(RubyResourcesUtil.class).warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/ruby/RubyResourcesUtil", "getResourceFile"));
    }
}

