/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.psi.PsiElement;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.util.ByteList;

public final class JoniUtil {
    public static Regex regex(String regex) {
        return JoniUtil.regex(regex, 0);
    }

    public static Regex regex(String regex, int option) {
        byte[] regexBytes = regex.getBytes(StandardCharsets.UTF_8);
        return new Regex(regexBytes, 0, regexBytes.length, option, (Encoding)UTF8Encoding.INSTANCE);
    }

    public static Regex regex(RRegexpLiteral key) {
        String content = key.getContent();
        PsiElement ending = key.getLastChild();
        String end = ending != null && ending.getNode().getElementType() == RubyTokenTypes.tREGEXP_END ? ending.getText() : "";
        int options = 0;
        if (end.contains("m")) {
            options |= 4;
        }
        if (end.contains("i")) {
            options |= 1;
        }
        if (end.contains("x")) {
            options |= 2;
        }
        return JoniUtil.regex(content, options);
    }

    private static ByteList byteList(String string) {
        return new ByteList(string.getBytes(StandardCharsets.UTF_8), (Encoding)UTF8Encoding.INSTANCE);
    }

    public static boolean search(Regex pattern, String string) {
        ByteList value = JoniUtil.byteList(string);
        int realSize = value.getRealSize();
        int begin = value.getBegin();
        Matcher matcher = pattern.matcher(value.getUnsafeBytes(), begin, begin + realSize);
        int result = matcher.search(begin, begin + realSize, 0);
        return result >= 0;
    }

    @Nullable
    public static String gsubBang(String string, Regex pattern, String replacement, LanguageLevel languageLevel) {
        return JoniUtil.gsubBang18(string, pattern, replacement);
    }

    @Nullable
    private static String gsubBang18(String string, Regex pattern, String replacement) {
        ByteList value = JoniUtil.byteList(string);
        int begin = value.getBegin();
        int slen = value.getRealSize();
        int range = begin + slen;
        byte[] bytes = value.getUnsafeBytes();
        Matcher matcher = pattern.matcher(bytes, begin, range);
        int beg = matcher.search(begin, range, 0);
        if (beg < 0) {
            return null;
        }
        int blen = slen + 30;
        ByteList dest = new ByteList(blen);
        dest.setRealSize(blen);
        int offset = 0;
        int buf = 0;
        int bp = 0;
        int cp = begin;
        while (beg >= 0) {
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            String val = JoniUtil.regsub(replacement, string, matcher, (Encoding)UTF8Encoding.INSTANCE);
            ByteList vbuf = JoniUtil.byteList(val);
            int len = bp - buf + (beg - offset) + vbuf.getRealSize() + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.setRealSize(blen);
                bp = buf + len;
            }
            len = beg - offset;
            System.arraycopy(bytes, cp, dest.getUnsafeBytes(), bp, len);
            System.arraycopy(vbuf.getUnsafeBytes(), vbuf.getBegin(), dest.getUnsafeBytes(), bp += len, vbuf.getRealSize());
            bp += vbuf.getRealSize();
            offset = endz;
            if (begz == endz) {
                if (slen <= endz) break;
                len = UTF8Encoding.INSTANCE.length(bytes, begin + endz, range);
                System.arraycopy(bytes, begin + endz, dest.getUnsafeBytes(), bp, len);
                bp += len;
                offset = endz + len;
            }
            cp = begin + offset;
            if (offset > slen) break;
            beg = matcher.search(cp, range, 0);
        }
        if (slen > offset) {
            int len = bp - buf;
            if (blen - len < slen - offset) {
                blen = len + slen - offset;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(bytes, cp, dest.getUnsafeBytes(), bp, slen - offset);
            bp += slen - offset;
        }
        dest.setRealSize(bp - buf);
        return dest.toString();
    }

    private static String regsub(String str, String src, Matcher matcher, Encoding enc) {
        int p;
        Region regs = matcher.getRegion();
        int no = -1;
        ByteList bs = JoniUtil.byteList(str);
        int s = p = bs.getBegin();
        int end = p + bs.getRealSize();
        byte[] bytes = bs.getUnsafeBytes();
        ByteList srcbs = JoniUtil.byteList(src);
        ByteList val = null;
        block8: while (s < end) {
            int l;
            int ss = s;
            int c = bytes[s] & 0xFF;
            if ((l = enc.length(bytes, s++, end)) != 1) {
                s += l - 1;
                continue;
            }
            if (c != 92 || s == end) continue;
            if (val == null) {
                val = new ByteList(ss - p);
            }
            val.append(bytes, p, ss - p);
            c = bytes[s++] & 0xFF;
            p = s;
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    no = c - 48;
                    break;
                }
                case 38: {
                    no = 0;
                    break;
                }
                case 96: {
                    val.append(srcbs.getUnsafeBytes(), srcbs.getBegin(), matcher.getBegin());
                    continue block8;
                }
                case 39: {
                    val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getEnd(), srcbs.getRealSize() - matcher.getEnd());
                    continue block8;
                }
                case 43: {
                    if (regs == null) {
                        if (matcher.getBegin() != -1) break;
                        no = 0;
                        continue block8;
                    }
                    for (no = regs.getNumRegs() - 1; regs.getBeg(no) == -1 && no > 0; --no) {
                    }
                    if (no != 0) break;
                    continue block8;
                }
                case 92: {
                    val.append(bytes, s - 1, 1);
                    continue block8;
                }
                default: {
                    val.append(bytes, s - 2, 2);
                    continue block8;
                }
            }
            if (regs != null) {
                if (no >= regs.getNumRegs() || regs.getBeg(no) == -1) continue;
                val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + regs.getBeg(no), regs.getEnd(no) - regs.getBeg(no));
                continue;
            }
            if (no != 0 || matcher.getBegin() == -1) continue;
            val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
        }
        if (p < end) {
            if (val == null) {
                return bs.makeShared(p - bs.getBegin(), end - p).toString();
            }
            val.append(bytes, p, end - p);
        }
        if (val == null) {
            return str;
        }
        return val.toString();
    }
}

