/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.run;

import com.intellij.docker.remote.ruby.run.RubyDockerComposeCommandType;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;

public final class RubyDockerRunConfigurationSettings {
    private static final Logger LOG = Logger.getInstance(RubyDockerRunConfigurationSettings.class);
    private static final String DOCKER_COMPOSE_COMMAND_ATTRIBUTE = "dockerComposeCommand";
    public static final Key<RubyDockerRunConfigurationSettings> DOCKER_SETTINGS_KEY = new Key("dockerComposeCommand");
    @NotNull
    private final RubyDockerComposeCommandType myDockerComposeCommandType;

    private RubyDockerRunConfigurationSettings(@NotNull RubyDockerComposeCommandType dockerComposeCommandType) {
        if (dockerComposeCommandType == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(0);
        }
        this.myDockerComposeCommandType = dockerComposeCommandType;
    }

    @NotNull
    public RubyDockerComposeCommandType getDockerComposeCommandType() {
        RubyDockerComposeCommandType rubyDockerComposeCommandType = this.myDockerComposeCommandType;
        if (rubyDockerComposeCommandType == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(1);
        }
        return rubyDockerComposeCommandType;
    }

    @NotNull
    public static RubyDockerRunConfigurationSettings getFrom(@NotNull AbstractRubyRunConfiguration<?> configuration) {
        RubyDockerRunConfigurationSettings data;
        if (configuration == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(2);
        }
        return (data = (RubyDockerRunConfigurationSettings)configuration.getCopyableUserData(DOCKER_SETTINGS_KEY)) != null ? data : RubyDockerRunConfigurationSettings.createSettings(RubyDockerRunConfigurationSettings.getDefaultDockerComposeCommandType(configuration));
    }

    public static void putTo(AbstractRubyRunConfiguration<?> configuration, RubyDockerRunConfigurationSettings settings) {
        configuration.putCopyableUserData(DOCKER_SETTINGS_KEY, (Object)settings);
    }

    @NotNull
    public static RubyDockerRunConfigurationSettings createSettings(@NotNull RubyDockerComposeCommandType dockerComposeCommand) {
        if (dockerComposeCommand == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(3);
        }
        return new RubyDockerRunConfigurationSettings(dockerComposeCommand);
    }

    @NotNull
    public static RubyDockerRunConfigurationSettings readExternal(@NotNull Element element, @NotNull AbstractRubyRunConfiguration<?> runConfiguration) {
        String value;
        if (element == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(4);
        }
        if (runConfiguration == null) {
            RubyDockerRunConfigurationSettings.$$$reportNull$$$0(5);
        }
        RubyDockerComposeCommandType dockerComposeCommand = (value = element.getAttributeValue(DOCKER_COMPOSE_COMMAND_ATTRIBUTE)) == null ? RubyDockerRunConfigurationSettings.getDefaultDockerComposeCommandType(runConfiguration) : RubyDockerComposeCommandType.valueOf(value);
        return RubyDockerRunConfigurationSettings.createSettings(dockerComposeCommand);
    }

    public void writeExternal(Element element) {
        element.setAttribute(DOCKER_COMPOSE_COMMAND_ATTRIBUTE, String.valueOf((Object)this.getDockerComposeCommandType()));
    }

    private static RubyDockerComposeCommandType getDefaultDockerComposeCommandType(@Nullable AbstractRunConfiguration runConfiguration) {
        String defaultCommand = runConfiguration instanceof RailsServerRunConfiguration ? Registry.get((String)"ruby.docker.compose.rails.command.by.default").asString() : Registry.get((String)"ruby.docker.compose.command.by.default").asString();
        if (StringUtil.equals((CharSequence)defaultCommand, (CharSequence)"exec")) {
            return RubyDockerComposeCommandType.EXEC;
        }
        if (StringUtil.equals((CharSequence)defaultCommand, (CharSequence)"run")) {
            return RubyDockerComposeCommandType.RUN;
        }
        if (StringUtil.equals((CharSequence)defaultCommand, (CharSequence)"up")) {
            return RubyDockerComposeCommandType.UP;
        }
        LOG.error("Incorrect 'ruby.docker.compose.command.by.default' value: " + defaultCommand + ". Using 'up'");
        return RubyDockerComposeCommandType.RUN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeCommandType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/run/RubyDockerRunConfigurationSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = DOCKER_COMPOSE_COMMAND_ATTRIBUTE;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/run/RubyDockerRunConfigurationSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCommandType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

