/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.run;

import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.docker.remote.ruby.run.RubyDockerRunConfigurationSettings;
import com.intellij.docker.remote.ruby.run.RubyDockerSettingsEditor;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;

public final class RubyDockerRunConfigurationExtension
extends RubyRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(RubyDockerRunConfigurationExtension.class);
    public static final String SERIALIZATION_ID = "RubyDockerContainerSettingsRunConfigurationExtension";
    public static final Key<String> BEFORE_TASK_KEY = new Key("beforeTask");

    @NotNull
    protected String getSerializationId() {
        return SERIALIZATION_ID;
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        DockerContainerSettings value = (DockerContainerSettings)XmlSerializer.deserialize((Element)element, DockerContainerSettings.class);
        DockerContainerSettings.upgradeSettings((Project)runConfiguration.getProject(), (DockerContainerSettings)value);
        RubyDockerRunConfigurationSettings.putTo(runConfiguration, RubyDockerRunConfigurationSettings.readExternal(element, runConfiguration));
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration<?> runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        RubyDockerRunConfigurationSettings settings = RubyDockerRunConfigurationSettings.getFrom(runConfiguration);
        settings.writeExternal(element);
    }

    @Nullable
    protected String getEditorTitle() {
        return RubyDockerBundle.message("ruby.docker.run.configuration.settings.pane.title", new Object[0]);
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration<?> applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        return this.isApplicableFor(applicableConfiguration);
    }

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        return RubyDockerComposeUtil.isRubyDockerComposeSDK(configuration.getSdk());
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws RemoteSdkException {
        if (configuration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (cmdLine == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (runnerId == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        cmdLine.putUserData(RubyDockerRunConfigurationSettings.DOCKER_SETTINGS_KEY, (Object)RubyDockerRunConfigurationSettings.getFrom(configuration));
        try {
            Sdk sdk = configuration.getSdk();
            RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.from((Sdk)sdk);
            assert (sdkAdditionalData instanceof RubyRemoteSdkAdditionalData);
            cmdLine.putUserData(RubyDockerComposeProcessUtil.DOCKER_COMPOSE_EXECUTION_DATA_KEY, (Object)RubyDockerComposeProcessUtil.buildExecutionData((RubyCommandLine)cmdLine, configuration, configuration.getModule(), (RubyRemoteSdkAdditionalData)sdkAdditionalData));
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            LOG.warn(e);
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (configuration instanceof RailsServerRunConfiguration) {
            cmdLine.putUserData(BEFORE_TASK_KEY, (Object)"rm -f tmp/pids/server.pid");
        }
    }

    @Nullable
    protected <P extends AbstractRubyRunConfiguration<?>> SettingsEditor<P> createEditor(@NotNull P configuration) {
        if (configuration == null) {
            RubyDockerRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        return new RubyDockerSettingsEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/ruby/run/RubyDockerRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

