/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RunBundlerInstallQuickFix;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;

public class RubyDockerRebuildQuickfix
extends RunBundlerInstallQuickFix {
    private static final Logger LOG = Logger.getInstance(RubyDockerRebuildQuickfix.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final List<String> myCommands;
    @NotNull
    @IntentionName
    private final String myName;

    public RubyDockerRebuildQuickfix(@NotNull Module module, @NotNull @IntentionName String name, @NotNull List<String> commands) {
        if (module == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(1);
        }
        if (commands == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(2);
        }
        super(module);
        this.myModule = module;
        this.myName = name;
        this.myCommands = commands;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        if (project == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(4);
        }
        if (problemDescriptor == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(5);
        }
        this.runCommand(project);
    }

    protected void runCommand(@NotNull Project project) {
        if (project == null) {
            RubyDockerRebuildQuickfix.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(this.myCommands);
        commandLine.setWorkDirectory(project.getBasePath());
        OSProcessHandler processHandler = null;
        try {
            processHandler = new OSProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        if (processHandler == null) {
            return;
        }
        RunContentExecutor contentExecutor = new RunContentExecutor(project, (ProcessHandler)processHandler).withTitle(RubyDockerBundle.message("ruby.sdk.bundle.install.quick.display.name", new Object[0])).withAfterCompletion(() -> {
            Sdk sdk = ModuleRootManager.getInstance((Module)this.myModule).getSdk();
            if (sdk != null) {
                RubyRemoteInterpreterManager manager = RubyRemoteInterpreterManager.getInstance();
                manager.updateGemsCopy(sdk, this.myModule, true);
            }
        });
        processHandler.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_REMOTE_CLIENTS, (Object)true);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed()) {
                contentExecutor.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerRebuildQuickfix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerRebuildQuickfix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

