/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.docker.remote.ruby.RubyDockerUtil;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;

public final class RubyDockerComposeUtil {
    public static boolean isRubyDockerComposeSDK(@Nullable Sdk sdk) {
        if (sdk != null) {
            SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
            return RubyDockerComposeUtil.isRubyDockerComposeSdkAdditionalData(sdkAdditionalData);
        }
        return false;
    }

    public static boolean isRubyDockerComposeSdkAdditionalData(@Nullable SdkAdditionalData sdkAdditionalData) {
        return RubyDockerUtil.matchesSdkAdditionalDataCredentialType(sdkAdditionalData, DockerComposeCredentialsType.class);
    }

    @Nullable
    public static DockerComposeCredentialsHolder getDockerComposeCredentialsHolder(@NotNull Sdk sdk) {
        SdkAdditionalData sdkAdditionalData;
        if (sdk == null) {
            RubyDockerComposeUtil.$$$reportNull$$$0(0);
        }
        if (!((sdkAdditionalData = sdk.getSdkAdditionalData()) instanceof RubyRemoteSdkAdditionalData)) {
            return null;
        }
        RubyRemoteSdkAdditionalData sdkAdditionalData2 = (RubyRemoteSdkAdditionalData)sdkAdditionalData;
        RemoteConnectionCredentialsWrapper credentialsWrapper = sdkAdditionalData2.connectionCredentials();
        return (DockerComposeCredentialsHolder)credentialsWrapper.getCredentials();
    }

    @NotNull
    public static List<String> buildDockerComposeCommandPrefix(@NotNull DockerComposeCredentialsHolder dockerComposeCredentialsHolder, String ... arguments) {
        if (dockerComposeCredentialsHolder == null) {
            RubyDockerComposeUtil.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            RubyDockerComposeUtil.$$$reportNull$$$0(2);
        }
        ArrayList<String> dockerComposePsArguments = new ArrayList<String>();
        GeneralCommandLine cmd = DockerComposeCliUtil.createDockerComposeCommandlineBlocking((DockerCloudConfiguration)DockerUtils.getDockerCloudConfiguration((String)dockerComposeCredentialsHolder.getAccountName()));
        dockerComposePsArguments.add(cmd.getExePath());
        dockerComposePsArguments.addAll(cmd.getParametersList().getParameters());
        for (String dockerComposeFilePath : dockerComposeCredentialsHolder.getComposeFilePaths()) {
            dockerComposePsArguments.add("-f");
            dockerComposePsArguments.add(dockerComposeFilePath);
        }
        Collections.addAll(dockerComposePsArguments, arguments);
        ArrayList<String> arrayList = dockerComposePsArguments;
        if (arrayList == null) {
            RubyDockerComposeUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeCredentialsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeCommandPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCredentialsHolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeCommandPrefix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

