/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.ruby.RubyDockerBaseSdkConfigurator;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeRemoteTransfer;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeRunner;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerInstallAndRebuildQuickfix;
import com.intellij.docker.remote.ruby.compose.RubyDockerRebuildQuickfix;
import com.intellij.docker.remote.ruby.settings.RubyDockerSettings;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Key;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;

final class RubyDockerComposeSdkConfigurator
extends RubyDockerBaseSdkConfigurator {
    private static final Logger LOG = Logger.getInstance(RubyDockerComposeRunner.class);

    RubyDockerComposeSdkConfigurator() {
    }

    public boolean supports(@NotNull SdkAdditionalData sdkAdditionalData) {
        if (sdkAdditionalData == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(0);
        }
        return RubyDockerComposeUtil.isRubyDockerComposeSdkAdditionalData(sdkAdditionalData);
    }

    @NotNull
    public RubyAbstractRunner buildRunner(@NotNull RubySdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(1);
        }
        return new RubyDockerComposeRunner((RubyRemoteSdkAdditionalData)data, module);
    }

    @NotNull
    public RubySdkTransfer buildSdkTransfer(@Nullable Project project, @NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(2);
        }
        return new RubyDockerComposeRemoteTransfer(project, RubyRemoteSdkAdditionalData.notNullFrom((Sdk)sdk));
    }

    @NotNull
    public List<LocalQuickFix> getBundleInstallQuickFixes(@NotNull Sdk sdk, @NotNull Module module) {
        if (sdk == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(4);
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>(super.getBundleInstallQuickFixes(sdk, module));
        DockerComposeCredentialsHolder dockerComposeCredentialsHolder = RubyDockerComposeUtil.getDockerComposeCredentialsHolder(sdk);
        if (dockerComposeCredentialsHolder == null) {
            ArrayList<LocalQuickFix> arrayList = result;
            if (arrayList == null) {
                RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        String title = RubyDockerBundle.message("ruby.docker.compose.sdk.bundle.install.quick.fix.title", new Object[0]);
        List<String> dockerComposePsArguments = RubyDockerComposeUtil.buildDockerComposeCommandPrefix(dockerComposeCredentialsHolder, "up", "--detach", "--build");
        result.add((LocalQuickFix)new RubyDockerRebuildQuickfix(module, title, dockerComposePsArguments));
        if (RubyDockerSettings.isStatefulExecution()) {
            String bundleInstallPlusDockerComposeRebuildTitle = RubyDockerBundle.message("ruby.sdk.bundle.install.and.docker.build.quick.display.name", new Object[0]);
            List<String> commandLine = RubyDockerComposeUtil.buildDockerComposeCommandPrefix(dockerComposeCredentialsHolder, "build");
            result.add((LocalQuickFix)new RubyDockerInstallAndRebuildQuickfix(module, bundleInstallPlusDockerComposeRebuildTitle, commandLine));
        }
        ArrayList<LocalQuickFix> arrayList = result;
        if (arrayList == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void doCheckSdkAdditionalData(@NotNull RubySdkAdditionalData sdkAdditionalData) {
        ProgressIndicator indicator;
        if (sdkAdditionalData == null) {
            RubyDockerComposeSdkConfigurator.$$$reportNull$$$0(7);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            return;
        }
        String textBefore = indicator.getText();
        String text2Before = indicator.getText2();
        indicator.setText(RubyDockerBundle.message("ruby.docker.compose.sdk.precheck.message", new Object[0]));
        RubyCommandLine cmdLine = new RubyCommandLine((RubyRunner)this.buildRunner(sdkAdditionalData, null), false);
        cmdLine.setExePath("echo");
        cmdLine.addParameter("''");
        try {
            KillableColoredProcessHandler processHandler = (KillableColoredProcessHandler)RubyDockerComposeProcessUtil.startDockerComposeProcess(cmdLine, (AbstractPathMapper)new PathMappingSettings());
            processHandler.startNotify();
            processHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    indicator.setText2(event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeSdkConfigurator$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            while (!processHandler.isProcessTerminated() && !processHandler.waitFor(200L)) {
                if (!indicator.isCanceled()) continue;
                processHandler.killProcess();
                break;
            }
        }
        catch (RemoteSdkException e) {
            LOG.warn("Problem during checking docker environment", (Throwable)e);
        }
        indicator.setText(textBefore);
        indicator.setText(text2Before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeSdkConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeSdkConfigurator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleInstallQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildRunner";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkTransfer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBundleInstallQuickFixes";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCheckSdkAdditionalData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

