/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.docker.remote.DockerComposeConfigMappingCollector;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RubyDockerComposeMappingsProvider
extends PathMappingProvider {
    private static final Logger LOG = Logger.getInstance(RubyDockerComposeMappingsProvider.class);

    RubyDockerComposeMappingsProvider() {
    }

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            RubyDockerComposeMappingsProvider.$$$reportNull$$$0(0);
        }
        return "docker-compose";
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return RubyDockerComposeUtil.isRubyDockerComposeSdkAdditionalData((SdkAdditionalData)data);
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            RubyDockerComposeMappingsProvider.$$$reportNull$$$0(1);
        }
        if (data == null) {
            RubyDockerComposeMappingsProvider.$$$reportNull$$$0(2);
        }
        PathMappingSettings mappings = new PathMappingSettings();
        RemoteConnectionCredentialsWrapper credentialsWrapper = data.connectionCredentials();
        DockerComposeCredentialsHolder docker = (DockerComposeCredentialsHolder)credentialsWrapper.getCredentials();
        if (docker == null || StringUtil.isEmpty((String)docker.getComposeServiceName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning empty mappings. Project: ", new Object[]{project, "; sdkData: ", data, "; docker: ", docker, "; service name: ", docker == null ? null : docker.getComposeServiceName()});
            }
            PathMappingSettings pathMappingSettings = mappings;
            if (pathMappingSettings == null) {
                RubyDockerComposeMappingsProvider.$$$reportNull$$$0(3);
            }
            return pathMappingSettings;
        }
        List composeFilesPath = docker.getComposeFilePaths();
        if (!composeFilesPath.isEmpty()) {
            DockerComposeConfigMappingCollector collector = new DockerComposeConfigMappingCollector((String)composeFilesPath.get(0));
            mappings.addAll(collector.collect(DockerUtils.getDockerCloudConfiguration((String)docker.getAccountName()), docker.getComposeServiceName(), composeFilesPath));
        }
        LOG.debug("Collected mappings for project: ", new Object[]{project, "; sdkData: ", data, "; mappings: ", mappings});
        PathMappingSettings pathMappingSettings = mappings;
        if (pathMappingSettings == null) {
            RubyDockerComposeMappingsProvider.$$$reportNull$$$0(4);
        }
        return pathMappingSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeMappingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeMappingsProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviderPresentableName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingSettings";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

