/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.github.dockerjava.api.command.InspectVolumeResponse;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.remote.compose.DockerComposeServiceUtil;
import com.intellij.docker.remote.ruby.RubyDockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessConnectionData;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;

public final class RubyDockerVolumeUtil {
    private static final Logger LOG = Logger.getInstance(RubyDockerVolumeUtil.class);
    private static final String ROOT_USER = "root";
    private static final String ROOT_UID = "0";
    private static final Pattern VOLUME_IS_IN_USE_ERROR_REGEX = Pattern.compile(".*volume is in use - \\[(.+)]");
    public static final String RUBYMINE_GEMS_VOLUME_DIRECTORY = "/opt/.rubymine_gems";
    public static final String USE_PROPRIETARY_DEBASE_DEBUGGER_IN_DOCKER = "ruby.docker.use.proprietary.debase.debugger";

    private RubyDockerVolumeUtil() {
    }

    @Nullable
    public static String computeRubyMineGemsVolumeName(@Nullable RubyRemoteSdkAdditionalData sdkAdditionalData) {
        if (!RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return null;
        }
        if (!RubyDockerUtil.isRubyDockerSdkAdditionalData((SdkAdditionalData)sdkAdditionalData) && !RubyDockerComposeUtil.isRubyDockerComposeSdkAdditionalData((SdkAdditionalData)sdkAdditionalData)) {
            LOG.debug("Cannot compute RM gems volume name for non-docker sdk: ", new Object[]{sdkAdditionalData});
            return null;
        }
        return "%s_%s_internal_gems_storage_%s_%.30s".formatted(ApplicationNamesInfo.getInstance().getLowercaseProductName(), ApplicationInfo.getInstance().getMajorVersion(), Integer.toHexString(sdkAdditionalData.getSdkId().hashCode()), sdkAdditionalData.getConnectionCredentialId().replaceAll("\\W", ""));
    }

    public static boolean isUsingProprietaryDebaseDebuggerInDocker() {
        return Registry.is((String)USE_PROPRIETARY_DEBASE_DEBUGGER_IN_DOCKER);
    }

    public static void setupDockerComposeVolume(@NotNull String volumeName, @NotNull String mountPath, @Nullable Project project, @NotNull Map<String, String> env, @NotNull RubyDockerComposeProcessConnectionData data) throws RemoteSdkException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(0);
        }
        if (mountPath == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(1);
        }
        if (env == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(2);
        }
        if (data == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(3);
        }
        LOG.debug("Setting up volume: volumeName=", new Object[]{volumeName, ", mountPath=", mountPath, ", project=", project, ", env=", env, ", data=", data});
        try {
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(data.getAccount(), project);
            List composeFilePaths = ContainerUtil.map(data.getComposeFilePaths(), x$0 -> Path.of(x$0, new String[0]));
            String serviceName = data.getComposeServiceName();
            String uid = DockerComposeServiceUtil.getServiceUID((RemoteDockerRuntime)dockerRuntime, (List)composeFilePaths, env, (String)serviceName, null);
            if (!RubyDockerVolumeUtil.isUnderprivilegedUser(uid)) {
                LOG.debug("User for image is default (root), so skipping setup: ", new Object[]{volumeName});
                return;
            }
            DockerComposeServiceUtil.changeOwnershipOfVolume((RemoteDockerRuntime)dockerRuntime, (List)composeFilePaths, env, (String)serviceName, (String)uid, (String)volumeName, (String)mountPath, null);
            LOG.info("Volume setup is complete: " + volumeName);
        }
        catch (ExecutionException | IOException e) {
            LOG.warn("Failed to setup volume: " + volumeName);
            throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.setup.failed", volumeName), e);
        }
    }

    public static void setupDockerVolume(@NotNull String volumeName, @NotNull String mountPath, @Nullable Project project, @NotNull RubyDockerProcessConnectionData data) throws RemoteSdkException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(4);
        }
        if (mountPath == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(5);
        }
        if (data == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(6);
        }
        LOG.debug("Setting up volume: volumeName=", new Object[]{volumeName, ", mountPath=", mountPath, ", project=", project, ", data=", data});
        try {
            String user;
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(data.getAccount(), project);
            if (RubyDockerVolumeUtil.isVolumeAlreadyExists(volumeName, dockerRuntime)) {
                LOG.debug("Volume with the given name already exists, so skipping setup: ", new Object[]{volumeName});
                return;
            }
            DockerAgentImage image = dockerRuntime.findImageByNameOrId(data.getImage());
            String string = user = image != null ? image.getUser() : null;
            if (!RubyDockerVolumeUtil.isUnderprivilegedUser(user)) {
                LOG.debug("User for image is default (root), so skipping setup: ", new Object[]{volumeName});
                return;
            }
            RubyDockerVolumeUtil.changeDockerVolumeOwnership(dockerRuntime, volumeName, mountPath, user, data);
            LOG.info("Volume setup is complete: " + volumeName);
        }
        catch (ServerRuntimeException e) {
            LOG.warn("Failed to setup volume '%s': %s".formatted(volumeName, e.getMessage()));
            throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.setup.failed", volumeName), (Throwable)e);
        }
    }

    @RequiresBackgroundThread
    public static boolean removeDockerComposeVolumes(@NotNull String volumeNameSuffix, @Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, boolean isForce) throws RemoteSdkException {
        if (volumeNameSuffix == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(7);
        }
        if (data == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertBackgroundThread();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        LOG.debug("Removing volumes: volumeNameSuffix=", new Object[]{volumeNameSuffix, ", project=", project, ", data=", data, "isForce=", isForce});
        try {
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(data.getAccount(), project);
            List volumeNames = (List)RemoteDockerRuntimeUtil.executeAgentTask(() -> Arrays.stream(dockerRuntime.getVolumes()).map(DockerAgentVolume::getVolume).map(InspectVolumeResponse::getName).filter(name -> name.endsWith(volumeNameSuffix)).toList());
            boolean result = true;
            for (String volumeName : volumeNames) {
                result &= RubyDockerVolumeUtil.removeVolume(volumeName, dockerRuntime, isForce);
            }
            return result;
        }
        catch (ServerRuntimeException e) {
            LOG.warn("Failed to remove volumes with suffix '%s': %s".formatted(volumeNameSuffix, e.getMessage()));
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    @RequiresBackgroundThread
    public static boolean removeDockerVolume(@NotNull String volumeName, @Nullable Project project, @NotNull RubyDockerProcessConnectionData data, boolean isForce) throws RemoteSdkException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(9);
        }
        if (data == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertBackgroundThread();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        LOG.debug("Removing volume: volumeName=", new Object[]{volumeName, ", project=", project, ", data=", data, "isForce=", isForce});
        if (StringUtil.isEmptyOrSpaces((String)data.getDockerAccountName())) {
            LOG.debug("Can't remove a docker volume '", new Object[]{volumeName, "', because account name is missing"});
            return false;
        }
        RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(data.getAccount(), project);
        return RubyDockerVolumeUtil.removeVolume(volumeName, dockerRuntime, isForce);
    }

    private static boolean removeVolume(@NotNull String volumeName, @NotNull RemoteDockerRuntime dockerRuntime, boolean isForce) throws RemoteSdkException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(11);
        }
        if (dockerRuntime == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(12);
        }
        try {
            return (Boolean)RemoteDockerRuntimeUtil.executeAgentTask(() -> {
                dockerRuntime.getAgent().removeVolume(volumeName);
                LOG.info("Volume is removed: " + volumeName);
                return true;
            });
        }
        catch (WrappedNotFoundException e) {
            LOG.warn("Volume not found: " + volumeName);
            return true;
        }
        catch (ServerRuntimeException e) {
            Matcher matcher;
            if (isForce && (matcher = VOLUME_IS_IN_USE_ERROR_REGEX.matcher(e.getMessage())).matches()) {
                return RubyDockerVolumeUtil.removeVolumeAndAssociatedContainers(volumeName, matcher.group(1).split(", "), dockerRuntime);
            }
            LOG.warn("Failed to remove volume '%s': %s".formatted(volumeName, e.getMessage()));
            throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.remove.failed", volumeName), (Throwable)e);
        }
    }

    private static boolean removeVolumeAndAssociatedContainers(@NotNull String volumeName, String @NotNull [] containerIds, @NotNull RemoteDockerRuntime dockerRuntime) throws RemoteSdkException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(13);
        }
        if (dockerRuntime == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(14);
        }
        if (containerIds == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(15);
        }
        try {
            return (Boolean)RemoteDockerRuntimeUtil.executeAgentTask(() -> {
                for (String containerId : containerIds) {
                    DockerAgentContainer container = dockerRuntime.findContainer(containerId);
                    if (container == null) {
                        LOG.warn("Container not found: " + containerId);
                        continue;
                    }
                    container.deleteContainerWithVolumes();
                }
                dockerRuntime.getAgent().removeVolume(volumeName);
                LOG.info("Volume is force removed: " + volumeName);
                return true;
            });
        }
        catch (WrappedNotFoundException e) {
            LOG.warn("Volume not found: " + volumeName);
            return true;
        }
        catch (ServerRuntimeException e) {
            LOG.warn("Failed to remove volume '%s': %s".formatted(volumeName, e.getMessage()));
            throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.remove.failed", volumeName), (Throwable)e);
        }
    }

    private static void changeDockerVolumeOwnership(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull String volumeName, @NotNull String mountPath, @NotNull String user, @NotNull RubyDockerProcessConnectionData data) throws RemoteSdkException {
        if (dockerRuntime == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(16);
        }
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(17);
        }
        if (mountPath == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(18);
        }
        if (user == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(19);
        }
        if (data == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(20);
        }
        try {
            VolumesBuilder volumesBinds = VolumesBuilder.builder().addBoundVolume(mountPath, volumeName, false);
            DockerAgentDeploymentConfigImpl config = new RubyDockerAgentDeploymentConfigImpl(data.getImage(), volumesBinds.build()).withUser(ROOT_USER).withEntrypoint(ArrayUtilRt.EMPTY_STRING_ARRAY).withCommand(new String[]{"chown", "-R", user, mountPath});
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            ProcessOutput output = applicationRuntime.startAndGetOutput();
            if (!output.checkSuccess(LOG)) {
                throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.ownership.change.failed", volumeName));
            }
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.warn("Failed to change ownership of volume '%s': %s".formatted(volumeName, e.getMessage()));
            throw new RemoteSdkException(RubyDockerBundle.message("ruby.docker.volume.ownership.change.failed", volumeName), e);
        }
    }

    private static boolean isVolumeAlreadyExists(@NotNull String volumeName, @NotNull RemoteDockerRuntime dockerRuntime) throws ServerRuntimeException {
        if (volumeName == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(21);
        }
        if (dockerRuntime == null) {
            RubyDockerVolumeUtil.$$$reportNull$$$0(22);
        }
        return (Boolean)RemoteDockerRuntimeUtil.executeAgentTask(() -> ContainerUtil.exists((Object[])dockerRuntime.getVolumes(), v -> v.getVolume().getName().equals(volumeName)));
    }

    @Contract(value="null -> false")
    private static boolean isUnderprivilegedUser(@Nullable String user) {
        return !StringUtil.isEmptyOrSpaces((String)user) && !user.equals(ROOT_USER) && !user.startsWith("root:") && !user.equals(ROOT_UID) && !user.startsWith("0:");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeName";
                break;
            }
            case 1: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mountPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeNameSuffix";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerIds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerVolumeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDockerComposeVolume";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDockerVolume";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDockerComposeVolumes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDockerVolume";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVolume";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "removeVolumeAndAssociatedContainers";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "changeDockerVolumeOwnership";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isVolumeAlreadyExists";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

