/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;

public final class RubyDockerUtil {
    public static final Key<Map<String, String>> CUSTOM_VOLUMES_KEY = Key.create((String)"RUBY_DOCKER_CUSTOM_VOLUMES");
    public static final String SERVER_PID_RELATIVE_PATH = File.separator + "tmp" + File.separator + "pids" + File.separator + "server.pid";

    public static boolean isRubyDockerSDK(@Nullable Sdk sdk) {
        if (sdk != null) {
            SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
            return RubyDockerUtil.isRubyDockerSdkAdditionalData(sdkAdditionalData);
        }
        return false;
    }

    public static boolean isRubyDockerSdkAdditionalData(@Nullable SdkAdditionalData sdkAdditionalData) {
        return RubyDockerUtil.matchesSdkAdditionalDataCredentialType(sdkAdditionalData, DockerCredentialsType.class);
    }

    public static boolean matchesSdkAdditionalDataCredentialType(SdkAdditionalData sdkAdditionalData, Class<?> credentialsTypeClass) {
        if (sdkAdditionalData instanceof RubyRemoteSdkAdditionalData) {
            return ((RubyRemoteSdkAdditionalData)sdkAdditionalData).getRemoteConnectionType().getClass().equals(credentialsTypeClass);
        }
        return false;
    }

    public static void prepareRailsProjectToStart(@NotNull String projectPath) {
        if (projectPath == null) {
            RubyDockerUtil.$$$reportNull$$$0(0);
        }
        FileUtil.asyncDelete((File)new File(projectPath + SERVER_PID_RELATIVE_PATH));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/docker/remote/ruby/RubyDockerUtil", "prepareRailsProjectToStart"));
    }
}

