/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.ruby.RubyDockerConsoleProcessHandler;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.ruby.RubyDockerProcessHandler;
import com.intellij.docker.remote.ruby.RubyDockerRunner;
import com.intellij.docker.remote.ruby.RubyDockerUtil;
import com.intellij.docker.remote.ruby.RubyDockerVolumeUtil;
import com.intellij.docker.remote.run.DockerHelpersImageCreator;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.ExtraHostsBuilder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.DockerNetworkUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubySshRemoteTransfer;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugIdeGemHelper;

public final class RubyDockerProcessUtil {
    private static final Logger LOG = Logger.getInstance(RubyDockerProcessUtil.class);
    public static final String RUBYMINE_HELPERS_IMAGE_REPOSITORY = "jetbrains_ruby_helpers";
    public static final String RUBYMINE_HELPERS_VERSION_LABEL = "com.jetbrains.rubymine_helpers.version";
    public static final String RUBYMINE_HELPERS_DIRECTORY = "/opt/.rubymine_helpers/rb";
    public static final String RUBYMINE_HELPERS_DIRECTORY_ENV = "RUBYMINE_HELPERS_DIRECTORY";
    public static final String RUBYMINE_HELPERS_SERVICE_NAME = "jetbrains_ruby_helpers";
    public static final String PORT_BINDING_HOST_IP = System.getProperty("ruby.docker.host.ip.address", InetAddress.getLoopbackAddress().getHostAddress());
    private static final DockerHelpersImageCreator myHelpersImageCreator = new DockerHelpersImageCreator("jetbrains_ruby_helpers", "com.jetbrains.rubymine_helpers.version", "/opt/.rubymine_helpers/rb", "RUBYMINE_HELPERS_DIRECTORY", "jetbrains_ruby_helpers"){

        @NotNull
        protected List<File> getHelpersRoots() {
            List list = ContainerUtil.map((Collection)RubySshRemoteTransfer.getHelpersPaths(), s -> new File((String)s));
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/ruby/RubyDockerProcessUtil$1", "getHelpersRoots"));
        }
    };

    public static DockerVolumesFrom @NotNull [] getHelpersContainerVolumesFrom(@NotNull RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(0);
        }
        DockerVolumesFrom[] dockerVolumesFromArray = myHelpersImageCreator.getHelpersContainerVolumesFrom(dockerRuntime);
        if (dockerVolumesFromArray == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(1);
        }
        return dockerVolumesFromArray;
    }

    @NotNull
    public static SharedVolume getSharedVolume(@NotNull RemoteDockerRuntime dockerRuntime) throws IOException, ServerRuntimeException {
        if (dockerRuntime == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(2);
        }
        SharedVolume sharedVolume = myHelpersImageCreator.getHelpersContainerSharedVolume(dockerRuntime);
        if (sharedVolume == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(3);
        }
        return sharedVolume;
    }

    public static RubyDockerConsoleProcessHandler startDockerConsole(@Nullable Module project, @NotNull RubyDockerProcessConnectionData data, @NotNull RubyCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(6);
        }
        DockerExecProcess process = RubyDockerProcessUtil.createDockerProcess(project, pathMapper, data, commandLine);
        return new RubyDockerConsoleProcessHandler((RemoteProcess)process, commandLine.getCommandLineString());
    }

    public static ProcessHandler startDockerProcess(@Nullable Module project, @NotNull RubyDockerProcessConnectionData data, @NotNull RubyCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(7);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(9);
        }
        DockerExecProcess process = RubyDockerProcessUtil.createDockerProcess(project, pathMapper, data, commandLine);
        return new RubyDockerProcessHandler((RemoteProcess)process, commandLine.getCommandLineString(), null);
    }

    @NotNull
    private static DockerExecProcess createDockerProcess(@Nullable Module module, @NotNull AbstractPathMapper pathMapper, @NotNull RubyDockerProcessConnectionData data, @NotNull RubyCommandLine commandLine) throws RemoteSdkException {
        DockerExecProcess dockerExecProcess;
        if (pathMapper == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(10);
        }
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(11);
        }
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(12);
        }
        if (Registry.is((String)"ruby.docker.verbose.logging")) {
            LOG.info(String.format("[DOCKER]: %s", commandLine.getCommandLineString()));
        }
        Project project = module != null ? module.getProject() : null;
        Sdk sdk = Optional.ofNullable(RubyDockerRunner.getCommandLineSdk(commandLine)).orElseGet(() -> RModuleUtil.getInstance().findRubySdkForModule(module));
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        try {
            Collection portForwardings;
            DockerCloudConfiguration account = data.getAccount();
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(account, project);
            VolumesBuilder volumesBuilder = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings);
            RubyDockerProcessUtil.addCustomVolumes((GeneralCommandLine)commandLine, volumesBuilder);
            RubyDockerAgentDeploymentConfigImpl config = new RubyDockerAgentDeploymentConfigImpl(data.getImage(), volumesBuilder.build());
            config.withEntrypoint(new String[0]);
            config.withStdinOnce(true);
            config.setupRemoteCommandLine(pathMapper, (GeneralCommandLine)commandLine);
            config.setupHelpers(dockerRuntime);
            config.setupRubyMineGemsVolumes(sdk, project, data, false);
            PortsBuilder portsBuilder = PortsBuilder.builder();
            RubyCommandLineData rubyCommandLineData = (RubyCommandLineData)commandLine.getUserData(RubyCommandLine.COMMAND_LINE_DATA_KEY);
            if (containerSettings != null) {
                portsBuilder.addPortBindings(containerSettings.getPortBindings());
            }
            if (rubyCommandLineData != null && (portForwardings = (Collection)rubyCommandLineData.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) != null) {
                portsBuilder.addPortBindings(RubyDockerProcessUtil.createPortBindings(portForwardings));
            }
            if (containerSettings != null && containerSettings.isPublishAllPorts()) {
                config.withPublishAllPorts(true);
            } else {
                config.withPortBindings(portsBuilder.buildPortBindings());
            }
            config.withExposedPorts(portsBuilder.buildExposedPorts());
            EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
            if (containerSettings != null) {
                envsBuilder.addEnvs(containerSettings.getEnvVars());
            }
            config.withEnvs(envsBuilder.withPassParentEnvironment(false).buildEnvs());
            if (containerSettings != null) {
                if (containerSettings.isNetworkDisabled()) {
                    config.withNetworkDisabled(true);
                } else if (StringUtil.isNotEmpty((String)containerSettings.getNetworkMode())) {
                    config.withNetworkMode(containerSettings.getNetworkMode());
                }
            }
            if (containerSettings != null) {
                config.withLinks(containerSettings.getLinks());
            }
            ExtraHostsBuilder extraHostsBuilder = RubyDockerProcessUtil.createExtraHostsBuilder(account);
            if (containerSettings != null) {
                extraHostsBuilder.addExtraHosts(containerSettings.getExtraHosts());
            }
            config.withExtraHosts(extraHostsBuilder.build());
            dockerExecProcess = DockerExecProcess.Factory.startProcessWithRemove((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
        }
        catch (WrappedNotFoundException e) {
            throw DockerUtil.propagateNotFoundException((ServerRuntimeException)((Object)e), (String)data.getImage());
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (dockerExecProcess == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(13);
        }
        return dockerExecProcess;
    }

    @NotNull
    public static ExtraHostsBuilder createExtraHostsBuilder(@NotNull DockerCloudConfiguration account) {
        if (account == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(14);
        }
        ExtraHostsBuilder extraHostsBuilder = ExtraHostsBuilder.builder();
        extraHostsBuilder.addExtraHosts(DockerNetworkUtil.getExplicitHostDockerInternalMappingIfRequired((DockerCloudConfiguration)account));
        ExtraHostsBuilder extraHostsBuilder2 = extraHostsBuilder;
        if (extraHostsBuilder2 == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(15);
        }
        return extraHostsBuilder2;
    }

    public static void addCustomVolumes(@NotNull GeneralCommandLine commandLine, @NotNull VolumesBuilder volumesBuilder) {
        Map customVolumes;
        if (commandLine == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(16);
        }
        if (volumesBuilder == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(17);
        }
        if ((customVolumes = (Map)commandLine.getUserData(RubyDockerUtil.CUSTOM_VOLUMES_KEY)) != null) {
            for (Map.Entry volume : customVolumes.entrySet()) {
                volumesBuilder.addBoundVolume((String)volume.getValue(), (String)volume.getKey());
            }
        }
    }

    @Nullable
    public static DockerVolumeBinding setupRubyMineGemsVolume(@Nullable Sdk sdk, @Nullable Project project, @NotNull RubyDockerProcessConnectionData data, boolean isReadOnly) throws RemoteSdkException {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(18);
        }
        if (!RubyDockerUtil.isRubyDockerSDK(sdk) || !RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return null;
        }
        LOG.debug("Creating RM gems volume for sdk: ", new Object[]{sdk});
        String volumeName = RubyDockerVolumeUtil.computeRubyMineGemsVolumeName(RubyRemoteSdkAdditionalData.from((Sdk)sdk));
        if (StringUtil.isEmpty((String)volumeName)) {
            LOG.debug("Cannot create RM gems volume for sdk: ", new Object[]{sdk});
            return null;
        }
        RubyDockerVolumeUtil.setupDockerVolume(volumeName, "/opt/.rubymine_gems", project, data);
        return new DockerVolumeBindingImpl("/opt/.rubymine_gems", volumeName, isReadOnly);
    }

    public static void removeRubyMineGemsVolume(@Nullable Sdk sdk, @Nullable Project project, @NotNull RubyDockerProcessConnectionData data) {
        if (data == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(19);
        }
        if (!RubyDockerUtil.isRubyDockerSDK(sdk) || !RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return;
        }
        LOG.debug("Removing RM gems volume for sdk: ", new Object[]{sdk});
        String volumeName = RubyDockerVolumeUtil.computeRubyMineGemsVolumeName(RubyRemoteSdkAdditionalData.from((Sdk)sdk));
        if (StringUtil.isEmpty((String)volumeName)) {
            LOG.debug("Cannot remove RM gems volume for sdk: ", new Object[]{sdk});
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> RubyDockerVolumeUtil.removeDockerVolume(volumeName, project, data, true));
    }

    @Nullable
    public static RubyDebugIdeGemHelper.BackendDebugGemType getOrInstallDebugIdeGemForDocker(@Nullable Module module, @NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(20);
        }
        if (!RubyDockerUtil.isRubyDockerSDK(sdk)) {
            LOG.warn("Failed to install debugger gems, because provided SDK is not for Docker: " + String.valueOf(sdk));
            throw new IllegalArgumentException("Docker SDK is expected, but got: " + String.valueOf(sdk));
        }
        return RubyDebugIdeGemHelper.getOrInstallDebugIdeGem((Module)module, (Sdk)sdk, (String)"/opt/.rubymine_gems", (boolean)true);
    }

    @NotNull
    public static RemoteDockerRuntime createDockerRuntime(@NotNull DockerCloudConfiguration account, @Nullable Project project) throws RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime;
        if (account == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(21);
        }
        try {
            remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)account, (Project)project);
        }
        catch (ServerRuntimeException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (remoteDockerRuntime == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(22);
        }
        return remoteDockerRuntime;
    }

    @NotNull
    private static List<DockerPortBinding> createPortBindings(@NotNull Collection<PortForwarding> portForwardings) {
        if (portForwardings == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(23);
        }
        ArrayList<DockerPortBinding> bindings = new ArrayList<DockerPortBinding>();
        for (PortForwarding portForwarding : portForwardings) {
            if (portForwarding.getDirection() != PortForwarding.Direction.REMOTE_TO_LOCAL) continue;
            DockerPortBindingImpl binding = new DockerPortBindingImpl();
            binding.setContainerPort(portForwarding.getRemotePort());
            binding.setHostPort(Integer.valueOf(portForwarding.getLocalPort()));
            binding.setHostIp(PORT_BINDING_HOST_IP);
            bindings.add((DockerPortBinding)binding);
        }
        ArrayList<DockerPortBinding> arrayList = bindings;
        if (arrayList == null) {
            RubyDockerProcessUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 13, 15, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerProcessUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBuilder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portForwardings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerProcessUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedVolume";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerProcess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraHostsBuilder";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createPortBindings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersContainerVolumesFrom";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSharedVolume";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startDockerConsole";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startDockerProcess";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDockerProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createExtraHostsBuilder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addCustomVolumes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupRubyMineGemsVolume";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeRubyMineGemsVolume";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrInstallDebugIdeGemForDocker";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDockerRuntime";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createPortBindings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 13, 15, 22, 24 -> new IllegalStateException(string);
        };
    }
}

