/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.ruby;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.IndentInfo;
import org.jetbrains.plugins.haml.lexer.HAMLLexer;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.ruby.erb.lexer.AbstractErbRubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.BaseRubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;

public final class _HAMLRubyLexer
extends AbstractErbRubyLexer {
    private static final TokenSet TOKENS = TokenSet.create((IElementType[])new IElementType[]{HAMLTokenTypes.INDENT, HAMLTokenTypes.EOL, HAMLTokenTypes.RUBY_CODE_MARKER, HAMLTokenTypes.LINE_CONTINUATION});
    private List<IndentInfo> myIndents = new ArrayList<IndentInfo>();

    public _HAMLRubyLexer(boolean inHighlightingMode) {
        super(inHighlightingMode, (Lexer)new HAMLLexer(), HAMLTokenTypes.INJECTION_CODE, HAMLTokenTypes.HAML_INJECTION_IN_RUBY);
    }

    public IElementType getTokenType() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (TOKENS.contains(tokenType)) {
            return tokenType;
        }
        return super.getTokenType();
    }

    public void advance() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (tokenType == HAMLTokenTypes.INDENT) {
            int tokenStart = this.myOtherLexer.getTokenStart();
            int tokenEnd = this.myOtherLexer.getTokenEnd();
            this.myIndents.add(new IndentInfo(tokenEnd - tokenStart, tokenStart));
        }
        if (tokenType == HAMLTokenTypes.EOL) {
            this.myIndents.add(new IndentInfo(0, this.myOtherLexer.getTokenStart()));
        }
        super.advance();
    }

    protected void resetRubyLexer(@NotNull RubyLexer rubyLexer, @NotNull CharSequence buffer, int start, int end) {
        if (rubyLexer == null) {
            _HAMLRubyLexer.$$$reportNull$$$0(0);
        }
        if (buffer == null) {
            _HAMLRubyLexer.$$$reportNull$$$0(1);
        }
        rubyLexer.start(buffer, start, end);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            _HAMLRubyLexer.$$$reportNull$$$0(2);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myIndents.clear();
    }

    protected void setupRubyLexer() {
        super.setupRubyLexer();
        ((BaseRubyLexer)((FlexAdapter)this.myRubyLexer.getDelegate()).getFlex()).setHeredocTerminatorMayBeIndented(true);
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            _HAMLRubyLexer.$$$reportNull$$$0(3);
        }
        super.restore(position);
        ArrayList<IndentInfo> newIndents = new ArrayList<IndentInfo>();
        for (IndentInfo indentInfo : this.myIndents) {
            if (indentInfo.getPosition() >= position.getOffset()) continue;
            newIndents.add(indentInfo);
        }
        this.myIndents = newIndents;
    }

    public int getState() {
        return this.myIndents.isEmpty() ? super.getState() : this.myIndents.get(this.myIndents.size() - 1).getIndent();
    }

    public int getIndent(int position) {
        return IndentInfo.getIndent(this.myIndents, (int)position);
    }

    public List<IndentInfo> getIndents() {
        return this.myIndents;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyLexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/haml/ruby/_HAMLRubyLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetRubyLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "restore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

