/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationParams;

public final class BaseCucumberRunConfigurationUtil {
    public static void inspectFeatureFileOrFolderPath(@NotNull BaseCucumberRunConfiguration conf) throws RuntimeConfigurationException {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        switch (conf.getTestType()) {
            case ALL_IN_FOLDER: {
                BaseCucumberRunConfigurationUtil.inspectFeaturesFolder(conf);
                break;
            }
            case CUSTOM_SET_OF_FILES: 
            case TEST_SCRIPT: {
                BaseCucumberRunConfigurationUtil.inspectFeatureFiles(conf);
                break;
            }
        }
    }

    private static void inspectFeaturesFolder(@NotNull BaseCucumberRunConfiguration conf) throws RuntimeConfigurationException {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        String folderPath = conf.getTestsFolderPath().trim();
        File folder = new File(folderPath);
        if (StringUtil.isEmpty((String)folderPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.folder.not.specified"));
        }
        if (!folder.exists()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.folder.not.exists"));
        }
        if (!folder.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.folder.not.dir"));
        }
    }

    private static void inspectFeatureFiles(@NotNull BaseCucumberRunConfiguration conf) throws RuntimeConfigurationException {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        String scriptPath = conf.getTestScriptPath().trim();
        if (conf.getTestScriptsPaths().isEmpty() && StringUtil.isEmpty((String)scriptPath)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.script.not.specified"));
        }
        for (String pathWithLineNumber : StringUtil.split((String)scriptPath, (String)"\n")) {
            scriptPath = BaseCucumberRunConfigurationUtil.getFilePathFromPathWithLineNumber(pathWithLineNumber);
            VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptPath);
            if (script == null || !script.exists()) {
                throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.script.not.exists", (Object[])new Object[]{scriptPath}));
            }
            if (!script.isDirectory()) continue;
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.run.configuration.test.script.is.dir", (Object[])new Object[]{scriptPath}));
        }
    }

    public static void copyParams(@NotNull CucumberRunConfigurationParams fromParams, @NotNull CucumberRunConfigurationParams toParams) {
        if (fromParams == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (toParams == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        toParams.setTestType(fromParams.getTestType());
        toParams.setTestsFolderPath(fromParams.getTestsFolderPath());
        toParams.setTestScriptPath(fromParams.getTestScriptPath());
        toParams.setTestScriptsPaths(fromParams.getTestScriptsPaths());
        toParams.setTestFileMask(fromParams.getTestFileMask());
        toParams.setFeatureElementNameFilter(fromParams.getFeatureElementNameFilter());
        toParams.setTagsFilter(fromParams.getTagsFilters());
        toParams.setRunnerOptions(fromParams.getRunnerOptions());
        toParams.setRunnerGemVersion(fromParams.getRunnerGemVersion());
        toParams.setBacktraceEnabled(fromParams.isBacktraceEnabled());
        toParams.setVerboseEnabled(fromParams.isVerboseEnabled());
        toParams.setPreloadServer(fromParams.getPreloadServer());
        toParams.setShouldUseCustomCucumberRunner(fromParams.shouldUseCustomCucumberRunner());
        toParams.setCustomCucumberRunnerPath(fromParams.getCustomCucumberRunnerPath());
    }

    public static void initConfigurationTemplateDefaultSettings(@NotNull BaseCucumberRunConfiguration conf) {
        if (conf == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(5);
        }
        conf.setTestFileMask(CucumberRunConfiguration.DEFAULT_TESTS_SEARCH_MASK);
        conf.setVerboseEnabled(true);
        conf.setRunnerOptions("--color -r features");
        conf.setShouldUseCustomCucumberRunner(false);
    }

    @NotNull
    public static String getFilePathFromPathWithLineNumber(@NotNull String pathWithLineNumber) {
        int i;
        if (pathWithLineNumber == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(6);
        }
        for (i = pathWithLineNumber.length() - 1; i >= 0 && Character.isDigit(pathWithLineNumber.charAt(i)); --i) {
        }
        if (i > 0 && pathWithLineNumber.charAt(i) == ':') {
            String string = pathWithLineNumber.substring(0, i);
            if (string == null) {
                BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = pathWithLineNumber;
        if (string == null) {
            BaseCucumberRunConfigurationUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromParams";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toParams";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathWithLineNumber";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/BaseCucumberRunConfigurationUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathFromPathWithLineNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeatureFileOrFolderPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeaturesFolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inspectFeatureFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyParams";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initConfigurationTemplateDefaultSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathFromPathWithLineNumber";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

