/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

final class CucumberStepDefinitionParameterVisitor
extends RubyInspectionVisitor {
    public static final Pattern REGEX_GROUP_REGEX = Pattern.compile("\\([^?].*?\\)");

    CucumberStepDefinitionParameterVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            CucumberStepDefinitionParameterVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitRDoBlockCall(@NotNull RDoBlockCall rDoBlockCall) {
        RPsiElement regexp;
        List arguments;
        RCall call;
        RPossibleCall possibleCall;
        if (rDoBlockCall == null) {
            CucumberStepDefinitionParameterVisitor.$$$reportNull$$$0(1);
        }
        if ((possibleCall = rDoBlockCall.getCall()) instanceof RCall && CucumberUtil.isCucumberStepDefinition((PsiElement)(call = (RCall)possibleCall)) && !(arguments = call.getArguments()).isEmpty() && (regexp = (RPsiElement)arguments.get(0)) instanceof RRegexpLiteral) {
            String regexpContent = regexp.getText();
            if (regexpContent.contains("#{")) {
                return;
            }
            regexpContent = regexpContent.replaceAll("\\\\\\(", "").replaceAll("\\\\\\)", "");
            Matcher matcher = REGEX_GROUP_REGEX.matcher(regexpContent);
            int paramCount = 0;
            while (matcher.find()) {
                ++paramCount;
            }
            RBlockArgumentList rBlockVariables = rDoBlockCall.getBlock().getBlockArguments();
            if (rBlockVariables == null) {
                if (paramCount != 0) {
                    this.registerProblem((PsiElement)regexp, RBundle.message((String)"inspection.step.definition.parameter.count.message"));
                }
            } else {
                int numberOfArguments = rBlockVariables.getArguments().size();
                if (paramCount != numberOfArguments && paramCount + 1 != numberOfArguments) {
                    this.registerProblem((PsiElement)regexp, RBundle.message((String)"inspection.step.definition.parameter.count.message"));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDoBlockCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/inspections/CucumberStepDefinitionParameterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDoBlockCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

