/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.MapParameterTypeManager;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;
import org.jetbrains.plugins.ruby.cucumber.ruby.CucumberParameterTypeCallType;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberCallType;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberParameterTypeData;
import org.jetbrains.plugins.ruby.cucumber.ruby.RubyCucumberParameterTypeIndex;
import org.jetbrains.plugins.ruby.cucumberApi.RubyCucumberUtil;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public final class CucumberUtil {
    @NonNls
    private static final String CUCUMBER_RAILS_SCRIPT_NAME = "cucumber";
    @NonNls
    public static final String CUCUMBER_GEM_NAME = "cucumber";
    @NonNls
    private static final String CUCUMBER_RAILS_GEM_NAME = "cucumber-rails";
    @NonNls
    private static final String[] CUCUMBER_GEM_NAMES = new String[]{"cucumber"};
    @NonNls
    private static final String[] CUCUMBER_RAILS_GEM_NAMES = new String[]{"cucumber-rails"};
    @NonNls
    private static final String[] CUCUMBER_RAILS_PLUGIN_NAMES = new String[]{"cucumber-rails"};
    @NonNls
    private static final String CUCUMBER_GEM_EXECUTABLE = "cucumber";
    @NonNls
    static final String CUCUMBER_OPTS_ENV_KEY = "CUCUMBER_OPTS";
    @NonNls
    public static final String INIT_GENERATOR_NAME = "cucumber:install";
    private static final String[] CUCUMBER_PLUGIN_NAMES = new String[]{"cucumber"};
    private static final String GENERATOR_SPORK_OPTION = "--spork";
    private static final String GENERATOR_RSPEC_OPTION = "--rspec";
    private static final String GENERATOR_CAPYBARA_OPTION = "--capybara";
    private static final String GENERATOR_WEBRAT_OPTION = "--webrat";
    private static final String GENERATOR_TESTUNIT_OPTION = "--testunit";
    public static final String CUCUMBER_COLOR_MODE_OPTION = "--color";

    private CucumberUtil() {
    }

    public static boolean isCucumberScriptSupportInstalledInRailsProject(@NotNull Module module) {
        String appHomeDirPathUrl;
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(0);
        }
        return (appHomeDirPathUrl = RailsFacetUtil.getRailsAppHomeDirUrl((Module)module)) == null || CucumberUtil.getRailsCucumberScriptExecutablePath(module) != null;
    }

    @Nullable
    private static String getRailsCucumberScriptExecutablePath(@NotNull Module module) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(1);
        }
        return RailsUtil.getRailsScriptExecutablePath((Module)module, (String)"cucumber");
    }

    public static boolean isCucumberRailsSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            CucumberUtil.$$$reportNull$$$0(3);
        }
        if (!RailsFacetUtil.hasRailsSupport((Module)module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportProbablyEnabled((Module)module, (Sdk)sdk, (String[])CUCUMBER_RAILS_GEM_NAMES, (String[])CUCUMBER_RAILS_PLUGIN_NAMES);
    }

    public static boolean isCucumberSupportEnabled(@NotNull Module module) {
        GemInfo gemInfo;
        boolean supportEnabled;
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(4);
        }
        if ((supportEnabled = GemUtil.isGemOrRailsPluginSupportEnabled((Module)module, (String[])CUCUMBER_GEM_NAMES, (String[])CUCUMBER_PLUGIN_NAMES)) && (gemInfo = CucumberUtil.getAttachedCucumberGem(module)) != null) {
            return CucumberUtil.checkIfVersionIsSupported(gemInfo.getVersion());
        }
        return supportEnabled;
    }

    @Nullable
    public static GemInfo getAttachedCucumberGem(@NotNull Module module) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(5);
        }
        return RubyProjectGemSearchService.Companion.findGem(module, "cucumber");
    }

    @Nullable
    public static GemInfo findLatestCucumberGemIn(@Nullable Module module, @Nullable Sdk sdk) {
        return sdk == null ? null : RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)"cucumber");
    }

    public static boolean checkIfVersionIsSupported(String cucmberGemVersion) {
        return VersionComparatorUtil.compare((String)cucmberGemVersion, (String)CucumberUtil.getMinimalSupportedVersion()) >= 0;
    }

    public static String getMinimalSupportedVersion() {
        return "0.3.7";
    }

    @Nullable
    public static String determinePreferredCucumberExecutablePath(@Nullable Module module, @Nullable Sdk alternativeSdk) {
        Sdk sdk;
        String cucumberCreatedByGenerator;
        if (module != null && RailsFacetUtil.hasRailsSupport((Module)module) && (cucumberCreatedByGenerator = CucumberUtil.getRailsCucumberScriptExecutablePath(module)) != null) {
            return cucumberCreatedByGenerator;
        }
        Object object = alternativeSdk == null ? (module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null) : (sdk = alternativeSdk);
        if (sdk != null) {
            return CucumberUtil.getCucumberGemExecutablePath(module, sdk);
        }
        return null;
    }

    @Nullable
    private static String getCucumberGemExecutablePath(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            CucumberUtil.$$$reportNull$$$0(6);
        }
        return RubyGemExecutionContext.getScriptPath((Sdk)sdk, (Module)module, (String)"cucumber", (String)"cucumber");
    }

    public static String getArguments(boolean useRSpec, boolean useSpork, boolean capybaraBackend) {
        StringBuilder buf = new StringBuilder();
        buf.append(useRSpec ? GENERATOR_RSPEC_OPTION : GENERATOR_TESTUNIT_OPTION);
        if (useSpork) {
            buf.append(' ').append(GENERATOR_SPORK_OPTION);
        }
        buf.append(' ').append(capybaraBackend ? GENERATOR_CAPYBARA_OPTION : GENERATOR_WEBRAT_OPTION);
        return buf.toString();
    }

    @Nullable
    public static String determineCurrentScenarioName(@NotNull PsiElement element) {
        GherkinStepsHolder parentScenario;
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(7);
        }
        if ((parentScenario = (GherkinStepsHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GherkinStepsHolder.class})) == null) {
            return null;
        }
        return parentScenario instanceof GherkinScenario && ((GherkinScenario)parentScenario).isBackground() ? null : parentScenario.getScenarioName();
    }

    public static boolean isParameterTypeDeclaration(@Nullable PsiElement element) {
        if (!(element instanceof RCall)) {
            return false;
        }
        RCall call = (RCall)element;
        return call.getCallType() instanceof CucumberParameterTypeCallType;
    }

    public static boolean isCucumberStepDefinition(@Nullable PsiElement element) {
        if (element instanceof RDoBlockCall) {
            element = ((RDoBlockCall)element).getCall();
        }
        if (element instanceof RCall) {
            RCall call = (RCall)element;
            return call.getCallType() instanceof RubyCucumberCallType;
        }
        return false;
    }

    @Nullable
    public static String getStepNameFromStepCall(@NotNull PsiElement element) {
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(8);
        }
        if (element instanceof RBaseString) {
            return ((RBaseString)element).getContent();
        }
        if (element instanceof RRegexpLiteral) {
            return ((RRegexpLiteral)element).getContent();
        }
        return null;
    }

    @Nullable
    @NlsSafe
    public static String getCucumberStepDefinitionName(@Nullable PsiElement element) {
        RCall call = CucumberUtil.getStepCall(element);
        if (element != null && call != null) {
            if (call.getParent() instanceof RDoBlockCall) {
                return CucumberUtil.getDescriptiveName(element.getParent());
            }
            PsiElement parameter = (PsiElement)call.getArguments().get(0);
            return CucumberUtil.getStepNameFromStepCall(parameter);
        }
        return null;
    }

    @NotNull
    private static String getDescriptiveName(@NotNull PsiElement element) {
        ItemPresentation presentation;
        String res;
        if (element == null) {
            CucumberUtil.$$$reportNull$$$0(9);
        }
        if ((res = DescriptiveNameUtil.getDescriptiveName((PsiElement)element)).isEmpty() && element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            String string = StringUtil.notNullize((String)presentation.getPresentableText());
            if (string == null) {
                CucumberUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = res;
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static RCall getStepCall(@Nullable PsiElement element) {
        RCall call;
        if (element instanceof RDoBlockCall) {
            element = ((RDoBlockCall)element).getCall();
        }
        RCall rCall = call = element instanceof RCall ? (RCall)element : (RCall)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, RCall.class);
        if (call != null && call.getCallType() instanceof RubyCucumberCallType) {
            return call;
        }
        return null;
    }

    @Nullable
    public static RCall getStepInvocation(PsiElement element) {
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class);
        if (call != null && !call.getArguments().isEmpty() && RubyCucumberUtil.CUCUMBER_STEP_PREFIXES.contains(call.getCommand())) {
            return call;
        }
        return null;
    }

    public static List<AbstractStepDefinition> getSameStepDefinitionList(@NotNull PsiElement stepDefinition) {
        PsiElement patternElement;
        RCall call;
        Module module;
        if (stepDefinition == null) {
            CucumberUtil.$$$reportNull$$$0(12);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)stepDefinition)) != null && (call = CucumberUtil.getStepCall(stepDefinition)) != null && call.getArguments().size() == 1 && (patternElement = (PsiElement)call.getArguments().get(0)) instanceof RRegexpLiteral) {
            RRegexpLiteral regexp = (RRegexpLiteral)patternElement;
            return CucumberStepHelper.findStepDefinitionsByPattern((String)regexp.getContent(), (Module)module);
        }
        return new ArrayList<AbstractStepDefinition>();
    }

    public static ParameterTypeManager getAllParameterTypes(@NotNull Module module) {
        PsiDirectory psiDirectory;
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(13);
        }
        Project project = module.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        PsiDirectory psiDirectory2 = psiDirectory = projectDir != null ? manager.findDirectory(projectDir) : null;
        if (psiDirectory != null) {
            return (ParameterTypeManager)CachedValuesManager.getCachedValue((PsiElement)psiDirectory, () -> CachedValueProvider.Result.create((Object)CucumberUtil.doGetAllParameterTypes(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return MapParameterTypeManager.DEFAULT;
    }

    @NotNull
    private static MapParameterTypeManager doGetAllParameterTypes(@NotNull Module module) {
        if (module == null) {
            CucumberUtil.$$$reportNull$$$0(14);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Project project = module.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        Collection parameterTypeDeclarations = (Collection)ReadAction.compute(() -> RubyCucumberParameterTypeIndex.getInstance().getElements(project, (SearchScope)scope, "ParameterType"));
        for (RCall parameterTypeCall : parameterTypeDeclarations) {
            RubyCallType rubyCallType;
            if (parameterTypeCall == null || !((rubyCallType = parameterTypeCall.getCallType()) instanceof CucumberParameterTypeCallType)) continue;
            CucumberParameterTypeCallType parameterTypeCallType = (CucumberParameterTypeCallType)rubyCallType;
            RubyCucumberParameterTypeData parameterTypeCallData = (RubyCucumberParameterTypeData)parameterTypeCall.getData(new RubyCallType[]{parameterTypeCallType});
            resultMap.put(parameterTypeCallData.getName(), parameterTypeCallData.getRegexp());
        }
        resultMap.putAll(org.jetbrains.plugins.cucumber.CucumberUtil.STANDARD_PARAMETER_TYPES);
        return new MapParameterTypeManager(resultMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/CucumberUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/CucumberUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberScriptSupportInstalledInRailsProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRailsCucumberScriptExecutablePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberRailsSupportProbablyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberSupportEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedCucumberGem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberGemExecutablePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentScenarioName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStepNameFromStepCall";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSameStepDefinitionList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllParameterTypes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetAllParameterTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

