/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class CucumberRubyParameterTypeReference
implements PsiReference {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final TextRange myTextRange;

    public CucumberRubyParameterTypeReference(@NotNull PsiElement element, @NotNull TextRange textRange) {
        if (element == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myTextRange = textRange;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        String parameterTypeName = this.getParameterTypeName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module == null) {
            return null;
        }
        ParameterTypeManager parameterTypeManager = CucumberUtil.getAllParameterTypes(module);
        PsiElement parameterTypeDeclaration = parameterTypeManager.getParameterTypeDeclaration(parameterTypeName);
        if (!(parameterTypeDeclaration instanceof RCall)) {
            return null;
        }
        RCall call = (RCall)parameterTypeDeclaration;
        for (RPsiElement arg : call.getArguments()) {
            RAssoc assoc;
            if (!(arg instanceof RAssoc) || !StringUtil.equals((CharSequence)(assoc = (RAssoc)arg).getKeyText(), (CharSequence)"name")) continue;
            return assoc.getValue();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getParameterTypeName();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(5);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(6);
        }
        if (!(element instanceof RStringLiteral)) {
            return false;
        }
        String content = ((RStringLiteral)element).getContent();
        return StringUtil.equals((CharSequence)this.getParameterTypeName(), (CharSequence)content);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    private String getParameterTypeName() {
        String string = this.getRangeInElement().substring(this.myElement.getText());
        if (string == null) {
            CucumberRubyParameterTypeReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/CucumberRubyParameterTypeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/CucumberRubyParameterTypeReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7 -> new IllegalStateException(string);
        };
    }
}

