/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.intelliLang;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionPerformer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.FallbackInjectionPerformer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.injection.RubySimpleInjection;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.RStringLiteralBase;

public final class RubyLanguageInjectionPerformer
implements LanguageInjectionPerformer {
    private static final String MISSING_VALUE = "missingValue";

    public boolean isPrimary() {
        return true;
    }

    public boolean performInjection(@NotNull MultiHostRegistrar registrar, @NotNull Injection injection, @NotNull PsiElement context) {
        RubySimpleInjection rubyInjection;
        boolean success;
        RStringLiteralBase literal;
        PsiLanguageInjectionHost host;
        if (registrar == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(0);
        }
        if (injection == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(2);
        }
        if (!(context instanceof PsiLanguageInjectionHost) || !(host = (PsiLanguageInjectionHost)context).isValidHost()) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        Language language = InjectorUtils.getLanguageByString((String)injection.getInjectedLanguageId());
        LanguageInjectionSupport support = (LanguageInjectionSupport)ContainerUtil.getFirstItem((Collection)InjectorUtils.getActiveInjectionSupports());
        if (file == null || language == null || support == null) {
            return false;
        }
        if (context instanceof RStringLiteralBase && (literal = (RStringLiteralBase)context).hasExpressionSubstitutions()) {
            List<InjectorUtils.InjectionInfo> ranges = RubyLanguageInjectionPerformer.createInjectionRanges(injection, literal);
            InjectorUtils.registerInjection((Language)language, (PsiFile)file, ranges, (MultiHostRegistrar)registrar, it -> {
                InjectorUtils.registerSupport((MultiHostRegistrar)it, (LanguageInjectionSupport)support, (boolean)false);
                it.frankensteinInjection(true);
            });
            return true;
        }
        FallbackInjectionPerformer fallback = FallbackInjectionPerformer.getInstance();
        boolean bl = success = fallback != null && fallback.performInjection(registrar, injection, context);
        if (success && injection instanceof RubySimpleInjection && (rubyInjection = (RubySimpleInjection)injection).isFrankenstein()) {
            InjectorUtils.putInjectedFileUserData((PsiElement)context, (Language)language, (Key)InjectedLanguageManager.FRANKENSTEIN_INJECTION, (Object)true);
        }
        return success;
    }

    @NotNull
    private static InjectorUtils.InjectionInfo createInjectionRange(@NotNull Injection injection, @NotNull PsiLanguageInjectionHost context, @NotNull String suffix, @NotNull TextRange range) {
        if (injection == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(5);
        }
        if (range == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(6);
        }
        return new InjectorUtils.InjectionInfo(context, InjectedLanguage.create((String)injection.getInjectedLanguageId(), (String)"", (String)suffix, (boolean)true), range);
    }

    @NotNull
    private static List<InjectorUtils.InjectionInfo> createInjectionRanges(@NotNull Injection injection, @NotNull RStringLiteralBase context) {
        if (injection == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(8);
        }
        ArrayList<InjectorUtils.InjectionInfo> ranges = new ArrayList<InjectorUtils.InjectionInfo>();
        List content = context.getPsiContent();
        for (int i = 0; i < content.size(); ++i) {
            PsiElement item = (PsiElement)content.get(i);
            if (item instanceof RExpressionSubstitution) {
                if (ranges.isEmpty()) {
                    ranges.add(RubyLanguageInjectionPerformer.createInjectionRange(injection, (PsiLanguageInjectionHost)context, MISSING_VALUE, TextRange.from((int)item.getTextRangeInParent().getStartOffset(), (int)0)));
                    continue;
                }
                if (i != content.size() - 1) continue;
                ranges.add(RubyLanguageInjectionPerformer.createInjectionRange(injection, (PsiLanguageInjectionHost)context, "", TextRange.from((int)item.getTextRangeInParent().getEndOffset(), (int)0)));
                continue;
            }
            while (i + 1 < content.size() && !(content.get(i + 1) instanceof RExpressionSubstitution)) {
                ++i;
            }
            int startOffset = item.getTextRangeInParent().getStartOffset();
            int endOffset = ((PsiElement)content.get(i)).getTextRangeInParent().getEndOffset();
            String suffix = ContainerUtil.findInstance(content.subList(i, content.size()), RExpressionSubstitution.class) != null ? MISSING_VALUE : "";
            ranges.add(RubyLanguageInjectionPerformer.createInjectionRange(injection, (PsiLanguageInjectionHost)context, suffix, new TextRange(startOffset, endOffset)));
        }
        List<InjectorUtils.InjectionInfo> list = Collections.unmodifiableList(ranges);
        if (list == null) {
            RubyLanguageInjectionPerformer.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/intelliLang/RubyLanguageInjectionPerformer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/intelliLang/RubyLanguageInjectionPerformer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInjection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInjectionRange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInjectionRanges";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

