/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.rubyShared;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.MissingGemNotificationWithFix;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class CreatePuppetModuleHelper {
    public static final Pattern PUPPET_USER_NAME_PATTERN = Pattern.compile("\\w+");
    public static final Pattern PUPPET_MODULE_NAME_PATTERN = Pattern.compile("[a-z][a-z0-9_]*");
    public static final String GEM_NAME = "puppet";
    private static final String GEM_SCRIPT_NAME = "puppet";
    private static final Logger LOG = Logger.getInstance(CreatePuppetModuleHelper.class);

    public static void createModule(final @NotNull Module fileModule, final @NotNull VirtualFile rootDirectory, final @NotNull String name) {
        if (fileModule == null) {
            CreatePuppetModuleHelper.$$$reportNull$$$0(0);
        }
        if (rootDirectory == null) {
            CreatePuppetModuleHelper.$$$reportNull$$$0(1);
        }
        if (name == null) {
            CreatePuppetModuleHelper.$$$reportNull$$$0(2);
        }
        final Project project = fileModule.getProject();
        final Sdk fileSdk = RModuleUtil.getInstance().findRubySdkForModule(fileModule);
        if (fileSdk == null) {
            return;
        }
        MissingGemNotificationWithFix.checkGemExecPresenceOrInstall((Module)fileModule, (Sdk)fileSdk, (String)"puppet", success -> new Task.Backgroundable(project, PuppetBundle.message((String)"puppet.create.module.progress", (Object[])new Object[]{name}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    LOG.info("Creating puppet module " + name);
                    ProcessOutput output = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create((Sdk)fileSdk, (String)"puppet").withGemScriptName("puppet").withModule(fileModule)).withWorkingDir(rootDirectory)).withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(true))).withArguments(new String[]{"module", "generate", "--skip-interview", name})).executeScript();
                    if (output != null && output.getExitCode() != 0) {
                        String stdout;
                        String errorHeader = PuppetBundle.message((String)"puppet.external.script.error.header", (Object[])new Object[]{output.getExitCode()});
                        LOG.info(errorHeader);
                        String stderr = output.getStderr();
                        if (Strings.isNotEmpty((String)stderr)) {
                            LOG.info("STDERR: " + stderr);
                        }
                        if (Strings.isNotEmpty((String)(stdout = output.getStdout()))) {
                            LOG.info("STDOUT: " + stdout);
                        }
                        @NlsSafe String notificationText = XmlStringUtil.wrapInHtmlTag((String)stderr, (String)"pre");
                        Notifications.Bus.notify((Notification)new Notification("PUPPET_ERROR", errorHeader, notificationText, NotificationType.ERROR));
                        return;
                    }
                }
                catch (ExecutionException e) {
                    LOG.error(e.getMessage());
                    return;
                }
                rootDirectory.refresh(false, false);
                VirtualFile moduleDirectory = rootDirectory.findFileByRelativePath(name.substring(name.indexOf(45) + 1));
                if (moduleDirectory == null) {
                    return;
                }
                VirtualFile moduleMetaFile = moduleDirectory.findFileByRelativePath("metadata.json");
                if (moduleMetaFile != null) {
                    ApplicationManager.getApplication().invokeLater(() -> OpenFileAction.openFile((VirtualFile)moduleMetaFile, (Project)project), ModalityState.nonModal());
                }
                VcsFileUtil.addFilesToVcsWithConfirmation((Project)project, (VirtualFile[])new VirtualFile[]{moduleDirectory});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/puppet/rubyShared/CreatePuppetModuleHelper$1", "run"));
            }
        }.queue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/puppet/rubyShared/CreatePuppetModuleHelper";
        objectArray[2] = "createModule";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

