/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.survey;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.PlatformUtils;
import java.awt.Desktop;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/ruby/survey/RubySurveyNotificationActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "fullVersionAndLink", "Lkotlin/Pair;", "", "surveyNotificationAnsweredKey", "surveyNotificationGroup", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rubymine.customization"})
public final class RubySurveyNotificationActivity
implements ProjectActivity {
    @NotNull
    private final Pair<String, String> fullVersionAndLink = new Pair((Object)"2023.2 EAP", (Object)"https://surveys.jetbrains.com/s3/rubymine-2023-2-eap-survey");
    @NotNull
    private final String surveyNotificationAnsweredKey = "ruby.survey.notification.answered." + this.fullVersionAndLink.getFirst();
    @NotNull
    private final String surveyNotificationGroup;

    public RubySurveyNotificationActivity() {
        this.surveyNotificationGroup = "RubyMine survey notification";
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Desktop desktop;
        if (!PlatformUtils.isRubyMine()) {
            return Unit.INSTANCE;
        }
        Application app = ApplicationManager.getApplication();
        if (!app.isEAP() || app.isHeadlessEnvironment()) {
            return Unit.INSTANCE;
        }
        Pair<String, String> pair = this.fullVersionAndLink;
        String fullVersion = (String)pair.component1();
        String surveyLink = (String)pair.component2();
        if (!Intrinsics.areEqual((Object)fullVersion, (Object)ApplicationInfo.getInstance().getFullVersion())) {
            return Unit.INSTANCE;
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
            return Unit.INSTANCE;
        }
        PropertiesComponent appProperties = PropertiesComponent.getInstance();
        if (appProperties.isTrueValue(this.surveyNotificationAnsweredKey)) {
            return Unit.INSTANCE;
        }
        Object object = new Object[]{fullVersion};
        String string = RBundle.message((String)"notification.survey.title", (Object[])object);
        object = new Object[]{fullVersion};
        Notification notification = new Notification(this.surveyNotificationGroup, string, RBundle.message((String)"notification.survey.body", (Object[])object), NotificationType.INFORMATION);
        object = RBundle.message((String)"notification.survey.answer.yes");
        notification.addAction((AnAction)new DumbAwareAction(desktop, surveyLink, appProperties, this, notification, (String)object){
            final /* synthetic */ Desktop $desktop;
            final /* synthetic */ String $surveyLink;
            final /* synthetic */ PropertiesComponent $appProperties;
            final /* synthetic */ RubySurveyNotificationActivity this$0;
            final /* synthetic */ Notification $notification;
            {
                this.$desktop = $desktop;
                this.$surveyLink = $surveyLink;
                this.$appProperties = $appProperties;
                this.this$0 = $receiver;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$desktop.browse(new URI(this.$surveyLink));
                this.$appProperties.setValue(RubySurveyNotificationActivity.access$getSurveyNotificationAnsweredKey$p(this.this$0), true);
                this.$notification.expire();
            }
        });
        object = RBundle.message((String)"notification.survey.answer.no");
        notification.addAction((AnAction)new DumbAwareAction(appProperties, this, notification, (String)object){
            final /* synthetic */ PropertiesComponent $appProperties;
            final /* synthetic */ RubySurveyNotificationActivity this$0;
            final /* synthetic */ Notification $notification;
            {
                this.$appProperties = $appProperties;
                this.this$0 = $receiver;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$appProperties.setValue(RubySurveyNotificationActivity.access$getSurveyNotificationAnsweredKey$p(this.this$0), true);
                this.$notification.expire();
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getSurveyNotificationAnsweredKey$p(RubySurveyNotificationActivity $this) {
        return $this.surveyNotificationAnsweredKey;
    }
}

