/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.settings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;
import org.jetbrains.plugins.ruby.ruby.module.ui.loadPath.RLoadPathChooserPanel;

public class RubyLoadPathConfigurable
implements Configurable {
    private final Module myModule;
    private RLoadPathChooserPanel myRLoadPathChooserPanel;
    private List<String> myLoadPaths;

    public RubyLoadPathConfigurable(Module module) {
        this.myModule = module;
    }

    public String getDisplayName() {
        return RBundle.message((String)"module.settings.dialog.load.path.tab.title");
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.ruby.load.path";
    }

    public JComponent createComponent() {
        this.myLoadPaths = new ArrayList<String>(RubyModuleSettings.getInstance((Module)this.myModule).getLoadPaths());
        this.myRLoadPathChooserPanel = new RLoadPathChooserPanel(this.myLoadPaths, this.myModule.getProject());
        return this.myRLoadPathChooserPanel.getContentPane();
    }

    public boolean isModified() {
        return this.myRLoadPathChooserPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myRLoadPathChooserPanel.apply();
        RubyModuleSettings.getInstance((Module)this.myModule).setLoadPathDirs(this.myLoadPaths);
    }

    public void reset() {
        this.myRLoadPathChooserPanel.reset();
    }
}

