/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ruby.RubyProfilerBundle;
import com.intellij.profiler.ruby.configuration.RbSpyProfilerConfigurationState;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RubyProfilerSettingsPanel {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myRbSpyExecutableTextField;
    private JCheckBox myProfileSubprocessCheckBox;
    private IntegerField myFrequencyIntegerField;
    private JBLabel myRbSpyExecutableExplanation;

    public RubyProfilerSettingsPanel(@NotNull RbSpyProfilerConfigurationState configurationState) {
        if (configurationState == null) {
            RubyProfilerSettingsPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myRbSpyExecutableTextField.setText(configurationState.getExecutablePathOrFindInPath());
        this.myProfileSubprocessCheckBox.setSelected(configurationState.getShouldProfilerSubprocess());
        this.myRbSpyExecutableTextField.addBrowseFolderListener(null, new FileChooserDescriptor(true, false, false, false, false, false).withTitle(RubyProfilerBundle.message("profiler.ruby.executable.browse.title", new Object[0])));
        if (SystemInfo.isWindows) {
            this.myProfileSubprocessCheckBox.setEnabled(false);
        }
        this.myFrequencyIntegerField.setText(String.valueOf(configurationState.getSamplingFrequency()));
        this.myRbSpyExecutableExplanation.setText(RubyProfilerBundle.message("profiler.ruby.settings.rbspy.executable.explanation", "0.3.5"));
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    @NotNull
    public String getExecutablePath() {
        String string = this.myRbSpyExecutableTextField.getText();
        if (string == null) {
            RubyProfilerSettingsPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setExecutablePath(@NlsSafe @Nullable String executablePath) {
        this.myRbSpyExecutableTextField.setText(StringUtil.notNullize((String)executablePath));
    }

    public int getFrequency() {
        return Integer.parseInt(this.myFrequencyIntegerField.getText());
    }

    public void setSamplingFrequency(int frequency) {
        this.myFrequencyIntegerField.setText(String.valueOf(frequency));
    }

    public boolean getProfileSubprocess() {
        return this.myProfileSubprocessCheckBox.isSelected();
    }

    public void setProfileSubprocess(boolean profileSubprocess) {
        this.myProfileSubprocessCheckBox.setSelected(profileSubprocess);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/ui/RubyProfilerSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/ui/RubyProfilerSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        IntegerField integerField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RubyProfilerBundle", RubyProfilerSettingsPanel.class).getString("profiler.ruby.settings.executable.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myProfileSubprocessCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RubyProfilerBundle", RubyProfilerSettingsPanel.class).getString("profiler.ruby.settings.subprocess.label"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RubyProfilerBundle", RubyProfilerSettingsPanel.class).getString("profiler.ruby.settings.rate.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFrequencyIntegerField = integerField = new IntegerField();
        jPanel2.add((Component)integerField, new GridConstraints(0, 0, 2, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RubyProfilerBundle", RubyProfilerSettingsPanel.class).getString("profiler.ruby.settings.rate.tooltip"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbSpyExecutableTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRbSpyExecutableExplanation = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

