/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby.configuration;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbSpyProfilerConfigurationState
implements ProfilerConfigurationState {
    static int DEFAULT_FREQUENCY = 97;
    public static final boolean DEFAULT_SHOULD_PROFILE_SUBPROCESSES = !SystemInfo.isWindows;
    @NotNull
    private volatile String myName;
    private volatile int mySamplingFrequency;
    @Nullable
    private volatile String myExecutablePath;
    private volatile boolean myShouldProfileSubprocess;

    public RbSpyProfilerConfigurationState() {
        this.myName = "<unnamed>";
        this.mySamplingFrequency = DEFAULT_FREQUENCY;
        this.myExecutablePath = null;
        this.myShouldProfileSubprocess = DEFAULT_SHOULD_PROFILE_SUBPROCESSES;
    }

    public RbSpyProfilerConfigurationState(@NotNull String name) {
        if (name == null) {
            RbSpyProfilerConfigurationState.$$$reportNull$$$0(0);
        }
        this.myName = "<unnamed>";
        this.mySamplingFrequency = DEFAULT_FREQUENCY;
        this.myExecutablePath = null;
        this.myShouldProfileSubprocess = DEFAULT_SHOULD_PROFILE_SUBPROCESSES;
        this.myName = name;
    }

    @NotNull
    public String getConfigurationTypeId() {
        return "RbSpyProfilerConfigurationType";
    }

    @Attribute(value="name")
    @NotNull
    public String getDisplayName() {
        String string = this.myName;
        if (string == null) {
            RbSpyProfilerConfigurationState.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setDisplayName(@Nullable String name) {
        this.myName = StringUtil.notNullize((String)name, (String)"<unnamed>");
    }

    @Attribute(value="SAMPLING_FREQUENCY")
    public int getSamplingFrequency() {
        return this.mySamplingFrequency;
    }

    public void setSamplingFrequency(int frequency) {
        this.mySamplingFrequency = frequency;
    }

    @Attribute(value="EXECUTABLE_PATH")
    @Nullable
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    public void setExecutablePath(@Nullable String executablePath) {
        this.myExecutablePath = executablePath;
    }

    @Attribute(value="PROFILE_SUBPROCESS")
    public boolean getShouldProfilerSubprocess() {
        return this.myShouldProfileSubprocess;
    }

    public void setShouldProfilerSubprocess(boolean shouldProfileSubprocess) {
        this.myShouldProfileSubprocess = shouldProfileSubprocess;
    }

    @NlsSafe
    @Nullable
    public String getExecutablePathOrFindInPath() {
        String path = this.getExecutablePath();
        return path != null ? path : RbSpyProfilerConfigurationState.findRbSpyExecutableInPath();
    }

    @Nullable
    private static String findRbSpyExecutableInPath() {
        File rbSpyFile = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? "rbspy.exe" : "rbspy"));
        return rbSpyFile != null ? rbSpyFile.getPath() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RbSpyProfilerConfigurationState)) {
            return false;
        }
        RbSpyProfilerConfigurationState state = (RbSpyProfilerConfigurationState)o;
        return this.mySamplingFrequency == state.mySamplingFrequency && this.myShouldProfileSubprocess == state.myShouldProfileSubprocess && this.myName.equals(state.myName) && Objects.equals(this.myExecutablePath, state.myExecutablePath);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.mySamplingFrequency, this.myExecutablePath, this.myShouldProfileSubprocess);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/configuration/RbSpyProfilerConfigurationState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/configuration/RbSpyProfilerConfigurationState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

